/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: bitcount.c,v 2.1 1995/12/12 19:53:19 donn Exp $
 */

#include <sys/param.h>
#include <common/libkern.h>

#if NBBY != 8
#error This code assumes a byte size of 8 bits.
#endif

const unsigned char bitcnt[256] = {
	0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
	1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
	1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
	1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
	2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
	3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
	3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
	4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 
};

#define	INTBYTES	(sizeof(unsigned int) / sizeof(unsigned char))

/*
 * Determine the number of '1' bits in mask
 * (also known as a population count, popcount).
 */
int
bitcount(mask)
        unsigned int mask;
{
        register int count;
#if 0
	unsigned char *p = (unsigned char *) &mask;
#endif

#if 0
        if (mask == 0)
                return (0);
#endif
	/*
	 * We count on the compiler to eliminate dead code;
	 * we have unrolled loops for 4- or 8-byte ints,
	 * and backstop code for any other size.
	 */
	if (INTBYTES == 4)
		return (bitcnt[mask >> 24] +
			bitcnt[(mask >> 16) & 0xff] +
			bitcnt[(mask >> 8) & 0xff] +
			bitcnt[mask & 0xff]);
#if 0
	if (INTBYTES == 8)
		count = bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p++];
		count += bitcnt[*p];
		return (count);
#endif
	/* code for any INTBYTES */
	count = 0;
	while (mask) {
		++count;
		mask &= mask - 1;	/* clear lowest order 1 bit */
	}
	return (count);
}
