/*
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI ipcrm.c,v 1.1 1995/12/19 23:57:21 donn Exp
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <err.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

extern char *__progname;

void
usage()
{

	errx(1, "usage: %s [-m shmid] [-M shmkey] [-q msqid] [-Q msqkey] "
	    "[-s semid] [-S semkey] ...", __progname);
}

int
main(argc, argv)
	int argc;
	char **argv;
{
	key_t key;
	int c;
	int id;
	int rv = 0;

	opterr = 0;

	while ((c = getopt(argc, argv, "m:M:q:Q:s:S:")) != EOF) {
		key = IPC_PRIVATE;
		switch (c) {

		case 'M':
			if ((key = strtoul(optarg, 0, 0)) == IPC_PRIVATE) {
				warnx("shm key %s: can't remove private key",
				    optarg);
				rv |= 1;
				continue;
			}
			if ((id = shmget(key, 0, 0)) == -1) {
				warn("shm key %s", optarg);
				rv |= 1;
				continue;
			}
			goto shm_rmid;
		case 'm':
			id = atoi(optarg);
		shm_rmid:
			if (shmctl(id, IPC_RMID) == -1) {
				if (key != IPC_PRIVATE)
					warn("shm key %s: rmid failed", optarg);
				else
					warn("shm id %s: rmid failed", optarg);
				rv |= 1;
				continue;
			}
			break;

		case 'Q':
			if ((key = strtoul(optarg, 0, 0)) == IPC_PRIVATE) {
				warnx("msq key %s: can't remove private key",
				    optarg);
				rv |= 1;
				continue;
			}
			if ((id = msgget(key, 0)) == -1) {
				warn("msq key %s", optarg);
				rv |= 1;
				continue;
			}
			goto msq_rmid;
		case 'q':
			id = atoi(optarg);
		msq_rmid:
			if (msgctl(id, IPC_RMID) == -1) {
				if (key != IPC_PRIVATE)
					warn("msq key %s: rmid failed", optarg);
				else
					warn("msq id %s: rmid failed", optarg);
				rv |= 1;
				continue;
			}
			break;

		case 'S':
			if ((key = strtoul(optarg, 0, 0)) == IPC_PRIVATE) {
				warnx("sem key %s: can't remove private key",
				    optarg);
				rv |= 1;
				continue;
			}
			if ((id = semget(key, 0, 0)) == -1) {
				warn("sem key %s", optarg);
				rv |= 1;
				continue;
			}
			goto sem_rmid;
		case 's':
			id = atoi(optarg);
		sem_rmid:
			if (semctl(id, 0, IPC_RMID) == -1) {
				if (key != IPC_PRIVATE)
					warn("sem key %s: rmid failed", optarg);
				else
					warn("sem id %s: rmid failed", optarg);
				rv |= 1;
				continue;
			}
			break;
		}
	}

	if (argc == 1 || optind < argc)
		usage();

	return (rv);
}
