/*
 * Copyright (c) 1993,1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sco_genericops.c,v 2.3 1995/10/20 14:48:28 donn Exp
 */

/*
 * Support for generic ops
 */

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/times.h>
#include <sys/wait.h>
#include <err.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <utime.h>
#include "emulate.h"
#include "sco_ops.h"
#include "sco.h"
#include "sco_sig_state.h"

/* compat routines */
extern int creat __P((const char *, mode_t));
extern int ftime __P((struct timeb *));

int
sco_mount(devname, filename, flag)
	const char *devname;
	const char *filename;
	int flag;
{

	errx(1, "unsupported mount system call");
}

int
sco_umount(filename)
	const char *filename;
{

	errx(1, "unsupported umount system call");
}

int
sco_eaccess(path, mode)
	const char *path;
	int mode;
{

	/* hack: just use iBCS2 access() */
	return (access(path, mode));
}

int
sco_stime(timep)
	const time_t *timep;
{

	errx(1, "unsupported stime system call");
}

int
sco_uadmin(a, b, c)
	int a, b, c;
{

	errx(1, "unsupported uadmin system call");
}

int
sco_sysfs(a, b, c)
	int a, b, c;
{

	errx(1, "unsupported sysfs system call");
}

long
sco_nap(n)
	long n;
{
	struct timeval tv;

	tv.tv_sec = n / 1000;
	tv.tv_usec = (n % 1000) * 1000;

	if (select(0, NULL, NULL, NULL, &tv) == -1)
		return (-1);
	return (n);
}

int
sco_pause()
{
	sigset_t s;

	sigemptyset(&s);
	return (commit_sigsuspend(&s));
}

struct genericops generictab = {
	access,
	acct,
	0,
	alarm,
	0,
	sco_break,
	chdir,
	0,
	chmod,
	chown,
	chroot,
	sco_creat,
	sco_eaccess,
	sco_execv,
	sco_execve,
	sco_exit,
	sco_fork,
	ftime,
	0,
	0,
	0,
	0,
	0,
	0,
	sco_getgid,
	sco_getgroups,
	0,
	0,
	getitimer,
	0,
	0,
	0,
	0,
	sco_getpid,
	0,
	0,
	0,
	0,
	0,
	sco_getuid,
	kill,
	0,
	0,
	link,
	lstat,
	0,
	0,
	mkdir,
	0,
	sco_mknod,
	0,
	0,
	sco_msg,
	0,
	0,
	sco_nap,
	nice,
	sco_open,
	0,
	pathconf,
	sco_pause,
	sco_pgrpctl,
	sco_pipe,
	sco_plock,
	sco_poll,
	profil,
	sco_protctl,
	sco_ptrace,
	0,
	readlink,
	0,
	rename,
	0,
	rmdir,
	0,
	sco_mount,
	scoinfo,
	commit_select,
	0,
	0,
	sco_sem,
	0,
	0,
	0,
	setgid,
	sco_setgroups,
	0,
	0,		/* sethostname */
	setitimer,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	setuid,
	sco_shm,
	sco_sigaction,
	sco_signal,
	sigpending,
	commit_sigprocmask,
	0,
	0,
	commit_sigsuspend,
	0,
	0,
	stat,
	(int (*) __P((const char *, struct statfs *, int, int)))statfs,
	sco_stime,
	0,
	symlink,
	sync,
	sysconf,
	sco_sysfs,
	sco_sysi86,
	time,
	times,
	0,
	sco_uadmin,
	sco_ulimit,
	umask,
	sco_umount,
	sco_uname,
	unlink,
	0,
	utime,
	0,
	0,
	0,
	sco_waitpid,
};

struct genericops *generic = &generictab;
