/*
 * Copyright (c) 1993,1994,1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sco_fork.c,v 2.2 1995/07/10 18:46:06 donn Exp
 */

#include <sys/param.h>
#include <err.h>
#include <unistd.h>

#include "sco_ipc.h"

#ifdef IPC_LIBRARY

/*
 * Trickiness designed to handle semadj in BSD programs.
 */

#include <sys/syscall.h>

#define	FORK()			((pid_t)syscall(SYS_fork))
#define	SCO_FORK		fork
#define	EXECVE(p,a,e)		syscall(SYS_execve, (p), (a), (e))
#define	SCO_EXECVE		execve
#define	EXIT(n)			syscall(SYS_exit, (n))
#define	SCO_EXIT		_exit

#else

#include "emulate.h"
#include "sco.h"

#define	FORK			fork
#define	SCO_FORK		sco_fork
#define	EXECVE			execve
#define	SCO_EXECVE		sco_execve
#define	EXIT			_exit
#define	SCO_EXIT		sco_exit
#define	__ipc_init_library()

#endif

extern char **environ;

/*
 * SCO emulator support for fork/exec/exit.
 * All of these system calls must handle SEM_UNDO...
 */

pid_t
SCO_FORK()
{
	pid_t pid;
#ifdef IPC_LIBRARY
	pid_t ppid = getpid();
#endif

	__ipc_init_library();

	pid = FORK();

#ifdef IPC_LIBRARY
	/* syscall(SYS_fork) is unsugared */
	if (pid > 0 && ppid != getpid()) {
		__ipc_destroy_all_semadj();
		pid = 0;
	}
#else
	/* iBCS2 p 3-34 gives EAX/EDX values for parent/child */
	if (pid > 0)
		/* parent: EAX = child pid, EDX = 0 */
		*program_edx = 0;
	else if (pid == 0) {
		/* child: EAX = garbage, EDX = nonzero */
		*program_edx = 1;
		__ipc_destroy_all_semadj();
	}
#endif

	return (pid);
}

int
SCO_EXECVE(path, argv, envp)
	const char *path;
	char * const *argv;
	char * const *envp;
{
	int argc;
	char *argv0;
	char **ap;

	__ipc_init_library();

	environ = (char **)envp;
	__ipc_encode_semadj();
#ifndef IPC_LIBRARY
	if (curdir)
		setenv("EMULATE_PWD", curdir, 1);
	if (argv[0] && argv[0][0] == '.' && argv[0][1] == '/' &&
	    (argv0 = smalloc(strlen(curdir) + strlen(argv[0]) + 1))) {
		/*
		 * WordPerfect 6.0 'xwpinstall' seems to require that
		 * we put a full pathname into argv[0].
		 * How bizarre.
		 */
		for (ap = (char **)argv; *ap; ++ap)
			;
		argc = ap - argv;
		if (ap = smalloc((argc + 1) * sizeof (char *))) {
			bcopy(argv, ap, (argc + 1) * sizeof (char *));
			strcpy(argv0, curdir);
			strcat(argv0, ap[0]);
			ap[0] = argv0;
		}
		EXECVE(path, ap, environ);
		sfree(argv0);
		sfree(ap);
		return (-1);
	}
#endif
	return (EXECVE(path, argv, environ));
}

#ifndef IPC_LIBRARY

int
sco_execv(path, argv)
	const char *path;
	char * const *argv;
{

	SCO_EXECVE(path, argv, environ);
	return (-1);
}

#endif

void
SCO_EXIT(status)
	int status;
{

	__ipc_init_library();

	__ipc_apply_semadj();
	EXIT(status);
}
