/*
 * Copyright (c) 1993 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI    pppattach.c,v 2.3 1995/09/21 18:27:45 prb Exp
 */

/* Attach the ppp interface to the async line. */
#include <sys/param.h>
#include <sys/ioctl.h>

#include <net/pppioctl.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <paths.h>
#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <unistd.h>

static void usage __P((void));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct termios t;
	int baudrate, ch, interface, ld, line, oldld;
	char *ttyname, *e, path[MAXPATHLEN];

	baudrate = 0;
	interface = -1;
	while ((ch = getopt(argc, argv, "i:s:")) != EOF)
		switch (ch) {
		case 'i':
			interface = strtol(optarg, &e, 10);
			if (interface < 0 || *optarg == '\0' || *e != '\0')
				errx(1, "illegal interface -- %s", optarg);
			break;
		case 's':
			baudrate = strtol(optarg, &e, 10);
			if (baudrate <= 0 || *optarg == '\0' || *e != '\0')
				errx(1, "illegal baudrate -- %s", optarg);
			break;
		default:
			usage();
			/* NOTREACHED */
		}
	argc -= optind;
	argv += optind;

	if (argc != 1)
		usage();

	ttyname = *argv;
	if (*ttyname != '/') {
		(void)snprintf(path, sizeof path, "%s/%s", _PATH_DEV, *argv);
		ttyname = path;
	}

	/* Open the device. */
	if ((line = open(ttyname, O_NDELAY | O_RDWR, 0)) < 0)
		err(1, "%s", ttyname);

	/* Set line parameters. */
	if (tcgetattr(line, &t) < 0)
		err(1, "%s: tcgetattr", ttyname);
	t.c_iflag &= IXON | IXOFF;
	t.c_iflag |= IGNBRK | IGNPAR;
	t.c_oflag = 0;
	t.c_cflag &= CCTS_OFLOW | CRTS_IFLOW | CLOCAL;
	t.c_cflag |= CS8 | CREAD | HUPCL;
	t.c_lflag = 0;
	t.c_cc[VMIN] = 1;
	t.c_cc[VTIME] = 0;
	if (baudrate != 0 && cfsetspeed(&t, baudrate))
		err(1, "%s: cfsetspeed", ttyname);
	if (tcsetattr(line, TCSADRAIN, &t) < 0)
		err(1, "%s: tcsetattr", ttyname);

	/* Save line discipline */
	if (ioctl(line, TIOCGETD, &oldld) < 0)
		err(1, "%s: ioctl(TIOCGETD)", ttyname);

	ld = PPPDISC;
	if (ioctl(line, TIOCSETD, &ld) < 0)
		err(1, "%s: ioctl(TIOCSETD)", ttyname);

	if (ioctl(line, PPPIOCSUNIT, &interface) < 0)
		switch (errno) {
		case ENXIO:
			errx(1, "%s: no such interface", ttyname);
		case EBUSY:
			errx(1, "%s: interface is currently busy", ttyname);
		default:
			err(1, "%s: ioctl(PPPIOCSUNIT)", ttyname);
		}

	/* Wait until end of session */
	if (ioctl(line, PPPIOCWEOS))
		warn("%s: ioctl(PPPIOCWEOS)", ttyname);

	/* Restore line discipline */
	if (ioctl(line, TIOCSETD, &oldld))
		warn("%s: ioctl(TIOSETD)", ttyname);

	(void)close(line);
	exit(0);
}

void
usage()
{
	(void)fprintf(stderr,
	    "usage: pppattach [-i interface #] [-s baudrate] ttyname\n");
	exit(1);
}
