/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI login_passwd.c,v 1.3 1995/09/21 19:07:25 prb Exp
 */
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <sys/wait.h>

#include <err.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <stdarg.h>
#include <login_cap.h>

FILE *back;

extern char *__progname;

static void _auth_spool(char *fmt, ...);

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct passwd *pwd;
	char passbuf[_PASSWORD_LEN+1];
	char localhost[MAXHOSTNAMELEN];
    	char *class = 0;
    	char *username = 0;
    	char *instance;
    	char *fullname;
	char *ftp = 0;
	char *salt;
	char *p;
    	int c;
	struct rlimit rl;

	rl.rlim_cur = 0;
	rl.rlim_max = 0;
	(void)setrlimit(RLIMIT_CORE, &rl);

	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)setpriority(PRIO_PROCESS, 0, 0);

	openlog("login", LOG_ODELAY, LOG_AUTH);

	if (gethostname(localhost, sizeof(localhost)) < 0)
		syslog(LOG_ERR, "couldn't get local hostname: %m");

    	while ((c = getopt(argc, argv, "s:")) != EOF)
		switch(c) {
		case 's':	/* service */
			if (strcmp(optarg, "login") == 0)
				ftp = 0;
			else if (strcmp(optarg, "ftp") == 0)
				ftp = "ftp";
			else {
				syslog(LOG_ERR, "%s: invalid service for %s",
				    optarg, __progname);
				exit(1);
			}
			break;
		default:
			syslog(LOG_ERR, "usage error for %s", __progname);
			exit(1);
		}

	switch(argc - optind) {
	case 2:
		class = argv[optind + 1];
	case 1:
		username = argv[optind];
		break;
	default:
		syslog(LOG_ERR, "usage error for %s", __progname);
		exit(1);
	}

	fullname = strdup(username);
	if (fullname == NULL) {
		syslog(LOG_ERR, "%s: could not strdup(%s)",
		    __progname, username);
		exit(1);
	}

	/*
	 * .root instances in passwd is just the root account.
	 * all other instances will fail.
	 */
	instance = strchr(username, '.');
	if (instance && strcmp(instance+1, "root") == 0)
		username = instance + 1;

	pwd = getpwnam(username);

	if (ftp) {
		printf("Password required for %s.\n", username);
		fflush(stdout);
		back = NULL;
	} else if (!(back = fdopen(3, "a")))  {
		syslog(LOG_ERR, "reopening back channel for %s", __progname);
		exit(1);
	}

	if (pwd && *pwd->pw_passwd == '\0') {
		_auth_spool(BI_AUTH "\n");
		exit(0);
	}

	if (pwd)
		salt = pwd->pw_passwd;
	else
		salt = "xx";

	(void)setpriority(PRIO_PROCESS, 0, -4);

	if (ftp) {
		if (fgets(passbuf, sizeof(passbuf), stdin) == NULL)
			exit(1);
		if (p = strchr(passbuf, '\r'))
			*p = '\0';
		if (p = strchr(passbuf, '\n'))
			*p = '\0';
		p = passbuf;
	} else
		p = getpass("Password:");

	salt = crypt(p, salt);
	memset(p, 0, strlen(p));
	if (!pwd || strcmp(salt, pwd->pw_passwd) != 0)
		exit(1);
	_auth_spool(BI_AUTH "\n");
	exit(0);
}

static void
_auth_spool(char *fmt, ...)
{
	va_list ap;

	if (back) {
		va_start(ap, fmt);

		vfprintf(back, fmt, ap);

		va_end(ap);
	}
}
