#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <pwd.h>
#include <signal.h>

#include <login_cap.h>

int ext_auth = 0;
static int infd[2];
static int outfd[2];
static pid_t pid;
static int timeout = 60;
static jmp_buf tenv;
static void (*alarmfunc)();
static int acnt;

static void
alarmcall(int signo)
{
    longjmp(tenv, ++acnt);
}

char *
start_auth(char *style, char *name, struct passwd *pwd)
{
    static char path[MAXPATHLEN];
    char *b;
    login_cap_t *class;

    ext_auth = 1; /* authentication is always external */

    if (!(class = login_getclass(pwd)))
	return(0);

    if (pwd && pwd->pw_passwd[0] == '\0')
	return(0);

    if ((style = login_getstyle(class, style, "auth-ftp")) == NULL)
	return(0);

#if 0
    /*
     * We could get some information out of the login.conf file, but
     * it is not clear we should have this information there.
     */
    if (login_getcapbool(class, "noftp", 0))
	return(0);

    timeout = login_getcaptime(class, "timeout", 60, 60);
#endif

    if (pipe(infd) < 0)
	return(0);

    if (pipe(outfd) < 0) {
	close(infd[0]);
	close(infd[1]);
	return(0);
    }

    snprintf(path, MAXPATHLEN, _PATH_AUTHPROG "%s", style);

    switch (pid = fork()) {
    case -1:
	close(infd[0]);
	close(infd[1]);
	close(outfd[0]);
	close(outfd[1]);
	return(0);
    case 0:
	close(infd[1]);
	close(outfd[0]);
	if (infd[0] != 0) {
	    close(0);
	    dup2(infd[0], 0);
	    close(infd[0]);
	}
	close(1);
	dup2(outfd[1], 1);
	close(outfd[1]);
	close(2);
	close(3);
	execl(path, style, "-s", "ftp", name, class->lc_class, 0);
	exit(1);
    default:
	close(infd[0]);
	close(outfd[1]);
	ext_auth = 2;
	b = path;
	acnt = 0;
	alarmfunc = signal(SIGALRM, alarmcall);
	alarm(timeout);
	if (setjmp(tenv) == 0) {
	    while (b < path + sizeof(path) - 1) {
		if (read(outfd[0], b, 1) != 1) {
		    close(infd[1]);
		    close(outfd[0]);
		    alarm(0);
		    signal(SIGALRM, alarmfunc);
		    return(0);
		}
		if (*b++ == '\n') {
		    b[-1] = 0;
		    ext_auth = 3;
		    alarm(0);
		    signal(SIGALRM, alarmfunc);
		    return(path);
		}
	    }
	    alarm(0);
	}
	signal(SIGALRM, alarmfunc);
	return(0);
    }
}

int
check_auth(char *passwd)
{
    int status;

    if (ext_auth > 1) {
	if (ext_auth > 2) {
	    write(infd[1], passwd, strlen(passwd));
	    write(infd[1], "\n", 1);
	} else
	    kill(pid, 9);		/* make it go away... */
	close(infd[1]);
	close(outfd[0]);

	acnt = 0;
	alarmfunc = signal(SIGALRM, alarmcall);

	switch (setjmp(tenv)) {
	case 1:
	    ext_auth = 2;
	    kill(pid, 9);		/* make it go away... */
	    break;
	case 2:
	    alarm(0);
	    signal(SIGALRM, alarmfunc);
	    return(-1);
	}

	alarm(timeout);

	if (waitpid(pid, &status, 0) < 0) {
	    alarm(0);
	    signal(SIGALRM, alarmfunc);
	    return(-1);
	}
	alarm(0);
	signal(SIGALRM, alarmfunc);
	if (!WIFEXITED(status) || WEXITSTATUS(status))
	    return(-1);
	return(ext_auth > 2 ? 0 : -1);
    }
    return(-1);
}
