/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI login_cap.h,v 2.3 1995/10/04 03:41:37 prb Exp
 */

#define	LOGIN_DEFCLASS		"default"
#define	LOGIN_DEFSTYLE		"passwd"
#define	LOGIN_DEFSERVICE	"login"
#define	LOGIN_DEFUMASK		022
#define	_PATH_LOGIN_CONF	"/etc/login.conf"
#define	_PATH_AUTHPROG		"/usr/libexec/login_"

#define	LOGIN_SETGROUP		0x0001	/* Set group */
#define	LOGIN_SETLOGIN		0x0002	/* Set login */
#define	LOGIN_SETPATH		0x0004	/* Set path */
#define	LOGIN_SETPRIORITY	0x0008	/* Set priority */
#define	LOGIN_SETRESOURCES	0x0010	/* Set resource limits */
#define	LOGIN_SETUMASK		0x0020	/* Set umask */
#define	LOGIN_SETUSER		0x0040	/* Set user */
#define	LOGIN_SETALL 		0x007f	/* Set all. */

#define	BI_AUTH		"authorize"		/* Accepted authentication */
#define	BI_REJECT	"reject"		/* Rejected authentication */
#define	BI_REMOVE	"remove"		/* remove file on error */
#define	BI_ROOTOKAY	"authorize root"	/* root authenticated */
#define	BI_SECURE	"authorize secure"	/* okay on non-secure line */
#define	BI_SETENV	"setenv"		/* set environment variable */

/*
 * bits which can be returned by authenticate()/auth_scan()
 */
#define	AUTH_OKAY	0x01			/* user authentciated */
#define	AUTH_ROOTOKAY	0x02			/* authenticated as root */
#define	AUTH_SECURE	0x04			/* secure login */

typedef struct {
	char	*lc_class;
	char	*lc_cap;
	char	*lc_style;
} login_cap_t;

#include <sys/cdefs.h>
__BEGIN_DECLS
struct passwd;

login_cap_t *login_getclass __P((struct passwd *));
char *login_getstyle __P((login_cap_t *, char *, char *));
char *login_getcapstr __P((login_cap_t *, char *, char *, char *));
quad_t login_getcaptime __P((login_cap_t *, char *, quad_t, quad_t));
quad_t login_getcapnum __P((login_cap_t *, char *, quad_t, quad_t));
quad_t login_getcapsize __P((login_cap_t *, char *, quad_t, quad_t));
int login_getcapbool __P((login_cap_t *, char *, u_int));

int setclasscontext __P((char *, u_int));
int setusercontext __P((login_cap_t *, struct passwd *, uid_t, u_int));


/*
 * Routines for authentication
 */
int authenticate __P((char *, char *, char *, char *));
int auth_script __P((char *, ...));
void auth_env __P((void));
int auth_scan __P((int));
void auth_rmfiles __P((void));
void auth_checknologin __P((login_cap_t *));
int auth_cat __P((char *));
__END_DECLS
