/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI dlsym.c,v 1.1 1995/10/09 19:23:17 donn Exp
 */

#include <a.out.h>
#include <dlfcn.h>
#include <stdlib.h>
#include <string.h>

#include "dl.h"

void *
dlsym(v, input_name)
	void *v;
	const char *input_name;
{
	struct dl_info *d = v;
	struct nlist *nl, *end_sym;
	char *name;

	if (d == 0) {
		dl_errx("invalid handle");
		return (0);
	}

	if ((name = malloc(strlen(input_name) + 2)) == 0) {
		dl_err("can't copy name");
		return (0);
	}

	strcpy(name, "_");
	strcat(name, input_name);

	end_sym = &d->syms[d->exec.a_syms / sizeof *nl];
	for (nl = d->syms; nl < end_sym; ++nl)
		if (nl->n_type & N_EXT && strcmp(nl->n_un.n_name, name) == 0)
			break;
	free(name);
	if (nl >= end_sym) {
		dl_errx("symbol not found");
		return (0);
	}
	return ((void *)nl->n_value);
}
