/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI _setjmp.c,v 1.1 1995/12/18 21:49:35 donn Exp
 */

#include <setjmp.h>
#include <signal.h>
#include <unistd.h>

#define	MASK_WORD	7

extern int __save_context(int, jmp_buf);
extern void __restore_context(int, jmp_buf);

/*
 * This function must have a frame exactly 4 words long,
 * so it must be compiled with at least -O1 optimization.
 * It must be at least 4 words anyway because it isn't a leaf function.
 * __save_context() copies the stack frame into the jmp_buf.
 */
int
_setjmp(jmp_buf env)
{

	return (__save_context(0, env));
}

void
_longjmp(jmp_buf env, int r)
{

	if (r == 0)
		r = 1;

	__restore_context(r, env);
	/* never returns */
}
