/*
 * Copyright (c) 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI usleep.c,v 2.3 1995/07/22 00:19:12 bostic Exp
 */

#include <time.h>
#include <unistd.h>

/*
 * usleep --
 *	Pause N microseconds or until a signal arrives, returning nothing.
 */
void
usleep(usecs)
	unsigned int usecs;
{
	struct timeval t;

	if (usecs != 0) {
		t.tv_sec = 0;
		t.tv_usec = usecs;
		(void)select(0, NULL, NULL, NULL, &t);
	}
}
