/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI crt1.c,v 1.2 1996/01/04 02:52:47 donn Exp
 */

/*
 * C start-up code for the Power PC.
 */

#include <sys/exec.h>
#include <errno.h>
#include <stdlib.h>

void _sigtramp();
void __do_init(void);
void __do_fini(void);

extern int main(int, char **, char **);

struct ps_strings *__ps_strings;
char *__progname;
char **environ;

void
_start(int argc, char **argv, char **envp, auxv_t *auxv, void (*term)(void),
    struct ps_strings *psp)
{
	char *cp, *slash;

	/*
	 * Store the address of the signal trampoline in a known location.
	 */
	((unsigned *)psp)[-1] = (unsigned)_sigtramp;

	/*
	 * Initialize argument strings for setproctitle().
	 */
	__ps_strings = psp;

	/*
	 * Initialize the program name for err().
	 */
	for (cp = psp->ps_argv[0], slash = cp - 1; *cp; ++cp)
		if (*cp == '/')
			slash = cp;
	__progname = slash + 1;

	/*
	 * If the kernel or a shared library wants us to call
	 * a termination function, arrange to do so.
	 */
	if (term)
		atexit(term);

	/*
	 * Arrange to execute the global destructors,
	 * and execute the global constructors.
	 */
	atexit(__do_fini);
	__do_init();

	/*
	 * Finally, run the program.
	 */
	errno = 0;
	environ = envp;
	exit(main(argc, argv, envp));
}
