/*	BSDI	mt.c,v 2.4 1995/11/20 17:12:52 cp Exp	*/
/*
 * Copyright (c) 1980, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1980, 1993\n\
	The Regents of the University of California.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)mt.c	8.1 (Berkeley) 6/6/93";
#endif /* not lint */

/*
 * mt --
 *   magnetic tape manipulation program
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MT_BLKSIZE	-1

struct commands {
	char *c_name;			/* Name. */
	int c_code;			/* Ioctl code. */
	int c_ronly;			/* 1 if open tape drive O_RDONLY */
	int c_arg;			/* 1 if trailing argument. */
} const com[] = {
	{ "bsf",	MTBSF,	    1, 1 },
	{ "bsr",	MTBSR,	    1, 1 },
	{ "buffered",	MTCACHE,    1, 0 },
	{ "eof",	MTWEOF,	    0, 1 },
	{ "fsf",	MTFSF,	    1, 1 },
	{ "fsr",	MTFSR,	    1, 1 },
	{ "offline",	MTOFFL,	    1, 0 },
	{ "rewind",	MTREW,	    1, 0 },
	{ "rewoffl",	MTOFFL,	    1, 0 },
	{ "status",	MTNOP,	    1, 0 },
	{ "unbuffered",	MTNOCACHE,  1, 0 },
	{ "weof",	MTWEOF,	    0, 1 },
	{ "blksize",	MT_BLKSIZE, 1, 1 },	/* not regular MTIOCTOP */
	{ "blocksize",	MT_BLKSIZE, 1, 1 },	/* not regular MTIOCTOP */
	{ NULL }
};

void printreg __P((char *, u_int, char *));
void status __P((struct mtget *));
void usage __P((void));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct commands const *comp;
	struct mtget mt_status;
	struct mtop mt_com;
	size_t len;
	long value;
	int ch, mtfd;
	char *p, *tape;

	if ((tape = getenv("TAPE")) == NULL)
		tape = DEFTAPE;

	while ((ch = getopt(argc, argv, "f:t:")) != EOF)
		switch(ch) {
		case 'f':
		case 't':
			tape = optarg;
			break;
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	if (argc < 1 || argc > 2)
		usage();

	len = strlen(p = *argv++);
	for (comp = com;; comp++) {
		if (comp->c_name == NULL)
			errx(1, "%s: unknown command", p);
		if (strncmp(p, comp->c_name, len) == 0)
			break;
	}
	if ((mtfd = open(tape, comp->c_ronly ? O_RDONLY : O_RDWR)) < 0)
		err(1, "%s", tape);

	/* Get any associated argument. */
	if (comp->c_arg && *argv != NULL) {
		errno = 0;
		value = strtol(*argv, &p, 10);
		if (errno)
			err(1, "%s", *argv);
		if (value <= 0 || *argv == '\0' || *p != '\0')
			errx(1, "%s: illegal numeric argument", *argv);
	} else
		value = 0;

	switch (comp->c_code) {
	case MT_BLKSIZE:
		if (value) {
			if (ioctl(mtfd, MTIOCSFBS, &len) < 0)
				err(1, "%s: %s", tape, comp->c_name);
		} else {
			if (ioctl(mtfd, MTIOCGFBS, &len) < 0)
				err(1, "%s: %s", tape, comp->c_name);
			(void)printf("%s fixed block length = %d\n", tape, len);
		}
		break;
	case MTNOP:
		if (ioctl(mtfd, MTIOCGET, &mt_status) < 0)
			err(1, "%s: %s", tape, comp->c_name);
		status(&mt_status);
		break;
	default:
		mt_com.mt_op = comp->c_code;
		mt_com.mt_count = value ? value : 1;
		if (ioctl(mtfd, MTIOCTOP, &mt_com) < 0)
			err(1, "%s: %s", tape, comp->c_name);
	}
	exit (0);
}

#ifdef vax
#include <vax/mba/mtreg.h>
#include <vax/mba/htreg.h>

#include <vax/uba/utreg.h>
#include <vax/uba/tmreg.h>
#undef b_repcnt					/* XXX: Argh! */
#include <vax/uba/tsreg.h>
#endif

#ifdef sun
#include <sundev/tmreg.h>
#include <sundev/arreg.h>
#endif

#ifdef tahoe
#include <tahoe/vba/cyreg.h>
#endif

#ifdef __bsdi__
#ifdef notyet
#include <i386/isa/wtreg.h>
#include <scsi/scsi.h>
#define SCSI_BITS	""
#define SCSIERR_BITS	"\010\010aaa\015bbb\016ccc\017ddd"
#define WTS_BITS	"\010\01FIL\010EOM"
#define WTERR_BITS	"\010\02BNL\04UDA\020WRP\040USL"
#endif /* notyet */
#ifndef MT_ISSCSI
#define	MT_ISSCSI	0x00		/* XXX Generic SCSI */
#endif
#ifndef MT_ISQIC02
#define MT_ISQIC02	0x11		/* XXX WangTek QIC-150 */
#endif
#endif /* __bsdi__ */

struct tape_desc {
	short	t_type;		/* type of magtape device */
	char	*t_name;	/* printing name */
	char	*t_dsbits;	/* "drive status" register */
	char	*t_erbits;	/* "error" register */
} tapes[] = {
#ifdef vax
	{ MT_ISTS,	"ts11",		0,		TSXS0_BITS },
	{ MT_ISHT,	"tm03",		HTDS_BITS,	HTER_BITS },
	{ MT_ISTM,	"tm11",		0,		TMER_BITS },
	{ MT_ISMT,	"tu78",		MTDS_BITS,	0 },
	{ MT_ISUT,	"tu45",		UTDS_BITS,	UTER_BITS },
#endif
#ifdef sun
	{ MT_ISCPC,	"TapeMaster",	TMS_BITS,	0 },
	{ MT_ISAR,	"Archive",	ARCH_CTRL_BITS,	ARCH_BITS },
#endif
#ifdef tahoe
	{ MT_ISCY,	"cipher",	CYS_BITS,	CYCW_BITS },
#endif
#ifdef __bsdi__
	{ MT_ISSCSI,	"SCSI",		0,		0 },
	{ MT_ISQIC02,	"QIC02",	0,		0 },
#endif
	{ 0 }
};

/*
 * Interpret the status buffer returned
 */
void
status(bp)
	register struct mtget *bp;
{
	register struct tape_desc *mt;

	for (mt = tapes;; mt++) {
		if (mt->t_type == 0) {
			(void)printf("%d: unknown tape drive type\n",
			    bp->mt_type);
			return;
		}
		if (mt->t_type == bp->mt_type)
			break;
	}
	(void)printf("%s tape drive, residual=%d\n", mt->t_name, bp->mt_resid);
	printreg("ds", bp->mt_dsreg, mt->t_dsbits);
	printreg("\ner", bp->mt_erreg, mt->t_erbits);
	(void)putchar('\n');
}

/*
 * Print a register a la the %b format of the kernel's printf.
 */
void
printreg(s, v, bits)
	char *s;
	register u_int v;
	register char *bits;
{
	register int i, any = 0;
	register char c;

	if (bits && *bits == 8)
		(void)printf("%s=%o", s, v);
	else
		(void)printf("%s=%x", s, v);
	if (bits)
		++bits;
	if (v && bits) {
		putchar('<');
		while ((i = *bits++) != 0) {
			if (v & (1 << (i - 1))) {
				if (any)
					putchar(',');
				any = 1;
				for (; (c = *bits) > 32; bits++)
					putchar(c);
			} else
				for (; *bits > 32; bits++)
					;
		}
		putchar('>');
	}
}

void
usage()
{
	(void)fprintf(stderr,
	    "usage: mt [-f device] command [count | length]\n");
	exit(1);
}
