/*
** Hacked back in Radius Cinapak support,
** Nap, 15 Jul 1995
**
** (Compile with -DXA_CINEPAK)
*/

typedef struct
{
  xaUBYTE r,g,b,pad;
  xaULONG clr;
} CVID_Color;

#define QT_CVID_MAX_STRIPS 16
CVID_Color *qt_cvid_maps0[QT_CVID_MAX_STRIPS];
CVID_Color *qt_cvid_maps1[QT_CVID_MAX_STRIPS];

int qt_cvid_map_num = 0;




xaULONG
QT_Decode_CVID(image,delta,dsize,tchdr,map,map_flag,imagex,imagey,imaged,
					xs,ys,xe,ye,special,extra)
xaUBYTE *image;           /* Image Buffer. */
xaUBYTE *delta;           /* delta data. */
xaULONG dsize;            /* delta size */
XA_CHDR *tchdr;		/* color map info */
xaULONG *map;             /* used if it's going to be remapped. */
xaULONG map_flag;         /* whether or not to use remap_map info. */
xaULONG imagex,imagey;    /* Size of image buffer. */
xaULONG imaged;           /* Depth of Image. (IFF specific) */
xaULONG *xs,*ys;          /* pos of changed area. */
xaULONG *xe,*ye;          /* size of changed area. */
xaULONG special;          /* Special Info. */
void *extra;		/* extra info needed to decode delta */
{
  XA_CHDR *chdr;
  xaUBYTE *dptr = delta;
  xaULONG strip,strip_num,copy_flag,y,y_top = 0;

  *xs = *ys = 0; *xe = imagex; *ye = imagey;
  if (tchdr) {chdr=(tchdr->new_chdr)?(tchdr->new_chdr):(tchdr);} else chdr=0;

  y = y_top = 0;
  /* Main Codec header */
  { xaULONG xsz,ysz;	xaLONG len = *dptr++;
    copy_flag = (len & 0x01)?(xaFALSE):(xaTRUE);
    len =(*dptr++)<<16; len |= (*dptr++)<< 8; len |= (*dptr++); /* Read Len */
    if (len != dsize) /* CHECK FOR CORRUPTION - FAIRLY COMMON */
    { if (len & 0x01) len++; /* AVIs tend to have a size mismatch */
      if (len != dsize)
      {
       if (xa_verbose==xaTRUE) 
	 fprintf(stderr,"QT CVID corruption-skipping this frame %lx %lx\n",
								dsize,len);
       return(ACT_DLTA_NOP);
      }
    }
    xsz    = (*dptr++) << 8;  xsz    |= *dptr++;  /* xsize */
    ysz    = (*dptr++) << 8;  ysz    |= *dptr++;  /* ysize */
    strip_num = (*dptr++) << 8;  strip_num |= *dptr++;
    DEBUG_LEVEL1 fprintf(stderr,"CVID <%lx %lx> strips %lx\n",xsz,ysz,strip_num);
  }

  if (strip_num > qt_cvid_map_num)
  { int i;
    if (strip_num >= QT_CVID_MAX_STRIPS) 
		TheEnd1("CVID: strip ovrflow - contact Author");
    for(i=qt_cvid_map_num; i<strip_num; i++)
    {
      CVID_Color *cvmap;
      cvmap = (CVID_Color *)malloc( 1040 * sizeof(CVID_Color) );
      if (cvmap==0) TheEnd1("CVID: cvmap0 alloc err");
      qt_cvid_maps0[i] = cvmap;
      cvmap = (CVID_Color *)malloc( 1040 * sizeof(CVID_Color) );
      if (cvmap==0) TheEnd1("CVID: cvmap1 alloc err");
      qt_cvid_maps1[i] = cvmap;
    }
  }
  qt_cvid_map_num = strip_num;


  /* Decode strips */
  for(strip=0; strip<strip_num; strip++)
  { CVID_Color *qt_cvid_cmap0,*qt_cvid_cmap1;
    xaLONG top_size, x = 0;

    qt_cvid_cmap0 = qt_cvid_maps0[strip];
    qt_cvid_cmap1 = qt_cvid_maps1[strip];
    if ( strip && (copy_flag==xaTRUE))	/* NEW WAY gardiner*/
    { xaULONG i; CVID_Color *src,*dst;
      src = qt_cvid_maps0[strip-1]; dst = qt_cvid_maps0[strip];
      for(i=0;i<1024;i++) dst[i]=src[i];
      src = qt_cvid_maps1[strip-1]; dst = qt_cvid_maps1[strip];
      for(i=0;i<1024;i++) dst[i]=src[i];
    }

    /* Read Strip header */
    { xaULONG top_cid,x0,y0,x1,y1;
      top_cid  = (*dptr++) << 8;   top_cid  |= *dptr++;
      top_size = (*dptr++) << 8;   top_size |= *dptr++;
      y0       = (*dptr++) << 8;   y0       |= *dptr++;
      x0       = (*dptr++) << 8;   x0       |= *dptr++;
      y1       = (*dptr++) << 8;   y1       |= *dptr++;
      x1       = (*dptr++) << 8;   x1       |= *dptr++;

      y_top += y1;
      top_size -= 12;
      if (x1 != imagex) 
	fprintf(stderr,"CVID Warning x1(%lx) != imagex(%lx)\n",x1,imagex);
    }

    while(top_size > 0)
    { xaULONG cid; xaLONG csize;
      cid   = (*dptr++) << 8;  cid   |= *dptr++;
      csize = (*dptr++) << 8;  csize |= *dptr++;
      /* DEBUG_LEVEL1 fprintf(stderr,"        %04lx %04lx\n",cid,csize); */
      top_size -= csize;
      csize -= 4;
      switch(cid)
      { /******************************************/
	case 0x2000: 
	case 0x2200: 
	  { xaULONG cnum,i;		CVID_Color *cvid_map;
	    xaUBYTE *rnglimit = jpg_samp_limit + 256;
	    if (cid == 0x2200)	cvid_map = qt_cvid_cmap1;
	    else		cvid_map = qt_cvid_cmap0;
	    cnum = csize / 6;  
	    for(i=0; i<cnum; i++) 
	    { xaLONG cr,cg,cb; xaULONG j,U,V; xaUBYTE *Yptr = dptr;
	      dptr += 4; /* skip over luma */
	      U = (xaULONG)(*dptr++)^0x80;	V = (xaULONG)(*dptr++)^0x80;
	      cr = QT_VR_tab[V];		cb = QT_UB_tab[U];
	      cg = (QT_UG_tab[U] + QT_VG_tab[V])>>16;

	      if (special)
	      { for(j = i; j < 1024; j += 256)
	        { xaLONG r,g,b,Y = (xaLONG)*Yptr++;	
		  r = rnglimit[Y+cr]; g = rnglimit[Y+cg]; b = rnglimit[Y+cb];
	          cvid_map[j].r = r; cvid_map[j].g = g; cvid_map[j].b = b; 
		}
	      }
	      else
	      { for(j = i; j < 1024; j += 256)
	        { xaLONG r,g,b,Y = (xaLONG)*Yptr++;	
		  r = rnglimit[Y+cr]; g = rnglimit[Y+cg]; b = rnglimit[Y+cb];
	          cvid_map[j].clr = QT_Get_Color24(r,g,b,map_flag,map,chdr);
		}
	      }
	    }
	  }
	  break;
	/******************************************/
	case 0x2100: 
	case 0x2300: 
	  { CVID_Color *cvid_map;	xaULONG ci = 0;	
	    xaUBYTE *rnglimit = jpg_samp_limit + 256;
	    if (cid == 0x2300) cvid_map = qt_cvid_cmap1; 
	    else cvid_map = qt_cvid_cmap0;
	    while(csize > 0)
	    { xaULONG flag,mask = 0x80000000;
	      flag  = (*dptr++) << 24;  flag |= (*dptr++) << 16;
	      flag |= (*dptr++) <<  8;  flag |= *dptr++; csize -= 4;

	      while(mask)
	      { if (mask & flag)
		{ xaLONG cr,cg,cb; xaULONG j,U,V; xaUBYTE *Yptr = dptr;
		  dptr += 4;	csize -= 6;
		  U = (xaULONG)(*dptr++)^0x80;	V = (xaULONG)(*dptr++)^0x80;
		  cr = QT_VR_tab[V];		cb = QT_UB_tab[U];
		  cg = (QT_UG_tab[U] + QT_VG_tab[V])>>16;

		  if (special)
		  { for(j = ci; j < 1024; j += 256)
		    { xaLONG Y,r,g,b;
		      Y = (xaLONG)*Yptr++;	r = rnglimit[Y+cr];
		      g = rnglimit[Y+cg];	b = rnglimit[Y+cb];
		      cvid_map[j].r = r; cvid_map[j].g = g; cvid_map[j].b = b; 
		    }
		  }
		  else
		  { for(j = ci; j < 1024; j += 256)
		    { xaLONG Y,r,g,b;
		      Y = (xaLONG)*Yptr++;	r = rnglimit[Y+cr];
		      g = rnglimit[Y+cg];	b = rnglimit[Y+cb];
		      cvid_map[j].clr = QT_Get_Color24(r,g,b,map_flag,map,chdr);
		    }
		  }
		}
	        ci++; mask >>= 1;
	      } /* loop thru flag */
	    } /* while csize > 0 */
	    if (csize != 0) fprintf(stderr,"CVID_21 err sz %04lx\n",csize);
	  } /* end of case */
	  break;
	/******************************************/
	case 0x3000: 
	{ xaULONG flag;

	  while( (csize > 0) && (y < y_top) )
	  { xaULONG mask;
	    xaLONG j;
	    flag  = (*dptr++) << 24;  flag |= (*dptr++) << 16;
	    flag |= (*dptr++) <<  8;  flag |= *dptr++; csize -= 4;

	    mask = 0x80000000; j = 32;
	    for(j=0; j<32; j++)
	    { if (y >= y_top) break;
	      if (mask & flag) /* update blocks 4 bytes map 0*/
	      { xaULONG d0,d1,d2,d3;
	        d0 = *dptr++; d1 = *dptr++; 
		d2 = *dptr++; d3 = *dptr++; csize -= 4;
		QT_CVID_C4(image,x,y,imagex,special,map_flag,
						d0,d1,d2,d3,qt_cvid_cmap0);
	      }
	      else /* 1 byte map 1 */
	      { xaULONG d;
		d = *dptr++; csize--;
		QT_CVID_C1(image,x,y,imagex,special,map_flag,d,qt_cvid_cmap1);
	      }
              x += 4; if (x >= imagex) {x = 0; y += 4;}
	      mask >>= 1;
            } /* end of loop through flags */
	    if (csize < 4) { dptr += csize;  csize = 0; } /* POD still ness?? */
	  } /* end of csize loop */
	  if (csize) dptr += csize;
	} /* end of case 3000 */
	break;
	/******************************************/
	case 0x3200: /* Every Byte is <C1> */ 
	{ while( (csize > 0) && (y < y_top) )
	  { xaULONG d;
	    d = *dptr++; csize--;
	    QT_CVID_C1(image,x,y,imagex,special,map_flag,d,qt_cvid_cmap1);
            x += 4; if (x >= imagex) {x = 0; y += 4;}
	  }
	  if (csize) dptr += csize;
	}
	break;
/***********
  0   SKIP      if(nextbit) { if(nextbit) C4 else C1 }
  10  C1
  11  C4
***********/
	/******************************************/
	case 0x3100: 
	{
	  while( (csize > 0) && (y < y_top) )
	  { xaULONG mcode,mask = 0x80000000;
	    mcode  = (*dptr++) << 24;  mcode |= (*dptr++) << 16;
	    mcode |= (*dptr++) <<  8;  mcode |= *dptr++; csize -= 4;
	    mask = 0x80000000;
	    while( (mask) && (y < y_top) )
	    { if (mcode & mask)
	      { if (mask == 1) /* need more bits */
		{ if (csize < 0) break;
		  mcode  = (*dptr++) << 24;  mcode |= (*dptr++) << 16;
		  mcode |= (*dptr++) <<  8;  mcode |= *dptr++; csize -= 4;
		  mask = 0x80000000;
		} else mask >>= 1;

		if (mcode & mask)  /* C4 */
		{ xaULONG d0,d1,d2,d3;
		  d0 = *dptr++; d1 = *dptr++;
		  d2 = *dptr++; d3 = *dptr++; csize -= 4;
		  QT_CVID_C4(image,x,y,imagex,special,map_flag,
						d0,d1,d2,d3,qt_cvid_cmap0);
		}
		else /* C1 */
		{ xaULONG d = *dptr++; csize--;
		  QT_CVID_C1(image,x,y,imagex,special,map_flag,
							d,qt_cvid_cmap1);
		}
	      } /* else SKIP */
	      mask >>= 1;
	      x += 4; if (x >= imagex) {x = 0; y += 4;}
	    }
	  }
	  if (csize) dptr += csize; /* better way of doing this */
	}
	break;
	/******************************************/
	case 0x2400: 
	case 0x2600: 
	  { xaULONG cnum,i; CVID_Color *cvid_map;
	    cvid_map = (cid == 0x2600)?(qt_cvid_cmap1):(qt_cvid_cmap0);
	    cnum = csize >> 2;  
	    if (map_flag)
	    { for(i=0; i<cnum; i++) 
	      { cvid_map[i].clr     = map[ (xaULONG)(*dptr++) ];
		cvid_map[i+256].clr = map[ (xaULONG)(*dptr++) ];
		cvid_map[i+512].clr = map[ (xaULONG)(*dptr++) ];
		cvid_map[i+768].clr = map[ (xaULONG)(*dptr++) ];
	      }
	    }
	    else
	    { for(i=0; i<cnum; i++) 
	      { cvid_map[i].clr     = (xaULONG)(*dptr++);
		cvid_map[i+256].clr = (xaULONG)(*dptr++);
		cvid_map[i+512].clr = (xaULONG)(*dptr++);
		cvid_map[i+768].clr = (xaULONG)(*dptr++);
	      }
	    }
	  }
	  break;
	/******************************************/
	case 0x2500: 
	case 0x2700: 
	  { xaULONG ci = 0; CVID_Color *cvid_map;
	    cvid_map = (cid == 0x2700)?(qt_cvid_cmap1):(qt_cvid_cmap0);

	    while(csize > 0)
	    { xaULONG flag,mask = 0x80000000;
	      flag  = (*dptr++) << 24;  flag |= (*dptr++) << 16;
	      flag |= (*dptr++) <<  8;  flag |= *dptr++; csize -= 4;

	      while(mask)
	      { if (mask & flag)
		{ if (map_flag)
		  { cvid_map[ci].clr     = map[ (xaULONG)(*dptr++) ];
		    cvid_map[ci+256].clr = map[ (xaULONG)(*dptr++) ];
		    cvid_map[ci+512].clr = map[ (xaULONG)(*dptr++) ];
		    cvid_map[ci+768].clr = map[ (xaULONG)(*dptr++) ];
		  }
		  else
		  { cvid_map[ci].clr     = (xaULONG)(*dptr++);
		    cvid_map[ci+256].clr = (xaULONG)(*dptr++);
		    cvid_map[ci+512].clr = (xaULONG)(*dptr++);
		    cvid_map[ci+768].clr = (xaULONG)(*dptr++);
		  }
		  csize -= 4;
		}
	        ci++; mask >>= 1;
	      } 
	    }
	    if (csize != 0) fprintf(stderr,"CVID_25 err sz %04lx\n",csize);
	  }
	  break;
	default:
	  fprintf(stderr,"CVID unknown cid %08lx. Contact Author.\n",cid);
	  TheEnd();
	  break;
      } /* end of switch */
    } /* end of top_size */
  } /* end of strips */
  if (map_flag) return(ACT_DLTA_MAPD);
  else return(ACT_DLTA_NORM);
}

#define QT_CVID_C1_BLK(ip,CAST,d,cv_map,rinc) { register CAST d0,d1; \
 *ip++ = d0 = (CAST)(cv_map[d].clr); *ip++ = d0; d += 256;	\
 *ip++ = d1 = (CAST)(cv_map[d].clr); *ip   = d1; d += 256;	\
  ip += rinc; \
 *ip++ = d0; *ip++ = d0; *ip++ = d1; *ip = d1; ip += rinc;	\
 *ip++ = d0 = (CAST)(cv_map[ d ].clr); *ip++ = d0; d += 256;	\
 *ip++ = d1 = (CAST)(cv_map[ d ].clr); *ip   = d1;		\
  ip += rinc; *ip++ = d0; *ip++ = d0; *ip++ = d1; *ip = d1; }

#define QT_CVID_C4_BLK(ip,CAST,d0,d1,cv_map,rinc) { \
 *ip++ = (CAST)(cv_map[d0].clr); d0 += 256;  \
 *ip++ = (CAST)(cv_map[d0].clr); d0 += 256;  \
 *ip++ = (CAST)(cv_map[d1].clr); d1 += 256;  \
 *ip   = (CAST)(cv_map[d1].clr); d1 += 256; ip += rinc; \
 *ip++ = (CAST)(cv_map[d0].clr); d0 += 256;  \
 *ip++ = (CAST)(cv_map[d0].clr); 		  \
 *ip++ = (CAST)(cv_map[d1].clr); d1 += 256;  \
 *ip   = (CAST)(cv_map[d1].clr); }

void QT_CVID_C1(image,x,y,imagex,special,map_flag,d,cvid_map)
xaUBYTE *image;
xaULONG x,y,imagex,special,map_flag,d;
CVID_Color *cvid_map;
{ xaULONG row_inc;
  row_inc = imagex - 3;
  if (special)
  { xaUBYTE *i_ptr = (xaUBYTE *)(image + 3*(y * imagex + x) );
    register xaUBYTE r0,r1,b0,b1,g0,g1;
    row_inc *= 3; row_inc -= 2;
    *i_ptr++ = r0 = (xaUBYTE)(cvid_map[ d ].r);  
    *i_ptr++ = g0 = (xaUBYTE)(cvid_map[ d ].g);  
    *i_ptr++ = b0 = (xaUBYTE)(cvid_map[ d ].b);  
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;  d += 256;
    *i_ptr++ = r1 = (xaUBYTE)(cvid_map[ d ].r);  
    *i_ptr++ = g1 = (xaUBYTE)(cvid_map[ d ].g);  
    *i_ptr++ = b1 = (xaUBYTE)(cvid_map[ d ].b);  
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr = b1;  d += 256;
     i_ptr += row_inc;
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr++ = b1;
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr   = b1;
     i_ptr += row_inc;
    *i_ptr++ = r0 = (xaUBYTE)(cvid_map[ d ].r);  
    *i_ptr++ = g0 = (xaUBYTE)(cvid_map[ d ].g);  
    *i_ptr++ = b0 = (xaUBYTE)(cvid_map[ d ].b);  
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;  d += 256;
    *i_ptr++ = r1 = (xaUBYTE)(cvid_map[ d ].r);  
    *i_ptr++ = g1 = (xaUBYTE)(cvid_map[ d ].g);  
    *i_ptr++ = b1 = (xaUBYTE)(cvid_map[ d ].b);  
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr = b1;
     i_ptr += row_inc;
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;
    *i_ptr++ = r0; *i_ptr++ = g0; *i_ptr++ = b0;
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr++ = b1;
    *i_ptr++ = r1; *i_ptr++ = g1; *i_ptr   = b1;
    return;
  }
  if ( (x11_bytes_pixel==1) || (map_flag == xaFALSE) )
  { xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
    QT_CVID_C1_BLK(i_ptr,xaUBYTE,d,cvid_map,row_inc);
  }
  else if (x11_bytes_pixel==2)
  { xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y*imagex+x)<<1) );
    QT_CVID_C1_BLK(i_ptr,xaUSHORT,d,cvid_map,row_inc);
  }
  else /* if (x11_bytes_pixel==4) */
  { xaULONG *i_ptr = (xaULONG *)(image + ((y*imagex+x)<<2) );
    QT_CVID_C1_BLK(i_ptr,xaULONG,d,cvid_map,row_inc);
  }
}

void QT_CVID_C4(image,x,y,imagex,special,map_flag,d0,d1,d2,d3,cvid_map)
xaUBYTE *image;
xaULONG x,y,imagex,special,map_flag;
xaULONG d0,d1,d2,d3;
CVID_Color *cvid_map;
{ xaULONG row_inc;
  row_inc = imagex - 3;
  if (special)
  { xaUBYTE *i_ptr = (xaUBYTE *)(image + 3*(y * imagex + x) );
    row_inc *= 3; row_inc -= 2;
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].b); d0 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].b); d0 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].b); d1 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].g);  
    *i_ptr   = (xaUBYTE)(cvid_map[d1].b); d1 += 256;  i_ptr += row_inc;
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].b); d0 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d0].b);
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].b); d1 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d1].g);  
    *i_ptr   = (xaUBYTE)(cvid_map[d1].b); i_ptr += row_inc;
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].b); d2 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].b); d2 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].b); d3 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].g);  
    *i_ptr   = (xaUBYTE)(cvid_map[d3].b); d3 += 256;  i_ptr += row_inc;
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].b); d2 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d2].b);
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].g);  
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].b); d3 += 256;  
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].r);
    *i_ptr++ = (xaUBYTE)(cvid_map[d3].g);  
    *i_ptr   = (xaUBYTE)(cvid_map[d3].b);
    return;
  }
  if ( (x11_bytes_pixel==1) || (map_flag == xaFALSE) )
  { xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
    QT_CVID_C4_BLK(i_ptr,xaUBYTE,d0,d1,cvid_map,row_inc);
    i_ptr += row_inc;
    QT_CVID_C4_BLK(i_ptr,xaUBYTE,d2,d3,cvid_map,row_inc);
  }
  else if (x11_bytes_pixel==2)
  { xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y*imagex+x)<<1) );
    QT_CVID_C4_BLK(i_ptr,xaUSHORT,d0,d1,cvid_map,row_inc);
    i_ptr += row_inc;
    QT_CVID_C4_BLK(i_ptr,xaUSHORT,d2,d3,cvid_map,row_inc);
  }
  else /* if (x11_bytes_pixel==4) */
  { xaULONG *i_ptr = (xaULONG *)(image + ((y*imagex+x)<<2) );
    QT_CVID_C4_BLK(i_ptr,xaULONG,d0,d1,cvid_map,row_inc);
    i_ptr += row_inc;
    QT_CVID_C4_BLK(i_ptr,xaULONG,d2,d3,cvid_map,row_inc);
  }
}

