/*  BSDI s5echo.c,v 1.1.1.1 1995/12/20 21:19:38 bostic Exp */

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ch, cnt, nonewline, val;
	char *p;

	/* This utility may NOT do getopt(3) option parsing. */

	/*
	 * !!!
	 * While early versions of System V echo do not do -n processing
	 * e.g., SVID, 3rd Edition, later versions, e.g., S5R4, do.
	 */
	++argv;
	--argc;
	nonewline = 0;
	if (*argv != NULL && !strcmp(*argv, "-n")) {
		++argv;
		--argc;
		nonewline = 1;
	}
	while (*argv != NULL) {
		for (p = *argv; *p != '\0'; ++p) {
			if ((ch = *p) == '\\')
				switch (*++p) {
				case '0':
					/*
					 * XXX
					 * Assume ASCII.
					 */
					for (cnt = val = 0; cnt < 3; ++cnt) {
						if (*++p < '0' || *p > '7')
							break;
						val <<= 3;
						val += *p - '0';
					}
					if (cnt != 3)
						--p;
					ch = val;
					break;
				case 'b':
					ch = '\b';
					break;
				case 'c':
					exit (0);
					/* NOTREACHED */
				case 'f':
					ch = '\f';
					break;
				case 'n':
					ch = '\n';
					break;;
				case 'r':
					ch = '\r';
					break;
				case 't':
					ch = '\t';
					break;;
				case 'v':
					ch = '\v';
					break;
				default:
					--p;
					/* FALLTHROUGH */
				case '\\':
					ch = '\\';
					break;
				}
			if (putchar(ch) != ch)
				goto err;
		}
		if (*++argv != NULL && putchar(' ') != ' ')
			goto err;
	}
	if (!nonewline)
		(void)putchar('\n');
err:	if (ferror(stdout))
		err(1, "stdout");
	exit (0);
}
