/* sc_index.c
   gopher item subclass procedures for index search result directories */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "globals.h"
#include "gopher.h"
#include "util.h"
#include "status.h"
#include "appres.h"
#include "item.h"
#include "dir.h"
#include "gui.h"
#include "sc_index.h"
#include "sc_indexP.h"


/* getIndexDirectory
   load a new gopher directory resulting from an index search */

BOOLEAN
getIndexDirectory(gi, string)
gopherItemP	gi;
char		*string;
{
	int		s;
	gopherDirP	d;
	BOOLEAN		fetchOK;

	if (( s = GI_connectWithStatus(gi) ) < 0 ) return FALSE;

	writeString(s, vStringValue(&(gi->selector)));

	/* if string is NULL, then the search string is already encoded in
	   the selector */

	if (string != NULL) {
		writen(s, "\t", 1);
		writeString(s, string);
	}

	writeString(s, EOL_STRING);

	d = newDir();

	showStatus("Awaiting search results",
			noCurrentDir() ? STAT_ROOT : STAT_DIRECTORY,
			gi->host, gi->port);

	fetchOK = GI_getGopherDir(s, d);

	close(s);

	if (!removeStatusPanel() ) {

		/* someone cancelled as the directory load finished */

		freeDir(d);
		return FALSE;
	}

	if (! fetchOK) {

		/* failure to load directory */

		freeDir(d);
		showError(
			"There are no files selected by this index search\n");
		return FALSE;
	}

	setDirTime(d);

	d->selectorItem = copyItem(gi);
	if (string != NULL) {
		char	indexPath[PATH_NAME_LEN + INDEX_WORD_LEN];

		strcpy(indexPath, vStringValue(&(gi->selector)));
		strcat(indexPath, "\t");
		strcat(indexPath, string);
		vStringSet(&(d->selectorItem->selector), indexPath);
	}

	if (string != NULL) {
#define			INDEX_LABEL " - Index words: "
		char	*title = USER_STRING(d->selectorItem);
		int	len=strlen(title);
		int	remaining = USER_STRING_LEN - len;
		int	labelLen = strlen(INDEX_LABEL);

		title += len;
		strncpy(title, INDEX_LABEL, remaining);
		remaining -= labelLen;
		title += labelLen;
		strncpy(title, string, remaining);
	}
	
	pushCurrentDir(d);

	displayCurrent();

	return TRUE;
}


/* processIndexSelection
   process the index transaction from the user's selected keyword string */

void
processIndexSelection(gi, string)
gopherItemP	gi;
char		*string;
{
	/* this function is similar to a "getDirectory" operation */


	getIndexDirectory(gi, string);
}


/* GIIndex_process
   process an index search selection */

BOOLEAN
GIIndex_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;
	char *ind = getItemIndex(gi);

	if (ind == NULL) {

		/* normal case: no search string previously
		   selected.  Display panel; after string is selected,
		   it is passed to processIndexSelection. */


		/* This call will put up the panel with a grabNone, so
		   that other gopher activity can proceed.  This could
		   be slightly confusing, but allows help text panels to
		   be popped up/down from the index search request panel.
		   Any action will result in a callback that eventually
		   invokes processIndexSelection. */
		
		showIndex(gi);

	} else {
		/* if bookmark index search string is already stored
		   in the gopher item.  No need to prompt for it. */

		result = getIndexDirectory(gi, NULL);
	}


	return result;
}


/* GIIndex_init
   initialize index directory class - prefix string */

void
GIIndex_init()
{
	GU_makePrefix(prefixIndex,  appResources->prefixIndex);
	GU_registerNewType(A_INDEX, &indexSubclass);

	return;
}


/* GIIndex_restart
   clean up index subclass for a restart request */

void
GIIndex_restart()
{
	removeIndexPanel();
	return;
}
