/* error.c
   functions to handle error and notice popups */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Shell.h>

#include "osdep.h"
#include "error.h"
#include "xglobals.h"
#include "gui.h"
#include "bitmaps/sadxgopher.xbm"
#include "bitmaps/xgopher.xbm"

static Widget	topLevel;
Widget		errorDialogShell,
		errorDialog;
Widget		errorDialogLabel;
Widget		errorOkButton;
Pixmap		errorPixmap = None;

int		width;

Widget		infoDialogShell,
		infoDialog;
Widget		infoDialogLabel;
Pixmap		infoPixmap = None;


#define INFO_POPUP_NAME		"infoPopup"
				/* default values */
static popupPosResources	placementInfo = {
	/* position with the left, bottom corner near the pointer */
	from_pointer, 0, 0, justify_top_left, justify_bottom_right, True, True
	};

#define ERROR_POPUP_NAME	"errorPopup"
				/* default values */
static popupPosResources	placementError = {
	/* position with the left, bottom corner near the pointer */
	from_pointer, 0, 0, justify_top_left, justify_bottom_right, True, True
	};

#define FATAL_POPUP_NAME	"fatalErrorPopup"
				/* default values */
static popupPosResources	placementFatal = {
	/* position centered on the screen */
	from_screen, 50, 50, justify_center, justify_center, True, True
	};




/* errorOkProc
   User has read and accepted the error */

static void
errorOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(errorDialogShell);

	return;
}


/* errorExitProc
   Fatal errors exit here */

static void
errorExitProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(errorDialogShell);

	closeGUIandQuit(1);
}


/* AckError
   action procedure to acknowledge an error.
   Capitalization is for Xt convention. */

static void
AckError(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	XtCallCallbacks(errorOkButton, XtNcallback, NULL);
}


/* makeErrorDialog
   create popup dialog for reporting errors */

void
makeErrorDialog(top)
Widget	top;
{
	Arg		args[10];
	Cardinal	n = 0;
	static XtActionsRec	actionsTable[] = {
				{"ackError",   AckError}
				};

	topLevel = top;

	XtAppAddActions(appcon, actionsTable, XtNumber(actionsTable));

	n = 0;
	XtSetArg(args[n], XtNtitle, "Xgopher error");  n++;
	errorDialogShell = XtCreatePopupShell("errorDialogShell", 
					transientShellWidgetClass,
					topLevel, args, n);

	errorPixmap = XCreatePixmapFromBitmapData (XtDisplay(topLevel),
				RootWindowOfScreen(XtScreen(topLevel)),
					(char *)sadxgopher_bits,
					sadxgopher_width, sadxgopher_height,
					BlackPixelOfScreen(XtScreen(topLevel)),
					WhitePixelOfScreen(XtScreen(topLevel)),
					DefaultDepthOfScreen(XtScreen(topLevel))
					);

	n = 0;
	XtSetArg(args[n], XtNlabel, "Xgopher error");  n++;
	if (errorPixmap != None) {
		XtSetArg(args[n], XtNicon, errorPixmap);  n++;
	}
	errorDialog= XtCreateManagedWidget("errorDialog", 
					dialogWidgetClass,
					errorDialogShell, args, n);
		{
			XFontStruct	*textFontStruct;
			int		direction, ascent, descent;
			XCharStruct	overall;
			Position	topMargin, bottomMargin;

			errorDialogLabel = XtNameToWidget(errorDialog, "label");

			n=0;
			XtSetArg(args[n], XtNfont, &textFontStruct);  n++;
			XtGetValues(errorDialogLabel, args, n);
			XTextExtents(textFontStruct, "mljf", 4,
				&direction, &ascent, &descent, &overall);

			width = overall.width*20;
		}

	errorOkButton = XtCreateManagedWidget("ok", commandWidgetClass, 
					errorDialog, NULL, (Cardinal) 0);
		XtAddCallback(errorOkButton, XtNcallback, errorOkProc, NULL);


        /* for ICCCM window manager protocol complience */

        XtOverrideTranslations (errorDialogShell,
            XtParseTranslationTable ("<Message>WM_PROTOCOLS: ackError()"));

	/* find the popup placement for this shell */

	{
	popupPosResources *resourcePlacement;

	resourcePlacement = getPopupPosResources(
			ERROR_POPUP_NAME, POPUP_POS_CLASS, &placementError);
	bcopy( (char *) resourcePlacement, (char *) &placementError,
				sizeof(popupPosResources) );

	resourcePlacement = getPopupPosResources(
			FATAL_POPUP_NAME, POPUP_POS_CLASS, &placementFatal);
	bcopy( (char *) resourcePlacement, (char *) &placementFatal,
				sizeof(popupPosResources) );
	}

}


/* displayError
   enable popup dialog for saving files */

void
displayError(errorText, fatal)
char	*errorText;
Boolean	fatal;
{
	Arg		args[10];
	Cardinal	n = 0;


	n = 0;
	XtSetArg(args[n], XtNlabel, errorText);  n++;
	XtSetValues(errorDialog, args, n);

	n = 0;
	XtSetArg(args[n], XtNwidth, width);  n++;
	XtSetValues(errorDialogLabel, args, n);


	if (fatal) {
		XtAddCallback(errorOkButton, XtNcallback, errorExitProc, NULL);
		positionAPopup(errorDialogShell, topLevel, &placementFatal);
	} else {
		positionAPopup(errorDialogShell, topLevel, &placementError);
	}


	XtPopup(errorDialogShell, XtGrabExclusive);

        /* for ICCCM window manager protocol complience */

        (void) XSetWMProtocols (XtDisplay(errorDialogShell),
			 XtWindow(errorDialogShell), &wmDeleteAtom, 1);

	return;
}

/* info popup and stuff */

/* infoOkProc
   User has read and accepted the information */

static void
infoOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(infoDialogShell);

	return;
}


/* AckInfo
   action procedure to acknowledge an information popup.
   Capitalization is for Xt convention. */

static void
AckInfo(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	infoOkProc(w, NULL, NULL);
}


/* makeInfoDialog
   create popup dialog for reporting infos */

void
makeInfoDialog(top)
Widget	top;
{
	Widget		infoOkButton;
	Arg		args[10];
	Cardinal	n = 0;

	static XtActionsRec	actionsTable[] = {
				{"ackInfo",   AckInfo}
				};

	topLevel = top;

	XtAppAddActions(appcon, actionsTable, XtNumber(actionsTable));

	n = 0;
	XtSetArg(args[n], XtNtitle, "Xgopher information");  n++;
	infoDialogShell = XtCreatePopupShell("infoDialogShell", 
					transientShellWidgetClass,
					topLevel, args, n);

	infoPixmap = XCreatePixmapFromBitmapData (XtDisplay(topLevel),
				RootWindowOfScreen(XtScreen(topLevel)),
					(char *)xgopher_bits,
					xgopher_width, xgopher_height,
					BlackPixelOfScreen(XtScreen(topLevel)),
					WhitePixelOfScreen(XtScreen(topLevel)),
					DefaultDepthOfScreen(XtScreen(topLevel))
					);

	n = 0;
	XtSetArg(args[n], XtNlabel, "Xgopher information");  n++;
	if (infoPixmap != None) {
		XtSetArg(args[n], XtNicon, infoPixmap);  n++;
	}
	infoDialog= XtCreateManagedWidget("infoDialog", 
					dialogWidgetClass,
					infoDialogShell, args, n);
		{
			XFontStruct	*textFontStruct;
			int		direction, ascent, descent;
			XCharStruct	overall;
			Position	topMargin, bottomMargin;

			infoDialogLabel = XtNameToWidget(infoDialog, "label");

			n=0;
			XtSetArg(args[n], XtNfont, &textFontStruct);  n++;
			XtGetValues(infoDialogLabel, args, n);
			XTextExtents(textFontStruct, "mljf", 4,
				&direction, &ascent, &descent, &overall);

			width = overall.width*20;
		}

	infoOkButton = XtCreateManagedWidget("ok", commandWidgetClass, 
					infoDialog, NULL, (Cardinal) 0);
		XtAddCallback(infoOkButton, XtNcallback, infoOkProc, NULL);

        /* for ICCCM window manager protocol complience */

        XtOverrideTranslations (infoDialogShell,
            XtParseTranslationTable ("<Message>WM_PROTOCOLS: ackInfo()"));


	/* find the popup placement for this shell */

	{
	popupPosResources *resourcePlacement;

	resourcePlacement = getPopupPosResources(
			INFO_POPUP_NAME, POPUP_POS_CLASS, &placementInfo);
	bcopy( (char *) resourcePlacement, (char *) &placementInfo,
				sizeof(popupPosResources) );
	}

}


/* displayInfo
   enable popup dialog for saving files */

void
displayInfo(infoText)
char	*infoText;
{
	Arg		args[10];
	Cardinal	n = 0;


	n = 0;
	XtSetArg(args[n], XtNlabel, infoText);  n++;
	XtSetValues(infoDialog, args, n);

	n = 0;
	XtSetArg(args[n], XtNwidth, width);  n++;
	XtSetValues(infoDialogLabel, args, n);


	positionAPopup(infoDialogShell, topLevel, &placementInfo);


	XtPopup(infoDialogShell, XtGrabNone);

        /* for ICCCM window manager protocol complience */

        (void) XSetWMProtocols (XtDisplay(infoDialogShell),
        	 XtWindow(infoDialogShell), &wmDeleteAtom, 1);
	return;
}
