/*
 * Copyright (c) 1989, 1990, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static  char rcsid[] =
	"@(#)/master/usr.sbin/tcpdump/tcpdump/print-sl.c,v 2.2 1995/10/26 20:31:14 prb Exp (LBL)";
#endif

#ifdef CSLIP
#include <sys/param.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/mbuf.h>
#include <sys/socket.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include <net/slcompress.h>
#include <net/slip.h>

#include <net/ppp_proto.h>

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <pcap.h>
#include <signal.h>
#include <stdio.h>

#include "interface.h"
#include "addrtoname.h"

static int lastlen[2][256];
static int lastconn = 255;

static void sliplink_print(const u_char *, int, const u_char *, int,
			   const struct ip *, int, int);
static void compressed_sl_print(const u_char *, int,
				const struct ip *, int, int);
static void _if_print(u_char *, const struct pcap_pkthdr *,
		      const u_char *, char *);

void
ppp_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{
	_if_print(user, h, p, "ppp");
}

void
sl_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{
	_if_print(user, h, p, "slip");
}

static void
_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p, char *n)
{
	register int caplen = h->caplen;
	register int length = h->len;
	register const struct ip *ip;

#define	LLEN	p[1]			/* Link Level header length */
#define	CLEN	p[2]			/* Compressed header length */
#define	LLP	(p+SLC_BPFHDRLEN)	/* Pointer to Link level header */
#define	CHDR	(p+SLC_BPFHDRLEN+LLEN)	/* Pointer to Compressed header */


	ts_print(&h->ts);

	if (caplen < SLC_BPFHDR) {
		printf("[|%s]", n);
		goto out;
	}
	/*
	 * Some printers want to get back at the link level addresses,
	 * and/or check that they're not walking off the end of the packet.
	 * Rather than pass them all the way down, we set these globals.
	 */
	packetp = p;
	snapend = p + caplen;

	length -= SLC_BPFHDR;
	ip = (struct ip *)(p + SLC_BPFHDR);

	if (eflag)
		sliplink_print(LLP, LLEN, CHDR, CLEN, ip, length, p[0]);

	ip_print((u_char *)ip, length);

	if (xflag)
		default_print((u_char *)ip, caplen - SLC_BPFHDR);
 out:
	putchar('\n');
}

static void
sliplink_print(register const u_char *lhdr, int lhdrlen,
	       register const u_char *chdr, int chdrlen,
	       register const struct ip *ip, register int length, int dir)
{
	int i;
	int hlen;
	int proto = 0;
	int type;

	putchar(dir == SLIPDIR_IN ? 'I' : 'O');
	putchar(' ');

	switch (lhdrlen) {

	case 0:
		break;

	unknown:
	default:
		printf("LL[");
		for (i = 0; i < lhdrlen - 1; ++i)
			printf("%02x.", lhdr[i]);
		printf("%02x] ", lhdr[lhdrlen - 1]);
		break;

	case 3:
		if (lhdr[0] != PPP_ADDRESS || lhdr[1] != PPP_CONTROL ||
		    lhdr[2] == 0)
			goto unknown;
		lhdr += 2;
	case 1:
		proto = lhdr[0];
		break;

	case 4:
		if (lhdr[0] != PPP_ADDRESS || lhdr[1] != PPP_CONTROL ||
		    (lhdr[2] == 0 && lhdr[3] == 0))
			goto unknown;
		lhdr += 2;
	case 2:
		proto = (lhdr[0] << 8) | lhdr[1];
		break;
	}

    	switch (type = proto) {
	case PPP_IP:		printf("IP "); break;
	case PPP_OSI:		printf("OSI "); break;
	case PPP_NS:		printf("NS "); break;
	case PPP_DECNET:	printf("DECNET "); break;
	case PPP_APPLE:		printf("APPLE "); break;
	case PPP_IPX:		printf("IPX "); break;
	case PPP_VJC:		printf("VJC "); break;
	case PPP_VJNC:		printf("VJNC "); break;
	case PPP_BRPDU:		printf("BRPDU "); break;
	case PPP_STII:		printf("STII "); break;
	case PPP_VINES:		printf("VINES "); break;
	case PPP_HELLO:		printf("HELLO "); break;
	case PPP_LUXCOM:	printf("LUXCOM "); break;
	case PPP_SNS:		printf("SNS "); break;
	case PPP_IPCP:		printf("IPCP "); break;
	case PPP_OSICP:		printf("OSICP "); break;
	case PPP_NSCP:		printf("NSCP "); break;
	case PPP_DECNETCP:	printf("DECNETCP "); break;
	case PPP_APPLECP:	printf("APPLECP "); break;
	case PPP_IPXCP:		printf("IPXCP "); break;
	case PPP_STIICP:	printf("STIICP "); break;
	case PPP_VINESCP:	printf("VINESCP "); break;
	case PPP_LCP:		printf("LCP "); break;
	case PPP_PAP:		printf("PAP "); break;
	case PPP_LQM:		printf("LQM "); break;
	case PPP_CHAP:		printf("CHAP "); break;
	case 0:
		if (nflag)
			break;
		switch (chdr[0] & 0xf0) {
		case TYPE_IP:
			printf("ip ");
			type = PPP_IP;
			break;
		case TYPE_UNCOMPRESSED_TCP:
			printf("utcp ");
			type = PPP_VJNC;
			break;
		default:
			if (chdrlen == 0)
				break;
			else if (chdr[0] & TYPE_COMPRESSED_TCP) {
				printf("ctcp ");
				type = PPP_VJC;
			} else
				printf("slip-%d!: ", chdr[0]);
			break;
		}
		break;
	default:		printf("PROTO:%04x ", proto); break;
	}

	if (chdrlen == 0) {
		printf("%d: ", length);
		return;
	}

	if (nflag) {
		/* XXX just dump the header */
		for (i = 0; i < chdrlen - 1; ++i)
			printf("%02x.", chdr[i]);
		printf("%02x: ", chdr[chdrlen - 1]);
		return;
	}

	switch (type) {

	case PPP_IP:
		printf("ip %d: ", length);
		break;

	case PPP_VJNC:
		/*
		 * The connection id is stode in the IP protcol field.
		 */
		lastconn = ip->ip_p;
		hlen = ip->ip_hl;
		hlen += ((struct tcphdr *)&((int *)ip)[hlen])->th_off;
		lastlen[dir][lastconn] = length - (hlen << 2);
		printf("utcp %d: ", lastconn);
		break;

	case PPP_VJC:
		compressed_sl_print(chdr, chdrlen, ip, length, dir);
		printf(": ");
	}
}

static const u_char *
print_sl_change(const char *str, register const u_char *cp)
{
	register u_int i;

	if ((i = *cp++) == 0) {
		i = (cp[0] << 8) | cp[1];
		cp += 2;
	}
	printf(" %s%d", str, i);
	return (cp);
}

static const u_char *
print_sl_winchange(register const u_char *cp)
{
	register short i;

	if ((i = *cp++) == 0) {
		i = (cp[0] << 8) | cp[1];
		cp += 2;
	}
	if (i >= 0)
		printf(" W+%d", i);
	else
		printf(" W%d", i);
	return (cp);
}

static void
compressed_sl_print(const u_char *chdr, int chdrlen, const struct ip *ip,
		    int length, int dir)
{
	register const u_char *cp = chdr;
	register u_int flags;
	int hlen;

	flags = *cp++;
	if (flags & NEW_C) {
		lastconn = *cp++;
		printf("%d", lastconn);
	} else
		printf("*");

	/* skip tcp checksum */
	cp += 2;

	switch (flags & SPECIALS_MASK) {
	case SPECIAL_I:
		printf(" *SA+%d", lastlen[dir][lastconn]);
		break;

	case SPECIAL_D:
		printf(" *S+%d", lastlen[dir][lastconn]);
		break;

	default:
		if (flags & NEW_U)
			cp = print_sl_change("U=", cp);
		if (flags & NEW_W)
			cp = print_sl_winchange(cp);
		if (flags & NEW_A)
			cp = print_sl_change("A+", cp);
		if (flags & NEW_S)
			cp = print_sl_change("S+", cp);
		break;
	}
	if (flags & NEW_I)
		cp = print_sl_change("I+", cp);

	/*
	 * 'hlen' is the length of the uncompressed TCP/IP header (in words).
	 * 'cp - chdr' is the length of the compressed header.
	 * 'length - hlen' is the amount of data in the packet.
	 */
	hlen = ip->ip_hl;
	hlen += ((struct tcphdr *)&((int32 *)ip)[hlen])->th_off;
	lastlen[dir][lastconn] = length - (hlen << 2);
	printf(" %d (%d)", lastlen[dir][lastconn], chdrlen);
	if (chdrlen != cp - chdr)
		printf("[len%d->%d]", chdrlen, cp - chdr);
}
#else
#include <sys/types.h>
#include <sys/time.h>

#include <stdio.h>

#include "interface.h"
void
sl_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{

	error("not configured for slip");
	/* NOTREACHED */
}
void
ppp_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{

	error("not configured for ppp");
	/* NOTREACHED */
}
#endif
