/*-
//////////////////////////////////////////////////////////////////////////
//									//
//   Copyright (c) 1995 Migration Associates Corp. All Rights Reserved	//
//									//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF MIGRATION ASSOCIATES	//
//	The copyright notice above does not evidence any   		//
//	actual or intended publication of such source code.		//
//									//
//	Use, duplication, or disclosure by the Government is		//
//	subject to restrictions as set forth in FAR 52.227-19,		//
//	and (for NASA) as supplemented in NASA FAR 18.52.227-19,	//
//	in subparagraph (c) (1) (ii) of Rights in Technical Data	//
//	and Computer Software clause at DFARS 252.227-7013, any		//
//	successor regulations or comparable regulations of other	//
//	Government agencies as appropriate.				//
//									//
//		Migration Associates Corporation			//
//			19935 Hamal Drive				//
//			Monument, CO 80132				//
//									//
//	A license is granted to Berkeley Software Design, Inc. by	//
//	Migration Associates Corporation to redistribute this software	//
//	under the terms and conditions of the software License		//
//	Agreement provided with this distribution.  The Berkeley	//
//	Software Design Inc. software License Agreement specifies the	//
//	terms and conditions for redistribution.			//
//									//
//	UNDER U.S. LAW, THIS SOFTWARE MAY REQUIRE A LICENSE FROM	//
//	THE U.S. COMMERCE DEPARTMENT TO BE EXPORTED.  IT IS YOUR	//
//	REQUIREMENT TO OBTAIN THIS LICENSE PRIOR TO EXPORTATION.	//
//									//
//////////////////////////////////////////////////////////////////////////
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "snkdb.h"

extern char *__progname;

main(int argc, char **argv)
{
	int	c;
	int	errors = 0;
	int	verbose = 0;
	static	char *optstr = "v";


	openlog("login", LOG_ODELAY, LOG_AUTH);

	if (getuid() != 0) {	/* log it & quietly go away	*/
		syslog(LOG_INFO, "Attempt to use %s by unauthorized user %s",
				__progname, getlogin());
		exit(1);
	}

    	while ((c = getopt(argc, argv, optstr)) != EOF)
		switch(c) {
		case 'v':	/* verbose */
			verbose++;
			continue;
		default:
			fprintf(stderr, "Usage is: %s -%s username [ username ... ]\n",
					__progname, optstr);
			exit(1);
		}

	argc -= optind;
	argv = &argv[optind];

	while (argc--) {
		switch(snkdb_delrec(*argv)) {
		case 0:
			if (verbose) {
				printf("%s: User %s removed from SNK004 database\n",
				    __progname, *argv);
				fflush(stdout);
			}
			syslog(LOG_INFO, "User %s removed from SNK004 database", *argv);
			break;
		case -1:
		default:
			fprintf(stderr,
			    "%s: Error removing user %s from SNK004 database.\n",
			    __progname, *argv);
			syslog(LOG_INFO,
			    "Error removing user %s from SNK004 database",
			    *argv);
			errors++;
		}
		*argv++;
	}
	exit(errors);
}
