/*-
//////////////////////////////////////////////////////////////////////////
//									//
//   Copyright (c) 1995 Migration Associates Corp. All Rights Reserved	//
//									//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF MIGRATION ASSOCIATES	//
//	The copyright notice above does not evidence any   		//
//	actual or intended publication of such source code.		//
//									//
//	Use, duplication, or disclosure by the Government is		//
//	subject to restrictions as set forth in FAR 52.227-19,		//
//	and (for NASA) as supplemented in NASA FAR 18.52.227-19,	//
//	in subparagraph (c) (1) (ii) of Rights in Technical Data	//
//	and Computer Software clause at DFARS 252.227-7013, any		//
//	successor regulations or comparable regulations of other	//
//	Government agencies as appropriate.				//
//									//
//		Migration Associates Corporation			//
//			19935 Hamal Drive				//
//			Monument, CO 80132				//
//									//
//	A license is granted to Berkeley Software Design, Inc. by	//
//	Migration Associates Corporation to redistribute this software	//
//	under the terms and conditions of the software License		//
//	Agreement provided with this distribution.  The Berkeley	//
//	Software Design Inc. software License Agreement specifies the	//
//	terms and conditions for redistribution.			//
//									//
//	UNDER U.S. LAW, THIS SOFTWARE MAY REQUIRE A LICENSE FROM	//
//	THE U.S. COMMERCE DEPARTMENT TO BE EXPORTED.  IT IS YOUR	//
//	REQUIREMENT TO OBTAIN THIS LICENSE PRIOR TO EXPORTATION.	//
//									//
//////////////////////////////////////////////////////////////////////////
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/resource.h>

#include "snk.h"

static	void	strip_crlf(char *);
static	int	parse_secret(char *, unsigned char *);

extern char *__progname;

main(int argc, char **argv)
{
	unsigned cmd = SNK_INITUSER;
	int	c;
	int	errors = 0;
	int	verbose = 0;
	char	seed[80];
	unsigned char	secret[9];
	static	char	*optstr = "fsv";

	struct rlimit cds;

	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);

	openlog("login", LOG_ODELAY, LOG_AUTH);

	cds.rlim_cur = 0;
	cds.rlim_max = 0;
	if (setrlimit(RLIMIT_CORE, &cds) < 0)
		syslog(LOG_ERR, "couldn't set core dump size to 0: %m");

	if (getuid() != 0) {	/* log it & quietly go away	*/
		syslog(LOG_INFO, "Attempt to use %s by unauthorized user %s",
				__progname, getlogin());
		exit(0);
	}

    	while ((c = getopt(argc, argv, optstr)) != EOF)
		switch(c) {
		case 'f':	/* force initialize existing user account */
			cmd |= SNK_FORCEINIT;
			continue;

		case 's':	/* generate seed during initialization */
			cmd |= SNK_GENSECRET;
			continue;

		case 'v':	/* verbose */
			verbose++;
			continue;
		default:
			fprintf(stderr, "Usage is: %s -%s username [ username ... ]\n",
					__progname, optstr);
			exit(1);
		}

	argc -= optind;
	argv = &argv[optind];

	while (argc--) {
		if (verbose) {
			printf("Adding %s to SNK-004 database\n", *argv);
			fflush(stdout);
		}
		if (!(cmd & SNK_GENSECRET)) {
			printf(
	"Enter a series of 8 3-digit octal numbers as a seed for %s\'s token:\n",
			    *argv);
			if (fgets(seed, sizeof(seed), stdin) == NULL) {
				fprintf(stderr,
			    	    "%s: No seed supplied for token.\n",
				    __progname);
				exit(1);
			}
			strip_crlf(seed);
			if (strlen(seed) == 0) {
				fprintf(stderr,
				    "%s: No seed supplied for token.\n",
				    __progname);
				exit(1);
			}
			memset(secret, 0, sizeof(secret));
			if (parse_secret(seed, secret)) {
				fprintf(stderr, "%s: Invalid secret entered.\n",
				    __progname);
				exit(1);
			}
		}
		switch(snkuserinit(cmd, *argv, secret)) {
		case 0:
			syslog(LOG_INFO,
			    "User %s initialized in SNK-004 database", *argv);
			break;
		case 1:
			fprintf(stderr,
			    "%s: User %s already exists in SNK-004 database!\n",
			    __progname, *argv);
			syslog(LOG_INFO,
			    "User %s already exists in SNK-004 database", *argv);
			errors++;
			break;
		case -1:
			fprintf(stderr,
			    "%s: Error initializing user %s in SNK-004 database.\n",
			    __progname, *argv);
			syslog(LOG_INFO,
			    "Error initializing user %s in SNK-004 database: %m",
			    *argv);
			errors++;
		}
		*argv++;
	}
	exit(errors);
}

/*
 * Strip trailing cr/lf from a line of text
 */

void
strip_crlf(char *buf)
{
        char *cp;

        if((cp = strchr(buf,'\r')) != NULL)
                *cp = '\0';

        if((cp = strchr(buf,'\n')) != NULL)
                *cp = '\0';
}

/*
 * Parse the 8 octal numbers into a token secret
 */

static	int
parse_secret(char *seed, unsigned char *secret)
{
	int i;
	unsigned tmp[8];

	if ((i = sscanf(seed, "%o %o %o %o %o %o %o %o",
	    &tmp[0], &tmp[1], &tmp[2], &tmp[3],
	    &tmp[4], &tmp[5], &tmp[6], &tmp[7])) != 8)
		return (-1);

	for (i=0; i < 8; i++)
		secret[i] = tmp[i] & 0xff;

	return (0);
}
