/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sparc.c,v 2.1 1995/03/20 05:16:29 torek Exp
 */

#include <sys/types.h>
#include <a.out.h>
#include <string.h>
#include "shlist.h"

#define	N_CODEOFF(e) \
	(N_TXTOFF(e) + ((e).a_magic == ZMAGIC ? sizeof(e) : 0))

#define	NCODEBYTES	8

static char codebytes[NCODEBYTES];
static int ncodebytes;
static struct reloc_info_sparc ltreloc[2];	/* 0 = hi22, 1 = lo10 */

/*
 * Given a pointer to the exec struct at the front of shlicrt0.o,
 * initialize the machine-dependent library table locator code.
 * Find the offset for library tables, and set things up so that
 * we can verify that a binary does in fact use shared libraries.
 * (The entire shlicrt0.o has been mmap'ed in.)
 */
char *
md_init(v)
	caddr_t v;
{
	struct exec *ep;
	struct nlist *sym, *sym_base, *sym_end;
	struct reloc_info_sparc *r, *r_base, *r_end;
	char *strings;
	int low_reloc, ltsym;
	struct reloc_info_sparc tmp;

	/*
	 * Search the symbol table for __LIBRARY_TABLE.
	 */
	ep = (struct exec *)v;
	strings = (char *)v + N_STROFF(*ep);
	sym_base = (struct nlist *)(v + N_SYMOFF(*ep));
	sym_end = sym_base + ep->a_syms / sizeof *sym_base;
	ltsym = -1;
	for (sym = sym_base; sym < sym_end; ++sym) {
		if (sym->n_type & N_EXT && (sym->n_type & N_TYPE) == N_UNDF &&
		    strcmp(&strings[sym->n_un.n_strx], "___LIBRARY_TABLE")
			    == 0) {
			ltsym = sym - sym_base;
			break;
		}
	}
	if (ltsym == -1)
		return ("can't find ___LIBRARY_TABLE symbol");

	/*
	 * Find two text relocations corresponding to __LIBRARY_TABLE.
	 */
	r_base = (struct reloc_info_sparc *)(v + N_DATOFF(*ep) + ep->a_data);
	r_end = r_base + ep->a_trsize / sizeof *r_base;
	low_reloc = ep->a_text;
	for (r = r_base; r < r_end; ++r) {
		if (r->r_address < low_reloc)
			low_reloc = r->r_address;
		if (r->r_extern && r->r_index == ltsym) {
			if (!ltreloc[0].r_extern)
				ltreloc[0] = *r;
			else if (!ltreloc[1].r_extern)
				ltreloc[1] = *r;
		}
	}
	if (!ltreloc[1].r_extern)
		return ("can't find ___LIBRARY_TABLE relocations");

	/* If in wrong order, swap. */
	if (ltreloc[0].r_type == RELOC_LO10)
		tmp = ltreloc[0], ltreloc[0] = ltreloc[1], ltreloc[1] = tmp;

	if (ltreloc[0].r_type != RELOC_HI22 || ltreloc[1].r_type != RELOC_LO10)
		return ("unexpected ___LIBRARY_TABLE relocations");

	/*
	 * Fill in initial opcode string and length.
	 */
	low_reloc -= N_CODEOFF(*ep) - N_TXTOFF(*ep);
	ncodebytes = low_reloc < NCODEBYTES ? low_reloc : NCODEBYTES;
	bcopy(v + N_TXTOFF(*ep), codebytes, ncodebytes);

	return (NULL);
}

/*
 * Given a pointer to the exec structure of a binary, find the `basic'
 * offset (the difference between a text virtual address and a file
 * offset) and the (text) virtual address of the library table.
 * Return 0 if the binary does not use shared libraries.
 * (The entire binary has been mmap'ed in.)
 */
int
md_ltoff(v, basep, addrp)
	caddr_t v;
	u_long *basep, *addrp;
{
	struct exec *ep;
	caddr_t ltpp;
	u_long ltp0, ltp1;
#define	HI22(x) ((x) & ((1 << 22) - 1))
#define	LO10(x) ((x) & ((1 << 10) - 1))

	/* Make sure it starts with shlicrt0.o. */
	ep = (struct exec *)v;
	if (bcmp(v + N_CODEOFF(*ep), codebytes, ncodebytes))
		return (0);

	ltpp = v + N_CODEOFF(*ep) + ltreloc[0].r_address;
	ltp0 = HI22(*(u_long *)ltpp) - ltreloc[0].r_addend;
	ltpp = v + N_CODEOFF(*ep) + ltreloc[1].r_address;
	ltp1 = LO10(*(u_long *)ltpp) - ltreloc[1].r_addend;
	*basep = N_TXTOFF(*ep) - N_TXTADDR(*ep);
	*addrp = (ltp0 << 10) + ltp1;
	return (1);
}
