/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI shlist.c,v 2.3 1995/11/07 16:52:46 prb Exp
 */

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <a.out.h>
#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "shlist.h"

struct ldtab {
	char *name;
	caddr_t address;
};

static char SHLICRT0[] = "/usr/lib/shlicrt0.o";

extern char *__progname;

caddr_t
mapaout(fname, stp, reloc_okay)
	char *fname;
	struct stat *stp;
	int reloc_okay;
{
	int f, saverr;
	caddr_t v;
	struct exec *ep;

	f = open(fname, O_RDONLY);
	if (f < 0)
		return (NULL);
	if (fstat(f, stp) == -1 ||
	    (v = mmap(0, stp->st_size, PROT_READ, 0, f, 0)) == (caddr_t)-1) {
		saverr = errno;
		(void)close(f);
		errno = saverr;
		return (NULL);
	}
	ep = (struct exec *)v;
	if (stp->st_size < sizeof(*ep) || N_BADMAG(*ep) ||
	    (!reloc_okay && (ep->a_trsize || ep->a_drsize))) {
		(void)munmap(v, stp->st_size);
		(void)close(f);
		errno = EFTYPE;
		return (NULL);
	}
	(void)close(f);
	return (v);
}

int
main(argc, argv)
	int argc;
	char **argv;
{
	struct ldtab *lt;
	char *errmsg;
	int aflag, c, ev;
	u_long o1, o2;
	caddr_t v;
	struct stat s;

	aflag = 0;
	while ((c = getopt(argc, argv, "a")) != EOF)
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		default:
			errx(1, "usage: %s [-a] files ...", __progname);
			break;
		}
	argc -= optind;
	argv += optind;

	if (argc <= 0)
		errx(1, "usage: %s [-a] files ...", __progname);

	/* Initialize from shared startup code. */
	if ((v = mapaout(SHLICRT0, &s, 1)) == NULL)
		err(1, "%s", SHLICRT0);
	if ((errmsg = md_init(v)) != NULL)
		errx(1, "%s: %s", SHLICRT0, errmsg);
	munmap(v, s.st_size);

	/* List shared libraries, per file. */
	for (ev = 0; *argv; ++argv) {
		if ((v = mapaout(*argv, &s, 0)) == NULL) {
			warn("%s", *argv);
			ev = 1;
			continue;
		}

		printf("%s:", *argv);
		if (md_ltoff(v, &o1, &o2)) {
			/*
			 * Iterate through __LIBRARY_TABLE, printing names.
			 */
			lt = (struct ldtab *)(v + o1 + o2);
			for (; lt->name; ++lt) {
				printf(" %s", (char *)v + o1 + (int)lt->name);
				if (aflag)
					printf("<%#10x>", (u_int)lt->address);
			}
		}
		putchar('\n');
		munmap(v, s.st_size);
	}

	return (ev);
}
