/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI shlicrt0.i386.s,v 2.1 1995/03/05 04:01:01 torek Exp
 */

/*
 * Bootstrap for programs that use fixed-address static shared libraries.
 */

/*
 * A few include files support assembly code.
 */
#define LOCORE

#include <sys/syscall.h>
#include <machine/segments.h>

/*
 * We must duplicate definitions from include files
 * that aren't compatible with cpp/assembly files.
 */

/* #include <fcntl.h> */
#define O_RDONLY	0

/* #include <sys/mman.h> */
#define PROT_READ	0x04
#define PROT_EXEC	0x01

#define MAP_SHARED	0x0010
#define MAP_FIXED	0x0100

/* #include <sys/param.h> */
#define	NBPG		4096

	.text
	.globl start
start:
	/*
	 * Open the shared library file.
	 */
	pushl $0			/* mode */
	pushl $O_RDONLY			/* flags */
	movl $___LIBRARY_TABLE,%esi
	pushl (%esi)			/* filename */
	pushl $0			/* placeholder */
	movb $SYS_open,%al
	lcall $LSEL(L43BSDCALLS_SEL,SEL_UPL),$0
	jb Ldisaster

	/*
	 * Call mmap() to map the first page of the loader file.
	 */
	popl (%esp)			/* now have 3 zeroes on stack */
					/* (64-bit offset + pad) */
	pushl %eax			/* fd; last argument to loader */
	pushl $MAP_SHARED|MAP_FIXED	/* flags */
	pushl $PROT_EXEC|PROT_READ	/* prot */
	pushl $NBPG			/* len */
	pushl 4(%esi)			/* addr */
	pushl $0			/* placeholder */
	movb $SYS_mmap,%al
	lcall $LSEL(L43BSDCALLS_SEL,SEL_UPL),$0
	jb Ldisaster

	addl $20,%esp			/* leave fd & zeroes on stack */

	/*
	 * Call the loader initialization routine to get started.
	 * The latter will take care of traditional crt0 concerns
	 * like setting up argv/envp/environ and calling main().
	 * It will also clean up after the bootstrap.
	 */
	pushl %esi			/* table */
	pushl %ebx			/* ps_strings */
	pushl $_end			/* start of heap */
	pushl $_main			/* entry point */
	movl 4(%esi),%eax
	addl $32,%eax			/* skip QMAGIC header */
	call *%eax			/* never returns */

	/*
	 * Print '...: not found' if we can't open or map the loader.
	 * The following code roughly doubles the size of the bootstrap!
	 */
Lnotfound:
	.ascii ": not found\n"

Ldisaster:
	movl (%esi),%edi
	xorl %eax,%eax
	xorl %ecx,%ecx
	decl %ecx
	repne; scasb
	subl (%esi),%edi
	decl %edi
	pushl %edi
	pushl (%esi)
	pushl $2
	pushl $0
	movb $SYS_write,%al
	lcall $LSEL(L43BSDCALLS_SEL,SEL_UPL),$0

	pushl $12
	pushl $Lnotfound
	pushl $2
	pushl $0
	movb $SYS_write,%al
	lcall $LSEL(L43BSDCALLS_SEL,SEL_UPL),$0

	hlt				/* get attention -- dump core */
