%{
/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI scan.l,v 1.2 1995/12/09 16:22:21 bostic Exp
 */

#include <stdlib.h>
#include <string.h>
#include <i386/isa/aicreg.h>
#include "symbol.h"
#include "y.tab.h"
#include "sequencer.h"

int	yyline;
char	*yyfile;


#define	yywrap() 1

%}

PATH		[-/A-Za-z0-9_.]*[./][-/A-Za-z0-9_.]*
WORD		[A-Za-z_][-A-Za-z_0-9]*
SPC		[ \t]+
NL		\n
COMMA		,
SEMICOLON	\;
AMPERSAND	\&
COLON		\:
DOT		\.
POUND		#
END		{NL}|{SPC}|{COMMA}|{SEMICOLON}|{COLON}

%x CMNT
%%
"/*"	BEGIN CMNT;
<CMNT>.	{};
<CMNT>\n {yyline++;};
<CMNT>"*/"	BEGIN INITIAL;



jz/{END}	{ yylval.value = AIC_S_JZ;	return T_JZ;	}
jnz/{END}	{ yylval.value = AIC_S_JNZ;	return T_JNZ;	}

js/{END}	{ yylval.value = AIC_S_JNZ;	return T_JS;	}
jns/{END}	{ yylval.value = AIC_S_JZ;	return T_JNS;	}

je/{END}	{ yylval.value = AIC_S_JZ;	return T_JE;	}
jne/{END}	{ yylval.value = AIC_S_JNZ;	return T_JNE;	}

rr/{END}	{ yylval.value = AIC_S_ROTATERIGHT;	return T_RR; }
rl/{END}	{ yylval.value = AIC_S_ROTATELEFT;	return T_RL; }
sr/{END}	{ yylval.value = AIC_S_SHIFTRIGHT;	return T_SR; }
sl/{END}	{ yylval.value = AIC_S_SHIFTLEFT;	return T_SL; }


SEQCTL/{END}	{ yylval.value = AIC_SEQCTL;		return T_RWREG; }
SEQRAM/{END}	{ yylval.value = AIC_SEQRAM;		return T_RWREG; }
SEQADDR0/{END}	{ yylval.value = AIC_SEQADDR0;		return T_RWREG; }
SEQADDR1/{END}	{ yylval.value = AIC_SEQADDR1;		return T_RWREG; }
AC/{END}	{ yylval.value = AIC_ACCUM;		return T_AC; }
SRCPTR/{END}	{ yylval.value = AIC_SINDEX;		return T_RWREG; }
DSTPTR/{END}	{ yylval.value = AIC_DINDEX;		return T_RWREG; }
BRKADD0/{END}	{ yylval.value = AIC_BRKADDR0;		return T_RWREG; }
BRKADD1/{END}	{ yylval.value = AIC_BRKADDR1;		return T_RWREG; }
ALLONES/{END}	{ yylval.value = AIC_ALLONES;		return T_ROREG; }
ALLZEROS/{END}	{ yylval.value = AIC_ALLZEROS;		return T_ROREG; }
NONE/{END}	{ yylval.value = AIC_NONE;		return T_WOREG; }
FLAGS/{END}	{ yylval.value = AIC_FLAGS;		return T_ROREG; }
SRCDATA/{END}	{ yylval.value = AIC_SINDIR;		return T_ROREG; }
DSTDATA/{END}	{ yylval.value = AIC_DINDIR;		return T_WOREG; }
FUNCT1/{END}	{ yylval.value = AIC_FUNCT1;		return T_RWREG; }
STACK/{END}	{ yylval.value = AIC_STACK;		return T_ROREG; }


SCSISEQ/{END}	{ yylval.value = AIC_SCSISEQ;		return T_RWREG; }
SXFRCTL0/{END}	{ yylval.value = AIC_SXFRCTL0;		return T_RWREG; }
SXFRCTL1/{END}	{ yylval.value = AIC_SXFRCTL1;		return T_RWREG; }
SCSISIGI/{END}	{ yylval.value = AIC_SCSISIGI;		return T_ROREG; }
SCSISIGO/{END}	{ yylval.value = AIC_SCSISIGO;		return T_WOREG; }
SCSIRATE/{END}	{ yylval.value = AIC_SCSIRATE;		return T_RWREG; }
SCSIID/{END}	{ yylval.value = AIC_SCSIID;		return T_RWREG; }
SCSIDATAL/{END}	{ yylval.value = AIC_SCSIDATL;		return T_RWREG; }
SCSIDATAH/{END}	{ yylval.value = AIC_SCSIDATH;		return T_RWREG; }
STCNT0/{END}	{ yylval.value = AIC_STCNT0;		return T_RWREG; }
STCNT1/{END}	{ yylval.value = AIC_STCNT1;		return T_RWREG; }
STCNT2/{END}	{ yylval.value = AIC_STCNT2;		return T_RWREG; }
CLRSINT0/{END}	{ yylval.value = AIC_CLRSINT0;		return T_WOREG; }
SSTAT0/{END}	{ yylval.value = AIC_SSTAT0;		return T_ROREG; }
CLRSINT1/{END}	{ yylval.value = AIC_CLRSINT1;		return T_WOREG; }
SSTAT1/{END}	{ yylval.value = AIC_SSTAT1;		return T_ROREG; }
SSTAT2/{END}	{ yylval.value = AIC_SSTAT2;		return T_ROREG; }
SSTAT3/{END}	{ yylval.value = AIC_SSTAT3;		return T_ROREG; }
SCSITEST/{END}	{ yylval.value = AIC_SCSITEST;		return T_RWREG; }
SIMODE0/{END}	{ yylval.value = AIC_SIMODE0;		return T_RWREG; }
SIMODE1/{END}	{ yylval.value = AIC_SIMODE1;		return T_RWREG; }
SCSIBUSL/{END}	{ yylval.value = AIC_SCSIBUSL;		return T_ROREG; }
SCSIBUSH/{END}	{ yylval.value = AIC_SCSIBUSH;		return T_ROREG; }
SHADDR0/{END}	{ yylval.value = AIC_SHADDR0;		return T_ROREG; }
SHADDR1/{END}	{ yylval.value = AIC_SHADDR1;		return T_ROREG; }
SHADDR2/{END}	{ yylval.value = AIC_SHADDR2;		return T_ROREG; }
SHADDR3/{END}	{ yylval.value = AIC_SHADDR3;		return T_ROREG; }
SELTIMER/{END}	{ yylval.value = AIC_SELTIMER;		return T_ROREG; }
SELID/{END}	{ yylval.value = AIC_SELID;		return T_ROREG; }
SBLKCTL/{END}	{ yylval.value = AIC_SBLKCTL;		return T_RWREG; }


BCTL/{END}	{ yylval.value = AIC_BCTL;		return T_RWREG; }
BUSTIME/{END}	{ yylval.value = AIC_BUSTIME;		return T_RWREG; }
BUSSPD/{END}	{ yylval.value = AIC_BUSSPD;		return T_RWREG; }
HADDR0/{END}	{ yylval.value = AIC_HADDR0;		return T_RWREG; }
HADDR1/{END}	{ yylval.value = AIC_HADDR1;		return T_RWREG; }
HADDR2/{END}	{ yylval.value = AIC_HADDR2;		return T_RWREG; }
HADDR3/{END}	{ yylval.value = AIC_HADDR3;		return T_RWREG; }
HCNT0/{END}	{ yylval.value = AIC_HCNT0;		return T_RWREG; }
HCNT1/{END}	{ yylval.value = AIC_HCNT1;		return T_RWREG; }
HCNT2/{END}	{ yylval.value = AIC_HCNT2;		return T_RWREG; }
SCBPTR/{END}	{ yylval.value = AIC_SCBPTR;		return T_RWREG; }
INTSTAT/{END}	{ yylval.value = AIC_INTSTAT;		return T_RWREG; }
DFCNTRL/{END}	{ yylval.value = AIC_DFCNTRL;		return T_RWREG; }
DFSTATUS/{END}	{ yylval.value = AIC_DFSTATUS;		return T_ROREG; }
DFWADDR/{END}	{ yylval.value = AIC_DFWADDR;		return T_RWREG; }
DFRADDR/{END}	{ yylval.value = AIC_DFRADDR;		return T_RWREG; }
DFDAT/{END}	{ yylval.value = AIC_DFDAT;		return T_RWREG; }
SCBCNT/{END}	{ yylval.value = AIC_SCBCNT;		return T_RWREG; }
SLEEPCTL/{END}	{ yylval.value = AIC_SLEEPCTL;		return T_RWREG; }
QINFIFO/{END}	{ yylval.value = AIC_QINFIFO;		return T_ROREG; }
QINCNT/{END}	{ yylval.value = AIC_QINCNT;		return T_ROREG; }
QOUTFIFO/{END}	{ yylval.value = AIC_QOUTFIFO;		return T_WOREG; }
QOUTINCNT/{END}	{ yylval.value = AIC_QOUTCNT;		return T_WOREG; }



or2si/{END}	{ return T_ORSI; }
ldsi/{END}	{ return T_LDSI; }
ld/{END}	{ return T_LD; }
set/{END}	{ return T_SET; }
clr/{END}	{ return T_CLR; }
jmp/{END}	{ yylval.value = AIC_S_JMP;	return T_JMPorCALL; }
call/{END}	{ yylval.value = AIC_S_CALL;	return T_JMPorCALL; }
jc/{END}	{ yylval.value = AIC_S_JC;	return T_JMPorCALL; }
jnc/{END}	{ yylval.value = AIC_S_JNC;	return T_JMPorCALL; }
tst/{END}	{ yylval.value = AIC_S_TST;	return T_TST; }
cmp/{END}	{ yylval.value = AIC_S_CMP;	return T_CMP; }
add/{END}	{ yylval.value = AIC_S_ADD;	return T_ADD; }
and/{END}	{ yylval.value = AIC_S_AND;	return T_AND; }
xor/{END}	{ yylval.value = AIC_S_XOR;	return T_XOR; }
or/{END}	{ yylval.value = AIC_S_OR;	return T_OR; }
addc/{END}	{ yylval.value = AIC_S_ADD;	return T_ADDC; }

ret/{END}	{ return T_RETURN; }

SECTION/{END}	{ return T_SECTION; }
SRAM/{END}	{ yylval.value = AIC_S_SRAM;	return T_SRAM; }
SCB/{END}	{ yylval.value = AIC_S_SCB;	return T_SCB; }
CODE/{END}	{ yylval.value = AIC_S_CODE;	return T_CODE;}

{DOT}		{ yylval.value = location_counter; return T_DOT; }

0[0-7]*	{
	yylval.value = strtol(yytext, NULL, 8);
	return T_NUMBER;
}

0[xX][0-9a-fA-F]+ {
	yylval.value = strtoul(yytext + 2, NULL, 16);
	return T_NUMBER;
}

[1-9][0-9]* {
	yylval.value = strtol(yytext, NULL, 10);
	return T_NUMBER;
}

{WORD} {
	yylval.symbol = getsym(yytext);
	if (yylval.symbol->s_section == AIC_S_CODE)
		return T_SYMBOL;
	if (yylval.symbol->s_section == AIC_S_SRAM) {
		yylval.value = yylval.symbol->s_value + AIC_SRAM;
		return T_SRAM;
	}
	yylval.value = yylval.symbol->s_value + AIC_SCB;
	return T_SCB;
}

{PATH} {
	yylval.str = strdup (yytext);
	return T_PATH;
}

{WORD}/: {
	yylval.symbol = getsym(yytext);
	(void)input();	/* eat colon */
	return T_TAG;
}

{AMPERSAND} {
	return T_AMPERSAND;
}

{SEMICOLON} {
	return T_EOS;
}

{COMMA} {
	return T_COMMA;
}

{NL} {
	yyline++;
}

#.* {
	if (strncmp(yytext, "#define", 7) == 0) {
		REJECT;
	}
	if (strncmp(yytext, "#include", 8) == 0) {
		REJECT;
	}
}

"#include"/{END}	{
	return T_INCLUDE;
}

{SPC} {
}



"#define"/{END} {
	return T_DEFINE;
}



. {
	return yytext[0];
}

<<EOF>> {
	if (endinclude())
		return T_EOF;
}

%%

/*
 * Open the file).
 */
int
openfile(fname)
	const char *fname;
{

	if ((yyin = fopen(fname, "r")) == NULL)
		return (-1);
	yyline = 1;
	yyfile = strdup (fname);
	return (0);
}

typedef struct incl {
	struct incl	*in_prev;
	YY_BUFFER_STATE	 in_buf;
	int		 in_line;
	char		*in_fname;
} incl_t;

static incl_t *incl;

int
includefile(fname)
	const char *fname;
{
	FILE *fp;
	incl_t	*in;

	if ((fp = fopen(fname, "r")) == NULL)
		err(1, "%s", fname);
	
	in = malloc (sizeof *in);
	in->in_prev = incl;
	in->in_buf = YY_CURRENT_BUFFER;
	in->in_line = yyline;
	in->in_fname = yyfile;
	incl = in;
	yy_switch_to_buffer(yy_create_buffer(fp, YY_BUF_SIZE));
	yyfile = strdup(fname);
	return 0;
}

int
endinclude()
{
	struct incl *in;

	if ((in = incl) == NULL)
		return 1;
	incl = in->in_prev;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	(void)fclose(yyin);
	yy_switch_to_buffer(in->in_buf);
	yyfile = in->in_fname;
	yyline = in->in_line;
	free(in);
	return 0;
}

int
rewindfile()
{
	fseek(yyin, 0, SEEK_SET);
	yyline = 1;
}
