#!/usr/bin/perl

#
# Copyright (c) 1994 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI	adm.pl,v 2.3 1995/12/26 23:26:05 polk Exp

# Where we live...
$CONFIGPATH="/etc/adm";
$ADMBIN="/usr/sbin";

# Strip the path for our name
$0 =~ s#^.*/##;

$ETC="/etc";
$SKEL="/usr/share/skel";
$PWD_MKDB="/usr/sbin/pwd_mkdb";
$DEF_DIRMODE=0755;

$GROUP="$ETC/group";
$PASSWD="$ETC/master.passwd";
$ALIASES="$ETC/aliases";
$RESOLV="$ETC/resolv.conf";

$WWWHOME="/var/www/docs/";
$WWWPAGE="index.html";
$WWWPID="/var/run/httpd.pid";
$WWWSTART="/usr/contrib/bin/httpd";

# Nameserver config files
$NAMED_BOOT="named.boot";
$NAMED_DOMAIN="namedb/domain.db";
$NAMED_REVERSE="namedb/reverse.db";
$NAMED_LOCALREV="namedb/localhost.rev";
$ROOT_CACHE="namedb/root.cache";
$NAMED_PID="/var/run/named.pid";
$NAMED="/usr/sbin/named";

$SENDMAILCW="sendmail.cw";
$SENDMAIL_PID="/var/run/sendmail.pid";

$PASSWD_DEF="data/passwd.cf";		# Defaults file for adduser
$NETSTART_DEF="data/netstart.cf";	# Defaults file for config_netstart
$WWW_DEF="data/www.cf";			# Defaults file for config_www

$DNS_SOA="data/dns_soa.cf";		# Data file for DNS
$DNS_DATA="data/dns_data.cf";		# Host/Addr/MX data
$DNS_ALIAS="data/dns_aliases.cf";	# Cname data

$TZDIR="/usr/share/zoneinfo";		# Timezone data

$SHLIBC="/shlib/libc_s.2.1.0";		# Shared version of libc

$COLS=80;		# Assume 80 column screen
$GUTTER=2;		# Minimum 2 spaces between items in columnar lists

push(@INC, "/etc/adm/lib");

# Load handy routines
require 'util.pl';

1;
