#!/usr/bin/perl

#	BSDI	v.pl,v 2.5 1995/12/27 19:54:59 polk Exp

$|=1;	# unbuffer stdout

$SLEEPTIME=5;	# at least 5 seconds between clears

$SAVETEXT="";
$DEFHELP="Sorry, no help on this topic";
$HELP=$DEFHELP;

if ($ENV{'TERM'} =~ /^ibmpc/) {
	$TNOCURSOR="[15;14_";
	$TCURSOR="[_";
	$TULC="";
	$TURC="";
	$TLLC="";
	$TLRC="";
	$TLST="";
	$TRST="";
	$TDBL="";
	$TSNGL="";
	$TSIDE="";
	$TCOL=80;
	if ($ENV{'TERM'} =~ /mono/) {
		$TBLUE="[1G";
		$TBLACK="[1G";
		$TSO="[=15F";
		$TSE="[=15F";
	} else {
		$TBLUE="[1G";
		$TBLACK="[0G";
		$TSO="[=14F";
		$TSE="[=7F";
	}
	#
	# These 4 must exist to do visual mode
	#
	$THOME="[H";
	$TSAVEC="7";
	$TRESTOREC="8";
	$TCLEAR="c";
} else {
	$TBLUE="";
	$TBLACK="";
	$TNOCURSOR="";
	$TCURSOR="";
	$TULC="+";
	$TURC="+";
	$TLLC="+";
	$TLRC="+";
	$TLST="+";
	$TRST="+";
	$TDBL="-";
	$TSNGL="-";
	$TSIDE="|";
	chop($TCOL=`tput co`);
	$TSO=`tput so`;
	$TSE=`tput se`;
	#
	# These 4 must exist to do visual mode
	#
	$THOME=`tput ho`;
	$TSAVEC=`tput sc`;
	$TRESTOREC=`tput rc`;
	$TCLEAR=`tput cl`;
}
$TLIN=24;


if ($TLIN < 24 || $TCOL < 80 || $TRESTOREC eq "" || $TSAVEC eq "" || $THOME eq "" || $TCLEAR eq "") {
	$DUMBTERM=1;
	$TSO="";
	$TSE="";
	$THOME="";
	$TSAVEC="";
	$TRESTOREC="";
	$TCLEAR="";
	$TULC="";
	$TURC="";
	$TLLC="";
	$TLRC="";
	$TLST="";
	$TRST="";
	$TDBL="";
	$TSNGL="";
	$TSIDE="";
}

$SO="$TBLACK$TSO";
$SE="$TBLUE$TSE";
$SLEEPOUT = 0;

sub v_sleep {
	if (time() < $SLEEPOUT) {
		sleep($SLEEPOUT - time());
	}
	$SLEEPOUT = time() + $SLEEPTIME;
}

sub v_clear { &v_sleep(); print "$TNOCURSOR$SE$TCLEAR"; }
sub v_home { $SLEEPOUT = time() + $SLEEPTIME; print "$THOME"; }
sub v_reset { &v_sleep(); print "$TCURSOR$SE$TBLACK$TCLEAR"; }

$V_TOP="";
$V_MID="";
$V_BOT="";
sub v_top {
	if ($V_TOP eq "") {
		$V_TOP=$TULC;
		for ($i = 0; $i < 77; ++$i) {
			$V_TOP.=$TDBL;
		}
		$V_TOP.=$TURC;
		$V_TOP.="\n";
	}
	printf $V_TOP;
}
sub v_middle {
	if ($V_MID eq "") {
		$V_MID=$TLST;
		for ($i = 0; $i < 77; ++$i) {
			$V_MID.=$TSNGL;
		}
		$V_MID.=$TRST;
		$V_MID.="\n";
	}
	printf $V_MID;
}
sub v_bottom {
	if ($V_BOT eq "") {
		$V_BOT=$TLLC;
		for ($i = 0; $i < 77; ++$i) {
			$V_BOT.=$TDBL;
		}
		$V_BOT.=$TLRC;
	}
	printf $V_BOT;
}

sub vquery {
        local ($query, $default, @choices, $prompt, $tmp, $_) = @_;

        if ($default) {
                $prompt = "$query [$default] ";
        }
        else {
                $prompt = "$query ";
        }
	$fullquery=1;

        for (;;) {
		if ($fullquery) {
			$fullquery=0;
			if ($DUMBTERM) {
				if ($INVALID ne "") {
					print "$INVALID\n";
					$INVALID="";
				} else {
					print "$COMMENTS\n";
					print "$TEXT\n\n";
				}
			} else {
				&v_clear();
				&v_top();
				&v_home();
				printf("$TULC$TDBL %s \n", $TITLE);
				&v_middle();
				$NL=2;
				@lines = split(/\n/, $COMMENTS);
				foreach $i (@lines) {
					++$NL;
					printf("$TSIDE %-75s $TSIDE\n", $i);
				}
				if ( $COMMENTS =~ /..*/) {
					++$NL;
					&v_middle();
				}
				@lines = split(/\n/, $TEXT);
				foreach $i (@lines) {
					++$NL;
					printf("$TSIDE %-75s $TSIDE\n", $i);
				}
				++$NL;
				printf("$TSIDE %-75s $TSIDE\n", "");
				print "$TSAVEC";
				++$NL;
				printf("$TSIDE %-75s $TSIDE\n", "");
				++$NL;
				printf("$TSIDE %-75s $TSIDE\n", $INVALID);
				$INVALID="";
				++$NL;
				printf("$TSIDE %-75s $TSIDE\n", "");
				++$NL;
				printf("$TSIDE %-75s $TSIDE\n", "");

				while ($NL < $TLIN-1) {
					++$NL;
					printf("$TSIDE %-75s $TSIDE\n", "");
				}

				&v_bottom();
			}
		}
		$SLEEPOUT=0;
		if ($DUMBTERM) {
			print $prompt;
			$_ = <STDIN> || die "got EOF -- exiting.\n";
		} else {
			print "$TRESTOREC";
			printf("$TSIDE %75s\r", "");
			printf("$TSIDE %s%s", $prompt, $TCURSOR);
			$_ = <STDIN> || die "got EOF -- exiting.\n";
			print "$TNOCURSOR";
		}
                chop;
		if ($SAVETEXT ne "") {
			return "";
		}
                if ($default && /^$/) {
			$HELP=$DEFHELP;
                        return $default;
                }
		if (/^!shell/) {
			&v_reset();
			print "Spawning shell...\n";
			system("/bin/sh");
			$fullquery = 1;
			next
		}
		if (/^help/) {
			$SAVETEXT=$TEXT;
			$TEXT=$HELP;
			&vquery("Press <ENTER> to continue:");
			$TEXT=$SAVETEXT;
			$SAVETEXT="";
			$fullquery = 1;
			next
		}
                last if $#choices < 0;
                for $tmp (@choices) {
			if (/^$tmp$/i) {
				$HELP=$DEFHELP;
				return $tmp;
			}
			if ($tmp eq "yes" && /^y/i) {
				$HELP=$DEFHELP;
				return $tmp;
			}
			if ($tmp eq "no" && /^n/i) {
				$HELP=$DEFHELP;
				return $tmp;
			}
                }
		print "\n$TSIDE Invalid response: $_";
		print "\n$TSIDE Valid responses are: ";
                for $tmp (@choices) {
                        print "$tmp ";
                }
		if ($DUMBTERM) {
			print "\n\n";
		}
        }
	$HELP=$DEFHELP;
        return $_;
}

sub vaddtext {
        local ($newt) = @_;
	$TEXT=$TEXT."\n$newt";

	if ($DUMBTERM) {
		print "$newt\n";
	} else {
		&vdisplay("refresh");
	}
}

sub vdisplay {
        local ($modes) = @_;
	if ($DUMBTERM) {
		print "$COMMENTS\n";
		print "$TEXT\n";
		return 1;
	}
	if ($modes =~ /refresh/) {
		&v_home();
	} else {
		&v_clear();
	}
	&v_top();
	&v_home();
	printf("$TULC$TDBL %s \n", $TITLE);
	&v_middle();
	$NL=2;
	@lines = split(/\n/, $COMMENTS);
	foreach $i (@lines) {
		++$NL;
		printf("$TSIDE %-75s $TSIDE\n", $i);
	}
	if ( $COMMENTS =~ /..*/) {
		++$NL;
		&v_middle();
	}
	@lines = split(/\n/, $TEXT);
	foreach $i (@lines) {
		++$NL;
		printf("$TSIDE %-75s $TSIDE\n", $i);
	}
	if ($modes =~ /savecursor/) {
		++$NL;
		printf("$TSIDE %-75s $TSIDE\n", "");
		++$NL;
		printf("$TSIDE $TSAVEC%-75s $TSIDE\n", "");
	}
	while ($NL < $TLIN-1) {
		++$NL;
		printf("$TSIDE %-75s $TSIDE\n", "");
	}
	&v_bottom();
	if ($modes =~ /savecursor/) {
                print "$TRESTOREC";
	}
}

sub v_addlist {
	local (@list) = @_;

	$col = 6;
	foreach $file (@list) {
		if (int(76 / (length($file)+1)) < $col) {
			$col = int(76 /(length($file)+1));
		}
	}
	$fw = int(76 / $col) - 1;

	$m = int(($#list+$col-1)/$col);
	for ($i = 0; $i < $m; ++$i) {
		for ($j = 0; $j < $col - 1; ++$j) {
			$TEXT.=sprintf("%-${fw}s ", @list[$i+$j*$m]);
		}
		$TEXT.="@list[$i+$j*$m]\n";
	}
}

$EXPLAIN_INSTALL_HACK="";
sub vexplain {
	local ($title) = @_;

	if ($ENV{'V_EXPLAINED'} ne "yes") {
		$ENV{'V_EXPLAINED'} = "yes";
		$TEXT="$EXPLAIN_INSTALL_HACK".
"$title will provide you with a series of questions.
When a `default answer' is available, it will follow the question
in square brackets.  For example, the question:

        Use Express or Custom Installation? [express]:

has the default answer `express'.  Accept the default (without any
extra typing!) by pressing the <Enter> key -- or type your answer
and then press <Enter>.

Use the <Backspace> key to erase and aid correction of any mistyped
answers -- before you press <Enter>.  Generally, once you press
<Enter> you move onto the next question.";
		$HELP="You need to press the key marked <ENTER>";
		&vquery("Press <ENTER> to continue:");

		$TEXT=
"In most places where a question is asked you can request more information
by typing \"help\" followed <ENTER> (do not type the \" marks).";
		$HELP="That's right, this would be a HELP screen";
		&vquery("Press <ENTER> to continue:");
	}
}

# Query for a hostname
sub vquery_name {
	local ($prompt, $default) = @_;
	$INVALID="";
	$COMMENTS="";
	for (;;) {
	        $_ = &vquery($prompt, $default);
		$INVALID="";
        	last if /^[-A-Za-z0-9_\.]+$/;
		last if /^\?$/ || /^$/;
		$INVALID="Invalid name";
		$COMMENTS=
"Host/domain names must consist of letters, digits, `-', `.', and `_' only.";
	}
	$COMMENTS="";
	return $_;
}

# Query for an address
sub vquery_addr {
	local ($prompt, $default, $min_fields, $max_fields, 
		$pattern, $fields) = @_;
	$min_fields = 4 if ! $min_fields;
	$max_fields = 4 if ! $max_fields;
	$pattern = "\\d{1,3}\\." x ($min_fields - 1);
	$pattern .= "\\d{1,3}";
	$INVALID="";
	$COMMENTS="";
	for (;;) {
		$HELP=
"IP addresses are expressed as a \"dotted quad\", that is, 4 numbers (each
between 0 and 255 inclusive) separated by periods (e.g, 192.0.0.23).  The
first three numbers are usually the network number (assigned to your site
by either the NIC (network information center) or your service provider).
The last number is the host address within your network and is usually
chosen locally.  The host addresses of 0 and 255 have special meanings and
should never be used for network interfaces.  The addresses between 1 and
254 (inclusive) are typically available for assignment.";
	        $_ = &vquery($prompt, $default);
		last if /^none$/;
		$INVALID="";
		$fields = split(/\./);
		last if /^$pattern$/ && $fields <= $max_fields;
		$INVALID="Invalid address";
		if ($min_fields == 4) {
			$COMMENTS=
"IP addresses consist of 4 numbers (each between 0 and 255 inclusive) 
separated by periods (e.g., 192.0.0.23).";
		} else {
			$COMMENTS=
"IP network addresses consist of up to 3 numbers (each between 0 and 255
inclusive) separated by periods. The numbers are the network portion of 
IP addresses on your local network.  For example, a class C network 
consists of three numbers e.g.: 192.0.0";
		}
	}
	$COMMENTS="";
	return $_;
}

# Query for an address
sub vquery_mask {
	local ($prompt, $default) = @_;

	$INVALID="";
	for (;;) {
		$HELP=
"A \"netmask\" needs to be specified for the network.

A netmask determines which part of an IP address represents the network
as opposed to the individual host.  Most sites use the final number of the
IP address as the host.  This implies the default netmask of 255.255.255.0
$INSTALL requires that the netmask be defined as a standard dotted
quad with the number expressed in decimal or a 16 digit hexadecimal number
(e.g., 0xffffff00).  If you are not certain what the netmask should be,
enter \"default\" to use the default netmask for this address.";

		$_ = &vquery($prompt, $default);
		last if /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
		last if /^0x[0-9a-fA-F]{8}$/;
		last if /^default$/;
		$INVALID = "Invalid entry: $_";
	}
	if ($_ eq "default") {
		return "";
	}
	return $_;
}

#
# Query the system for configuration parameters
#
$DMESGFILE="/dev/klog";
$DMESGSAVE="/var/tmp/dmesg.boot";

$desc{"TP"} = "10baseT - (TP) twisted pair 10mb.
          Uses a wide modular phone connector.";
$desc{"BNC"} = "10base2 - (BNC) COAXial cable 10mb (a.k.a. thin-net)
          Uses a twist on barrel connector.";
$desc{"AUI"} = "10base5 - (AUI) external transceiver 10mb (a.ka. think-net)
          Uses a DB15 connector to attach to an external transceiver.";
$desc{"100BASE-T4"} = "100mb ethernet VG-AnyLan (100BASE-T4)";
$desc{"100BASE-TX"} = "100mb ethernet (100BASE-TX)";
$desc{"100BASE-FX"} = "100mb ethernet (100BASE-FX)";
$desc{"MII"} = "100mb ethernet MII daughterboard (MII)";

$cl{"bus"} = "eisa isa pci pcmcia";
$desc{"eisa"} = "Extended ISA bus";
$desc{"isa"} = "ISA bus";
$desc{"pci"} = "PCI bus";
$desc{"pcmcia"} = "PCMCIA bus";

$cl{"cdrom"} = "mcd";
$desc{"mcd"} = "Mitsumi CD-ROM";

$cl{"disk"} = "sd sr wd";
$desc{"sd"} = "Fixed SCSI disk";
$desc{"sr"} = "Removable SCSI disk";
$desc{"wd"} = "IDE/ESDI/RLL/ST-506 disk";

$cl{"network"} = "ar de di ef el eo ep ex fea fpa hpp ne re te tn tr we";
$desc{"ar"} = "Arlan radio ethernet";
$desc{"de"} = "Digital DC21040/21140/21041";
	sub check_de {
		local ($unit) = @_;
		$linkdesc{"de"} = "";
		if ($devs{$unit} =~ /100M/) {
			$TEXT=
"This card supports both 100Mbit and 10Mbit ethernets.  In order
to properly configure the card, $INSTALL must be told
the speed of the network.";
			$METHOD = &vquery("Is this a 10 or 100 Mbit ethernet?",
				"10", ("10", "100"));
			if ($METHOD eq "10") {
				$linkoptions{"de"} = "link0";
			} elsif (defined $linkoptions{"de"}) {
				delete $linkoptions{"de"};
			}
		} else {
			$linkoptions{"de"} = ":link0";
		}
	}
$desc{"di"} = "Digital EtherWorks III";
$desc{"ef"} = "3com Etherlink III (3c509/3c579)";
	sub check_ef {
		local ($unit) = @_;
		$eftypes = "";
		$linkdesc{"ef"} = "";
		$linkoptions{"ef"} = "";
		if ($auxinfo{$unit} =~ / 100BASE-T4/) {
			if ($eftypes ne "") {
				$eftypes .= ":";
			}
			$eftypes .= "100BASE-T4";
			$lo = "link1 link2/-link1 -link2";
		}
		if ($auxinfo{$unit} =~ / 100BASE-TX/) {
			if ($eftypes ne "") {
				$eftypes .= ":";
			}
			$eftypes .= "100BASE-TX";
			$lo = "link2";
		}
		if ($auxinfo{$unit} =~ / 100BASE-FX/) {
			if ($eftypes ne "") {
				$eftypes .= ":";
			}
			$eftypes .= "100BASE-FX";
			$lo = "link0 link2/-link0 -link2";
		}
		if ($auxinfo{$unit} =~ / MII/) {
			if ($eftypes ne "") {
				$eftypes .= ":";
			}
			$eftypes .= "MII";
			$lo = "link1 link2/-link1 -link2";
		}
		if ($auxinfo{$unit} =~ / 10BASE-T/) {
			$linkoptions{"ef"} = "link1";
			$linkdesc{"ef"} = "TP";
		}
		if ($auxinfo{$unit} =~ / 10BASE2/) {
			if ($linkoptions{"ef"} ne "") {
				$linkoptions{"ef"} .= ":";
			    	$linkdesc{"ef"} .= ":";
			}
			$linkoptions{"ef"} .= "link0";
			$linkdesc{"ef"} .= "BNC";
		}
		if ($auxinfo{$unit} =~ / AUI/) {
			if ($linkoptions{"ef"} ne "") {
				$linkoptions{"ef"} .= ":";
			    	$linkdesc{"ef"} .= ":";
			}
			$linkdesc{"ef"} .= "AUI";
		}
		if ($eftypes ne "") {
			$tenmb = 0;
			if ($auxinfo{$unit} =~ / 10BASE-T/) {
				$tenmb = 1;
				$eftypes .= ":TP";
			}
			if ($auxinfo{$unit} =~ / AUI/) {
				$tenmb = 1;
				$eftypes .= ":AUI";
			}
			if ($auxinfo{$unit} =~ / 10BASE2/) {
				$tenmb = 1;
				$eftypes .= ":BNC";
			}
			if ($tenmb == 1) {
				$eftypes .= ":10Mb";
			}
			@eftypes = sort split(/:/,$eftypes);
			if ($#eftypes > 0) {
				$TEXT=
"This card supports more than one type of ethernet.  In order
to properly configure the card, $INSTALL must be told
the type of network.";
				if ($tenmb == 1) {
					$ef = "10Mb";
					$TEXT.="
For 10Mbit ethernets you may either choose the connector
type or select \"10Mb\" and have $INSTALL determine the
connection type automatically
";
				} else {
					$ef="";
				}
				$TEXT.="
The following types are available:
";
				foreach $i sort(@eftypes) {
					$TEXT.=" $i";
                        	}

				$ef = &vquery("What type of ethernet?",
						$ef, @eftypes);
				if ($ef eq "10Mb") {
					$linkoptions{"ef"} = "link1::link0";
					$linkdesc{"ef"} = "TP:AUI:BNC";
				} elsif ($ef eq "AUI") {
					$linkoptions{"ef"} = "";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq "BNC") {
					$linkoptions{"ef"} = "link0";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq "TP") {
					$linkoptions{"ef"} = "link1";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq ":100BASE-T4") {
					$linkoptions{"ef"} = "link1 link2/-link1 -link2";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq ":100BASE-TX") {
					$linkoptions{"ef"} = "link2";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq ":100BASE-FX") {
					$linkoptions{"ef"} = "link0 link2/-link0 -link2";
					$linkdesc{"ef"} = "";
				} elsif ($ef eq ":MII") {
					$linkoptions{"ef"} = "link1 link2/-link1 -link2";
					$linkdesc{"ef"} = "";
				}
			} else {
				$linkoptions{"ef"} = $lo;
				$linkdesc{"ef"} = "misc";
			}
		} elsif ($linkoptions{"ef"} eq "") {
			$linkoptions{"ef"} = $lo;
			$linkdesc{"ef"} = "misc";
		}
	}
$desc{"el"} = "3com Etherlink 16 (3c507)";
	$linkoptions{"el"} = "link0:";
	$linkdesc{"el"} = "BNC:AUI";
$desc{"eo"} = "3com 3c501";
$desc{"ep"} = "3com Etherlink Plus (3c505)";
$desc{"ex"} = "Intel EtherExpress 16";
	$linkoptions{"ex"} = ":link1:link0:link0 link1/-link0 -link1";
	$linkdesc{"ex"} = "AUTO:TP:BNC:AUI";
$desc{"fea"} = "Digital DEFEA DA/SA/UA fddi";
$desc{"fpa"} = "Digital DEFPA DA/SA/UA fddi";
$desc{"hpp"} = "HP EtherTwist";
	$linkoptions{"hpp"} = "link0:";
	$linkdesc{"hpp"} = "TP:AUI";
$desc{"ne"} = "Novell NE-1000/NE-2000";
$desc{"re"} = "Allied Telesis RE2000/AT-1700";
$desc{"te"} = "SMC TokenCard Elite";
# LINK1 == 16MB (4MB)
# LINK2 == UTP (STP)
	$linkoptions{"te"} = "link0";
	$linkdesc{"te"} = "";
$desc{"tn"} = "TNIC-1500";
$desc{"tr"} = "IBM TRA 16/4 ISA & 3COM 3c619B token ring";
	$linkoptions{"tr"} = "link0";
	$linkdesc{"tr"} = "";
$desc{"we"} = "WD/SMC Elite/Ultra & 3com 3c503";
	$linkoptions{"we"} = "link0:";
	$linkdesc{"we"} = "BNC:AUI";

$cl{"p2p"} = "ntwo rh rn";
$desc{"ntwo"} = "SDL Communications RISCom/N2 dual sync serial port driver";
$desc{"rh"} = "SDL Communications RISCom/H2 HDLC serial card";
$desc{"rn"} = "SDL Communications RISCom/N1 HDLC serial card";

$cl{"pc"} = "bms fd lms lp npx pcaux pccons saturn vga wdc wdpi";
$desc{"bms"} = "Microsoft and ATI Ultra Bus Mouse driver";
$desc{"fd"} = "Floppy disk controller";
$desc{"lms"} = "Logitec and AIT Ultra Pro Bus Mouse driver";
$desc{"lp"} = "parallel printer port";
$desc{"npx"} = "Numeric coprocessor";
$desc{"pcaux"} = "PS/2 mouse port";
$desc{"pccons"} = "PC text mode console and keyboard";
$desc{"saturn"} = "Saturn PCI chipset workaround";
$desc{"vga"} = "VGA display adapter";
$desc{"wdc"} = "IDE/ESDI/RLL/ST-506/ATAPI controller";
$desc{"wdpi"} = "ATAPI HBA (IDE-CDROM)";

$cl{"pocket"} = "pe xir";
$desc{"pe"} = "Xircom PE-2";
$desc{"xir"} = "Xircom PE-3";

$cl{"scsi"} = "aha aic bha eaha eha ncr sa";
$desc{"aha"} = "Adaptec 1540/1542 SCSI controllers";
$desc{"aic"} = "Adaptec AIC-7770/7780 SCSI controllers";
$desc{"bha"} = "All BusLogic SCSI controllers";
$desc{"eaha"} = "Adaptec 1740/1742 SCSI controllers";
$desc{"eha"} = "???";
$desc{"ncr"} = "NCR 810/815/820/835 SCSI controllers";
$desc{"sa"} = "Adaptec 1520/1522 (AIC-6260) SCSI controllers";

$cl{"ser"} = "aimc com cy digi eqnx ms rc rp si";
$desc{"aimc"} = "Chase Research IOPRO control driver";
$desc{"com"} = "Standard PC serial port";
$desc{"cy"} = "Cyclades multiport serial card";
$desc{"digi"} = "DigiBoard terminal multiplexor";
$desc{"eqnx"} = "Equinox SST multiport serial card";
$desc{"ms"} = "Maxpeed intelligent serial controller";
$desc{"rc"} = "SDL RISCom async mux";
$desc{"rp"} = "Comtrol Rocketport serial card";
$desc{"si"} = "Specialix terminal multiplexor";

$cl{"sound"} = "gus gusxvi mpu mss opl pas sb sbmidi sbxvi uart";
$desc{"gus"} = "Gravis UltraSound";
$desc{"gusxvi"} = "Gravis UltraSound 16";
$desc{"mpu"} = "Generic MPU-401 midi interface";
$desc{"mss"} = "MS Sound System";
$desc{"opl"} = "Yamaha OPL-2/OPL-3 FM synth";
$desc{"pas"} = "Pro Audio Spectrum 16";
$desc{"sb"} = "Sound Blaster";
$desc{"sbmidi"} = "Sound Blaster 16 MIDI port";
$desc{"sbxvi"} = "Sound Blaster 16";
$desc{"uart"} = "6850 uart midi interface";

$cl{"tape"} = "st wt";
$desc{"st"} = "SCSI tape";
$desc{"wt"} = "QIC-02 tape";

sub querysystem {
	$idata{"MEMSIZE"} = 0;

	if (open(IN, $DMESGSAVE) == 0 && open(IN, "/var/db/dmesg.boot") == 0) {
		if (open(IN, $DMESGFILE) == 0) {
			die "can't open $DMESGFILE -- installation aborted.\n";
		}
		fcntl(IN, 4, 4) || die "can't set $DMESGFILE to non-blocking.\n";
	} else {
		$DMESGFILE=$DMESGSAVE;
	}
	$len = sysread(IN, $dmesg, 4096);
	close(IN);
	if ($DMESGSAVE ne $DMESGFILE) {
		if (open(OUT, ">$DMESGSAVE")) {
			print OUT $dmesg;
			close(OUT);
		} else {
			die "can't open $DMESGSAVE\n";
		}
	}

	@lines = split(/\n/, $dmesg);

	foreach $i (@lines) {
        	if ($i =~ /^buffer cache/) {
                	$col = 1;
                	next;
        	}
        	if ($i =~ /^real mem/) {
			$i =~ /\s([0-9]*)$/;
			$idata{"MEMSIZE"} = $1;
                	next;
        	}
        	next if (!$col);
        	if ($i =~ /^([a-z]+[0-9])\s/) {
                	$devs{$1} = $i;
			$lastdev = $1;
			$auxinfo{$lastdev} = "";
        	} elsif ($i =~ /^$lastdev:/) {
			if ($auxinfo{$lastdev} ne "") {
				$auxinfo{$lastdev} .= "\n";
			}
			$auxinfo{$lastdev} .= $i;
		}
	}
	foreach $d (keys(%devs)) {
		$d =~ /(.*)[0-9]/;
		$base = $1;
		foreach $c (keys(%cl)) {
		    foreach $dev (split(/\s/, $cl{$c})) {
			if ($base eq $dev) {
			    if ($devs{$d} =~ /\sCD-ROM:/) {
				    $found{"cdrom"} .= "$d ";
			    } else {
				    $found{$c} .= "$d ";
			    }
			    if (($base eq "sd" || $base eq "wd" || $base eq "sr") &&
			       $devs{$d} =~ /([0-9][0-9]*)\*([0-9][0-9]*)/){
				    $capacity{$d} = int($1*$2/(1024*1024));
			    } elsif ($base eq "sd" || $base eq "wd" || $base eq "sr") {
				    $capacity{$d} = 0;
			    }
			    if ($base eq "pccons" && $devs{$d} =~ /mono/) {
				    $ENV{'TERM'}="ibmpc-mono";
			    }
			    if ($base eq "com" && $devs{$d} =~ /console/) {
				    $ENV{'TERM'}="ansi";
				    $CONSOLE=$d;
			    }
			}
		    }
		}
	}

	@cdroms = sort split(/\s/,$found{"cdrom"});
	@disks = sort split(/\s/,$found{"disk"});
	@network = sort split(/\s/,$found{"network"});
	@pocket = sort split(/\s/,$found{"pocket"});
}
1;
