#!/usr/bin/perl

#
# Copyright (c) 1994,1995 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI	config_dns.pl,v 2.4 1995/11/02 23:29:46 polk Exp

require '/etc/adm/lib/adm.pl';
require '/etc/adm/lib/v.pl';

# Make sure we're running as root
if ($> != 0) {
	print "$0: this program must be run as root!\n";
#-	exit 1;
}

$| = 1;	 # Make STDOUT unbuffered...

require 'getopts.pl';
&Getopts('fkvn') || die "Usage: $0 [-vfk]\n";

# read the current settings for dns
&readsimple($DNS_SOA, 0);
%dns = %fields;
$tmp = "NS";
while (defined($dns{$tmp})) {
	$ns{$dns{$tmp}} = $tmp;
	$tmp .= "+";
}

&readfile($DNS_DATA);
@dnsdata = @file;
for ($i=0; $i<=$#dnsdata; $i++) {
	&parserec($dnsdata[$i]);
	$hosts{$fields{"HOST"}} = $i;
	$addrs{$fields{"ADDR"}} = $i;
}

%fields=();
&readsimple($DNS_ALIAS);
for $_ (values(%fields)) {
	($cname, $host) = split;
	$cnames{$cname} = $host;
	$tmp = $host;
	while (defined($revalias{$tmp})) { $tmp .= "+"; }
	$revalias{$tmp} = $cname;
}

# read netstart for host name
&readsimple($NETSTART_DEF, 0);
%netstart = %fields;

$TITLE="BSD/OS DNS Configuration";
$COMMENTS="";
&vexplain("BSD/OS DNS Configuration");

# Make sure they really want to run us...
if (! -f "/etc/named.boot") {
	$TEXT=
"This program is used to configure the local machine as the primary 
name server for the local domain.";
	$_ = &vquery("Configure this host as primary name server?", "yes",
	    ("yes", "no"));
	/^[yY]/ || exit 0;
}

if ($netstart{"HOST"} eq "") {
	$TEXT=
"Please enter this machine's fully qualified host name (including
the domain name part).  For example: `myhost.mydomain.com'.";
	$netstart{"HOST"} = &vquery_name("This machine's host name?");

	$TEXT=
"Please enter the IP address for $netstart{\"HOST\"} (e.g., 192.0.0.29).";
	$netstart{"ADDR"} = &vquery_addr("$netstart{\"HOST\"}'s IP address?");

	&writesimple($NETSTART_DEF, %netstart);
}

# Domain name
if (defined($dns{"DOMAIN"})) {
	$domain = $dns{"DOMAIN"};
}
else {
	$domain = $netstart{"HOST"};
	$domain =~ s/^[^\.]+\.//;
}

# -f means regenerate the files, etc. only
if ($opt_f) {
	&writefiles;
	exit 0;
}

$TEXT="Enter your domain name.  Valid characters for domain names 
are alphabetics, digits, `-', `_', and `.'.";
$domain = &vquery_name("Domain name for this site?", $domain);
$dns{"DOMAIN"} = $domain;

# Set up this host if it's not already done...
$_ = $netstart{"HOST"};
s/$domain//i;	# Strip off domain name
s/\.$//i;	# Strip trailing dot
tr/A-Z/a-z/;	# lower case
$host = $_;
if (!defined($hosts{$host})) {
	$index = $#dnsdata+1;
	%fields = ();
	$fields{"HOST"} = $host;
	$hosts{$host} = $index;
	$fields{"ADDR"} = $netstart{"ADDR"};
	$addrs{$netstart{"ADDR"}} = $index;
	$dnsdata[$index] = &sprintrec(%fields);

	$tmp = $host;
	$_ = &vquery("Should ftp.$domain be an alias for this host?", "yes", ("yes", "no"));
	/^[yY]/ && do { $cnames{"ftp"} = $host; 
			$revalias{"$tmp"} = "ftp"; 
			$tmp .= "+";
	};
	$_ = &vquery("Should www.$domain be an alias for this host?", "yes", ("yes", "no"));
	/^[yY]/ && do { $cnames{"www"} = $host; 
			$revalias{"$tmp"} = "www"; 
			$tmp .= "+";
	};
	$_ = &vquery("Should news.$domain be an alias for this host?", "yes", ("yes", "no"));
	/^[yY]/ && do { $cnames{"news"} = $host; 
			$revalias{"$tmp"} = "news"; 
	};
}

# Network address
if (defined($dns{"NET"})) {
	$net = $dns{"NET"};
}
else {
	$net = $netstart{"ADDR"};
	$netclass = $net;
	$netclass =~ s/\.[^\.]+.[^\.]+.[^\.]+$//;
	if ( $netclass > 191 ) {
		$net =~ s/\.[^\.]+$//;
	}
	elsif ( $netclass > 127 && $netclass < 192 ) {
		$net =~ s/.[^\.]+.[^\.]+$//;
	}
	else {
		$net = $netclass;
	}
}

$TEXT=
"Enter your network address.  This should be the network portion 
of IP addresses on your local network.  For example, if you have
a class C network, the first three sets of digits will be the 
network address (e.g., 192.0.0) without the fourth set of 
digits (which is the host number within the network).";
$net = &vquery_addr("Network address?", $net, 1, 3);
$dns{"NET"} = $net;

# Secondary name servers
$TEXT=
"Your domain must have at least two name servers (preferably on
different networks) and must be registered with the network
information center (NIC).  This machine will act as the primary
name server.

Your service provider will often provide secondary name service
for your domain and will often submit the appropriate registration
information to the NIC.

Once you have the name service set up, YOU MUST REGISTER THE 
OFFICIAL SERVERS WITH THE NIC.  You WILL NOT be able to receive
E-mail or access many of the larger internet anonymous ftp servers
until you have officially registered and the changes have taken effect.";
&vquery("Press <Enter> to continue");

for (;;) {
$TEXT=
"Enter the fully qualified host names (with the domain name part)
of secondary name server(s) for this site.  This machine will
automatically be entered into the list since it is the primary
server.  Secondary service is usually provided by your service
provider or some other agency on a different physical network (so
that there is some redundancy in case of network failures).

Just type <Enter> when you are finished entering name servers.  If you
enter the name of a server that is already defined, you will be given
the option to delete it.  Enter `?' for a current list of servers.";

	$_ = &vquery_name("Enter host name (? for list, <Enter> to continue)");
	last if /^$/;
	if ($_ eq "?") {
		@tmp = ();
		for $_ (keys %ns) {
			push (@tmp, $_) if defined($ns{$_});
		}
		@tmp = sort @tmp;

		$TEXT="Secondary servers for `$domain'\n";
		&v_addlist(@tmp);
		&vquery("Press <ENTER> to continue:");
		next;
	}
	s/$/.$domain/ if !/\./;		# tack on domain name if none present
	if (defined($ns{$_})) {
		$ns = $_;
		$TEXT="`$ns' is already defined as a secondary server.";
		$_ = &vquery("Delete secondary server `$ns'?", "no", ("yes", "no"));
		if (/^[yY]/) {
			$tmp = $ns{$ns};
			while (defined($dns{$tmp . "+"})) {
				$dns{$tmp} = $dns{$tmp . "+"};
				$tmp .= "+";
			}
			undef $dns{$tmp};
			undef $ns{$ns};
		}
	}
	else {
		$tmp = "NS";
		while (defined($dns{$tmp})) { $tmp .= "+"; };
		$dns{$tmp} = $_;
		$ns{$_} = $tmp;
	}
}

# Main mail machine
if (defined($dns{"MX"})) {
	$mx = $dns{"MX"};
}
else {
	$mx = $netstart{"HOST"};
	$mx =~ s/$domain//;
	$mx =~ s/\.$//;
}

$TEXT=
"Enter the name of the main machine on your network (probably this
machine) where most (or all) email should be delivered.";

$mx = &vquery_name("Main mail machine?", $mx);
$dns{"MX"} = $mx;

# Write out the SOA data
$dns{"SERIAL"}++;

&writesimple($DNS_SOA, %dns);

$_ = &vquery("Would you like to define or modify other host entries?", "no", ("yes", "no"));
if (/^[yY]/) {
	# Define or modify hosts
	for (;;) {
		&dohost() || last;
	}
}
&v_reset();
# Write out host data
@tmp = ();
$TEXT="";
&v_addtext("Writing host data...") if $opt_v;
for $_ (keys(%hosts)) {
	push (@tmp, $_) if defined($hosts{$_});
}
@tmp = sort @tmp;
open (DNS_DATA, ">$CONFIGPATH/$DNS_DATA") || 
		die "\n$0: can't open $DNS_DATA for writing: $!\n";
for $_ (@tmp) {
	print DNS_DATA $dnsdata[$hosts{$_}];
}
close DNS_DATA;
&v_addtext("DONE.\n") if $opt_v;

# Write out alias data
@tmp = ();
&v_addtext("Writing alias data...") if $opt_v;
for $_ (keys(%cnames)) {
	push (@tmp, $_) if defined($cnames{$_});
}
@tmp = sort @tmp;
open (DNS_ALIAS, ">$CONFIGPATH/$DNS_ALIAS") || 
		die "\n$0: can't open $DNS_ALIAS for writing: $!\n";
for $_ (@tmp) {
	print DNS_ALIAS "ALIAS:\t$_ $cnames{$_}\n";
}
close DNS_ALIAS;
&v_addtext("DONE.\n") if $opt_v;

# Write out the files if not -n
if (!$opt_n) {
	&writefiles;
}

&vclear();
exit 0;

# Get a host name and either add it, update it, or delete it 
# from the database
sub dohost {
	$TEXT=
"Enter a host name (without the domain name part).  All names are
assumed to be within the domain.  If the host exists, you can change
or delete the entry.  If the host doesn't exist in the current
database, you can add it.  Just type <Enter> when you are done
making changes.  Type `?' for a list of hosts.";

	$_ = &vquery_name("Enter a host name");
	return 0 if $_ eq "";

	s/$domain//i;	# Strip off domain name if they typed it in
	s/\.$//i;	# Strip trailing dot
	tr/A-Z/a-z/;	# lower case
	$host = $_;

	if ($_ eq "?") {
		&listhosts;
		return 1;
	}

	if (defined($hosts{$host})) {			# Already a host
		&parserec($dnsdata[$hosts{$host}]);
		$TEXT= "Host $host already exists and is defined as:\n";
		$TEXT.="HOST:\t$fields{\"HOST\"}\n";
		$TEXT.="ADDR:\t$fields{\"ADDR\"}\n";
		$tmp = "MX";
		while (defined($fields{$tmp})) {
			$TEXT.= "MX:\t$fields{$tmp}\n";
			$tmp .= "+";
		}
		$tmp = $host;
		while (defined($revalias{$tmp})) {
			$TEXT.= "ALIAS:\t$revalias{$tmp}\n";
			$tmp .= "+";
		}
		$_ = &vquery("Delete host `$host'?", "no", ("yes", "no"));
		if (/^[yY]/) {
			undef $hosts{$fields{"HOST"}};
			$tmp = $fields{"HOST"};
			while (defined($revalias{$tmp})) {
				undef $cnames{$revalias{$tmp}};
				undef $revalias{$tmp};
				$tmp .= "+";
			}
			return 1;
		}
	} elsif (defined($cnames{$host})) {		# Already an alias
		$TEXT= "$host already exists as an alias for $cnames{$host}\n\n";

		# Save current value of alias
		$alias = $host;
		$oldval = $cnames{$host};
	
		# Delete alias from the list of aliases
		$tmp = $cnames{$alias};
		while (defined($revalias{$tmp})) {
			last if $revalias{$tmp} eq $alias;
			$tmp .= "+";
		}
		while (defined($revalias{$tmp})) {
			$revalias{$tmp} = $revalias{$tmp . "+"};
			$tmp .= "+";
		}
		$tmp =~ s/\+$//;
		undef $revalias{$tmp};
		undef $cnames{$alias};

		$_ = &vquery("Delete this alias?", "no", ("yes", "no"));
		print "\n";
		if (/^[nN]/) {
			for (;;) {
				$_ = &vquery_name("New host value for `$alias'?", 
						$oldval);
				$INVALID="";
				last if defined($hosts{$_});
				$INVALID="Host $_ is not in the database.";
			}
			$cnames{$alias} = $_;
			$tmp = $_;
			while (defined($revalias{$tmp})) { $tmp .= "+"; };
			$revalias{$tmp} = $alias;
		}
		return 1;
	}
	else {						# New Entry
		$_ = &vquery("Add `$host' as host or alias?", "host", 
				("host", "alias"));
		if ($_ eq "alias") {
			for (;;) {
				$_ = &vquery("Host value for `$host?'");
				$INVALID="";
				last if defined($hosts{$_});
				$INVALID="Host $_ is not in the database.";
			}
			$cnames{$host} = $_;
			$tmp = $_;
			while (defined($revalias{$tmp})) { $tmp .= "+"; };
			$revalias{$tmp} = $alias;
			return 1;
		}	
	}

	# At this point, we've already taken care of aliases, 
	# so this is either a new host or one we're changing

	if (defined($hosts{$host})) {
		$index = $hosts{$host};
		&parserec($dnsdata[$index]);
	}
	else {
		$index = $#dnsdata+1;
		%fields = ();
	}

	$fields{"HOST"} = $host;
	$hosts{$host} = $index;

	for (;;) {
		$_ = &vquery_addr("IP address for `$host'?", $fields{"ADDR"});
		last if !defined($addrs{$_}) || $index eq $addrs{$_};
	}
	$fields{"ADDR"} = $_;
	$addrs{$_} = $index;
		
	$_ = &vquery("Does this machine accept SMTP (email) directly?", 
		defined($fields{"MX"}) ? "yes" : "no");
	if (/^[yY]/) {
		$fields{"MX"} = $host;
	}
	
	$dnsdata[$index] = &sprintrec(%fields);
}

# List currently defined host names and aliases
sub listhosts {
	local($_, @tmp);
	
	@tmp = ();
	for $_ (keys(%hosts)) {
		push (@tmp, $_) if defined($hosts{$_});
	}
	@tmp = sort @tmp;
	$TEXT="The following host names are defined:\n";
	&v_addlist(@tmp);
	
	@tmp = ();
	for $_ (keys(%cnames)) {
		push (@tmp, $_) if defined($cnames{$_});
	}
	@tmp = sort @tmp;
	$TEXT.="\nThe following aliases are defined:\n";
	&v_addlist(@tmp);
	&vquery("Press <ENTER> to continue");
}

sub copysub {
	local ($file, $out) = @_;
	
	if (!open(IN, "$file")) {
		print STDERR "$0: can't open $file: $!\n";
		return 0;
	}
	while (<IN>) {
		# @DOMAIN@	- absolute domain name (with trailing dot)
		s/@DOMAIN@/$domain/g;

		# @SERIAL@	- serial number
		s/@SERIAL@/$dns{"SERIAL"}/g;

		# @REVADDR@	- reverse of network number
		s/@REVADDR@/$revaddr/g;

		print $out $_;
	}
	close(IN);
	1;
}

sub copyold {
	local ($file, $out, $comment) = @_;
	if (open(IN, "$file")) {
		while (<IN>) {
			/^; DO NOT DELETE/ && last;
		}
		printf $out "%s DO NOT DELETE THIS LINE -- place local changes below here\n", $comment;
		while (<IN>) {
			print $out $_;
		}
		close(IN);
	}
	else {
		printf $out "%s DO NOT DELETE THIS LINE -- place local changes below here\n", $comment;
	}
}

sub fqdn {
	local ($name, $dolastdot) = @_;
	$name .= ".$dns{\"DOMAIN\"}" if $name !~ /\./;
	$name .= "." if ($name !~ /\.$/ && $dolastdot);
	return $name;
}

# 
# Build the real DNS and sendmail files and notify the daemons
# 
sub writefiles {

	$SIG{'INT'} = 'IGNORE';
	$SIG{'HUP'} = 'IGNORE';
	$SIG{'TSTP'} = 'IGNORE';

	$revaddr = join('.', reverse split(/\./, $dns{"NET"}));

	# Write out named.boot
	$TEXT="";
	&v_addtext("Writing named.boot...") if $opt_v;
	open(OUT, ">$ETC/$NAMED_BOOT.tmp") || 
			die "\n$0: can't open $ETC/$NAMED_BOOT.tmp: $!\n";
	&copysub("$CONFIGPATH/proto/$NAMED_BOOT", OUT) || 
			die "\n$0: can't copy/substitute proto/$NAMED_BOOT\n";
	&copyold("$ETC/$NAMED_BOOT", OUT, ";");
	close(OUT);
	rename("$ETC/$NAMED_BOOT.tmp", "$ETC/$NAMED_BOOT") || 
			die "\n$0: can't rename $ETC/$NAMED_BOOT.tmp: $!\n";
	&v_addtext("DONE.\n") if $opt_v;
	
	# $domain gets the trailing dot for use in the data files
	$domain .= "." if $domain !~ /\.$/;
	
	# Write out namedb/domain.db
	&v_addtext("Writing forward resolution domain data...") if $opt_v;
	open(OUT, ">$ETC/$NAMED_DOMAIN.tmp") || 
			die "\n$0: can't open $ETC/$NAMED_DOMAIN.tmp: $!\n";
	&copysub("$CONFIGPATH/proto/$NAMED_DOMAIN", OUT) || 
			die "\n$0: can't copy/substitute proto/$NAMED_DOMAIN\n";
	
	# NS records
	printf OUT "\t\tIN\tNS\t%s\n", &fqdn($netstart{"HOST"}, 1);
	$tmp="NS";
	while (defined($dns{$tmp})) {
		printf OUT "\t\tIN\tNS\t%s\n", &fqdn($dns{$tmp}, 1);
		$tmp .= "+";
	}
	
	# Main MX record
	printf OUT "\t\tIN\tMX\t5 %s\n", &fqdn($dns{"MX"}, 1);
	
	# Localhost record
	print OUT ";\nlocalhost\tIN\tA\t127.0.0.1\n;\n";

	# Hosts
	print OUT ";\n";
	@tmp = ();
	for $_ (keys(%hosts)) {
		push(@tmp, $_) if defined($hosts{$_});
	}
	@tmp = sort @tmp;
	for $_ (@tmp) {
		&parserec($dnsdata[$hosts{$_}]);
		printf OUT "$fields{\"HOST\"}\t%sIN\tA\t$fields{\"ADDR\"}\n",
				length($fields{"HOST"}) > 7 ? "" : "\t";
		printf OUT "\t\tIN\tMX\t5  %s\n", &fqdn($fields{"MX"}, 1) 
			if defined($fields{"MX"}) && $fields{"MX"} ne $dns{"MX"};
		printf OUT "\t\tIN\tMX\t10 %s\n", &fqdn($dns{"MX"}, 1);
		print OUT ";\n";
	}
	
	# Aliases
	@tmp = ();
	for $_ (keys(%cnames)) {
		push(@tmp, $_) if defined($cnames{$_});
	}
	@tmp = sort @tmp;
	for $_ (@tmp) {
		printf OUT "$_%s\tIN\tCNAME\t%s\n", 
			length($_) > 7 ? "" : "\t", &fqdn($cnames{$_}, 1);
	}
	print OUT ";\n";
	
	&copyold("$ETC/$NAMED_DOMAIN", OUT, ";");
	close(OUT);
	rename("$ETC/$NAMED_DOMAIN.tmp", "$ETC/$NAMED_DOMAIN") || 
		die "\n$0: can't rename $ETC/$NAMED_DOMAIN.tmp: $!\n";
	&v_addtext("DONE.\n") if $opt_v;

	# Write out namedb/reverse.db
	&v_addtext("Writing reverse resolution domain data...") if $opt_v;
	open(OUT, ">$ETC/$NAMED_REVERSE.tmp") || 
		die "\n$0: can't open $ETC/$NAMED_REVERSE.tmp: $!\n";
	&copysub("$CONFIGPATH/proto/$NAMED_REVERSE", OUT) || 
		die "\n$0: can't copy/substitute proto/$NAMED_REVERSE\n";

	# NS records
	printf OUT "\t\tIN\tNS\t%s\n", &fqdn($netstart{"HOST"}, 1);
	$tmp="NS";
	while (defined($dns{$tmp})) {
		printf OUT "\t\tIN\tNS\t%s\n", &fqdn($dns{$tmp}, 1);
		$tmp .= "+";
	}
	
	# PTR records
	print OUT ";\n";
	@tmp = ();
	for $_ (keys(%addrs)) {
		/^$net/ || next;
		push(@tmp, $_) if defined($addrs{$_});
	}
	@tmp = sort @tmp;
	for $_ (@tmp) {
		$hostpart = $_;
		$hostpart =~ s/$net//;
		$hostpart =~ s/^\.//;
		&parserec($dnsdata[$addrs{$_}]);
		printf OUT "$hostpart\t\tIN\tPTR\t%s\n", 
				&fqdn($fields{"HOST"}, 1);
	}
	print OUT ";\n";
	
	&copyold("$ETC/$NAMED_REVERSE", OUT, ";");
	close(OUT);
	rename("$ETC/$NAMED_REVERSE.tmp", "$ETC/$NAMED_REVERSE") || 
		die "$0: can't rename $ETC/$NAMED_REVERSE.tmp: $!\n";
	&v_addtext("DONE.\n") if $opt_v;
	
	# Write out namedb/localhost.rev
	&v_addtext("Writing localhost reverse resolution and cache files...") if $opt_v;
	open(OUT, ">$ETC/$NAMED_LOCALREV.tmp") || 
		die "\n$0: can't open $ETC/$NAMED_LOCALREV.tmp: $!\n";
	&copysub("$CONFIGPATH/proto/$NAMED_LOCALREV", OUT) || 
		die "\n$0: can't copy/substitute proto/$NAMED_LOCALREV\n";
	&copyold("$ETC/$NAMED_LOCALREV", OUT, ";");
	close(OUT);
	rename("$ETC/$NAMED_LOCALREV.tmp", "$ETC/$NAMED_LOCALREV") || 
		die "\n$0: can't rename $ETC/$NAMED_LOCALREV.tmp: $!\n";
	
	# Copy over root.cache
	open(IN, "$CONFIGPATH/proto/$ROOT_CACHE") || 
		die "\n$0: can't open $CONFIGPATH/proto/$ROOT_CACHE: $!\n";
	open(OUT, ">$ETC/$ROOT_CACHE") || 
		die "\n$0: can't open $ETC/$ROOT_CACHE: $!\n";
	while (<IN>) {
		print OUT;
	}
	close(IN);
	close(OUT);
	&v_addtext("DONE.\n") if $opt_v;
	
	# Write out sendmail.cw file
	$_ = $netstart{"HOST"};
	s/\.$dns{"DOMAIN"}//;
	if ($dns{"MX"} eq $_) {
		&v_addtext("Writing sendmail host alias file...") if $opt_v;
		@tmp = ();
		for ($i=0; $i<=$#dnsdata; $i++) {
			&parserec($dnsdata[$i]);
			push(@tmp, $fields{"HOST"}) if !defined($fields{"MX"});
		}
		@tmp = sort @tmp;
		open(OUT, ">$ETC/$SENDMAILCW.tmp") || 
			die "\n$0: can't open $ETC/$SENDMAILCW.tmp: $!\n";
		print OUT <<ETX;
# 
# The first part of this file is machine generated.  Add local 
# changes after the "DO NOT DELETE" line.
#
ETX
		print OUT "$dns{\"DOMAIN\"}\n";	# Alias the domain name
		for $_ (@tmp) {
			printf OUT "%s\n", $_;
			printf OUT "%s\n", &fqdn($_, 0);
		}
		&copyold("$ETC/$SENDMAILCW", OUT, "#");
		close(OUT);
		rename("$ETC/$SENDMAILCW.tmp", "$ETC/$SENDMAILCW") || 
			die "\n$0: can't rename $ETC/$SENDMAILCW.tmp: $!\n";
		&v_addtext("DONE.\n") if $opt_v;
	}
	
	return if $opt_k;	# don't restart daemons if -k

	# Restart named
	$signaled = 0;
	if (-f "$NAMED_PID") {
		$_ = `cat $NAMED_PID`;
		chop;
		if ($_ > 1) {
			&v_addtext("Notifying named of changes...") if $opt_v;
			$signaled = kill 1, $_;
			&v_addtext("DONE.\n") if $opt_v;
		}
		print "$0: Warning: named (pid: $_) wasn't running?\n" if ! $signaled;
	}
	if (! $signaled) {
		&v_addtext("Starting named...") if $opt_v;
		if (system($NAMED)) {
			print STDERR "\n$0: can't start named: $!\n";
		}
		else {
			&v_addtext("DONE.\n") if $opt_v;
		}
	}
	
	# Restart sendmail
	if (-f "$SENDMAIL_PID") {
		$_ = `cat $SENDMAIL_PID`;
		chop;
		($pid, $cmd) = split(/\n/);
		if ($pid > 1) {
			&v_addtext("Restarting sendmail...") if $opt_v;
			kill 15, $pid;
			sleep 2;
			$still_there = kill 15, $pid;
			if ($still_there) {
				print STDERR "\n$0: sendmail wouldn't die?!?\n";
			} 
			else {
				system($cmd);
				&v_addtext("DONE.\n") if $opt_v;
			}
		}
	}
	else {
		&v_addtext("$0: Warning: sendmail isn't running\n");
	}
	$SIG{'INT'} = 'DEFAULT';
	$SIG{'HUP'} = 'DEFAULT';
	$SIG{'TSTP'} = 'DEFAULT';
}
