/*-
//////////////////////////////////////////////////////////////////////////
//									//
//   Copyright (c) 1995 Migration Associates Corp. All Rights Reserved	//
//									//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF MIGRATION ASSOCIATES	//
//	The copyright notice above does not evidence any   		//
//	actual or intended publication of such source code.		//
//									//
//	Use, duplication, or disclosure by the Government is		//
//	subject to restrictions as set forth in FAR 52.227-19,		//
//	and (for NASA) as supplemented in NASA FAR 18.52.227-19,	//
//	in subparagraph (c) (1) (ii) of Rights in Technical Data	//
//	and Computer Software clause at DFARS 252.227-7013, any		//
//	successor regulations or comparable regulations of other	//
//	Government agencies as appropriate.				//
//									//
//		Migration Associates Corporation			//
//			19935 Hamal Drive				//
//			Monument, CO 80132				//
//									//
//	A license is granted to Berkeley Software Design, Inc. by	//
//	Migration Associates Corporation to redistribute this software	//
//	under the terms and conditions of the software License		//
//	Agreement provided with this distribution.  The Berkeley	//
//	Software Design Inc. software License Agreement specifies the	//
//	terms and conditions for redistribution.			//
//									//
//	UNDER U.S. LAW, THIS SOFTWARE MAY REQUIRE A LICENSE FROM	//
//	THE U.S. COMMERCE DEPARTMENT TO BE EXPORTED.  IT IS YOUR	//
//	REQUIREMENT TO OBTAIN THIS LICENSE PRIOR TO EXPORTATION.	//
//									//
//////////////////////////////////////////////////////////////////////////
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/resource.h>

#include "activ.h"
#include "activdb.h"


extern char *__progname;

static	int	force_unlock(char *);
static	int	process_record(char *, unsigned, unsigned);

static	int	enable = 0;
static	int	disable = 0;

extern	int
main(int argc, char **argv)
{
	int	c;
	int	errors = 0;
	unsigned or_mask = 0;
	unsigned and_mask = 0;
	static	int	unlock = 0;
	static	char	*optstr = "de";
	struct	rlimit cds;


	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)setpriority(PRIO_PROCESS, 0, 0);

	openlog("login", LOG_ODELAY, LOG_AUTH);

	/*
	 * Make sure we never dump core as we might have a
	 * valid user shared-secret in memory.
	 */

	cds.rlim_cur = 0;
	cds.rlim_max = 0;
	if (setrlimit(RLIMIT_CORE, &cds) < 0)
		syslog(LOG_ERR, "couldn't set core dump size to 0: %m");

	if (getuid() != 0) {	/* log it & quietly go away	*/
		syslog(LOG_INFO, "Attempt to use %s by unauthorized user %s",
				__progname, getlogin());
		exit(1);
	}

    	while ((c = getopt(argc, argv, optstr)) != EOF)
		switch(c) {
		case 'd':
			disable++;
			and_mask = ~ACTIV_ENABLED;
			or_mask  = 0;
			continue;
		case 'e':
			enable++;
			and_mask = ~0;
			or_mask  = ACTIV_ENABLED;
			continue;
		case 'u':
			unlock++;
			continue;
		default:
			fprintf(stderr,
				"Usage is: %s -%s username [ username ... ]\n",
					__progname, optstr);
			exit(1);
		}

	argc -= optind;
	argv = &argv[optind];

	if (disable && enable) {
		fprintf(stderr, "%s: conflict between disable and enable\n");
		exit(1);
	}

	if (unlock) {
		while (argc--)  ;
	}
	else while (argc--)
		errors += process_record(*argv++, and_mask, or_mask);

	exit(errors);
}

/*
 * Process a user record
 */

static	int
process_record(char *username, unsigned and_mask, unsigned or_mask)
{
	int	count = 0;
	ACTIVDB_Rec activrec;

retry:
	switch(activdb_lockrec(username, &activrec, ACTIV_LOCKED)) {
	case 0:
		activrec.flags &= and_mask;
		activrec.flags |= or_mask;
		activrec.flags &= ~ACTIV_LOCKED;
		if (! activdb_putrec(username, &activrec))
			return(0);
		else
			return(1);
	case 1:
		sleep(1);
		if (count++ < 60)
			goto retry;
		if (force_unlock(username))
			return(1);
		goto retry;

	case ENOENT:
		fprintf(stderr,
		   "%s: Attempt to %s nonexistent user \"%s\" in ActivCard system\n",
			__progname, enable ? "enable" : "disable", username);
		syslog(LOG_INFO,
		   "%s: Attempt to %s nonexistent user \"%s\" in ActivCard system",
			__progname, enable ? "enable" : "disable", username);
	default:
		return(1);
	}
}

/*
 * Force remove a user record-level lock.  
 */

static	int
force_unlock(char *username)
{
	ACTIVDB_Rec activrec;

	if (activdb_getrec(username, &activrec))
		return(-1);

	activrec.flags &= ~ACTIV_LOCKED;
	activrec.flags &= ~ACTIV_LOGIN;

	if (activdb_putrec(username, &activrec))
		return(1);

	return(0);
}
