#include "ac2.h"

int is_new_line(char *);
void line_in_use(char *);
void line_free(char *);
unsigned hash(char *, int);

void
do_tty_list(char *line, char *name, int a_time)
{
  tty_list current = &t_list;
  int counter;		/* should be TRUE if match is found */
  int t_time;			/* totel time logged in */
  int i = 0;
  unsigned hash_val;

  counter = FALSE;
  t_time = 0;

#ifndef FTP
  if (!strcmp(name, "ftp")) {
    return;
  }
#endif		/* if not FTP */

#ifndef LOGIN
  if (!strcmp(name, "LOGIN"))
    {
      return;
    }
#endif

  if (!strcmp(line, "~")) 
    {
      update_times(a_time);
      return;
    }

  hash_val = hash(line, 8);

/*
 * WORKING
 *	if (!is_new_line(line))
 *	  {		
 * search the tty_list for the last occurance of the tty *
 *	  }
 *	else
 *	  {
 * make a new node *
 *		line_in_use(line);
 *	  }
 */
  while (current->next != NULL)
    {
      i += 1;
/*	  if (current->line != NULL && strncmp(line, current->line, 8) == 0) */
      if (hash_val == current->hash_val && !strncmp(line, current->line, 8)) 
	{
	  counter = TRUE;
	  if (current->time_out == 0) 
	    {
	      current->time_out = a_time;
	    }
	  break;
	}		/* check 8 characters of the line, because of ftp */
      current = current->next;
    }			/* set the logout time, upto the second entry */
/*      if (!counter && strncmp(line, current->line, 8) == 0)*/
  if (!counter && hash_val == current->hash_val && !strncmp(line, current->line, 8))
    {
      if (current->time_out == 0)
	{
	  current->time_out = a_time;
	}
    }			/* because of fence-posts, do the first entry */

  if (name != NULL && strcmp(name, "\0") != 0) 
    {
      make_tty_node(&t_list, line, name, a_time, hash_val);
    }

}



void
  make_tty_node(tty_list head_list, char *line, char *name, int a_time, unsigned hash_val)
{
  tty_list temp;
  tty_list new;
  
  temp = head_list->next;
  
  new = (tty_list) malloc(sizeof(struct ttylist));
/*  if (new->line != NULL)
    free(new->line);*/
  new->line = mstrdup(line);
/*  if (new->name != NULL)
    free(new->name);*/
  new->name = mstrdup(name);
  new->time_in = a_time;
  new->time_out = 0;
  new->hash_val = hash_val;
  
  head_list->next = new;
  head_list->next->next = temp;
  
}



#define HASHSIZE 150000

unsigned hash(char *s, int length)
{
  unsigned hashval;
  int i = 0;
  
  for (hashval = 0 ; *s != '\0'; s++)
    {
      hashval = *s +31 * hashval;
      if (++i >= length)
	{	
	  break;
	}
    }
  return hashval;
/*  return hashval % HASHSIZE;*/
}
