/*	BSDI ppp.h,v 2.8 1995/10/25 18:43:50 prb Exp	*/

/*
 * Includes
 */
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <stdlib.h>
#include <setjmp.h>
#include <unistd.h>
#include <sgtty.h>
#include <errno.h>
#include "pathnames.h"

/*
 * File descriptors
 */
extern int FD;          /* line */
extern int Socket;      /* control socket */
extern char *sysname;   /* system name */

char *uucplock;         /* UUCP lock file name */

extern int debug;

/*
 * The list of system capabilities
 */
extern char *AT;     /* Auto call unit type. */
extern long  BR;     /* Baud rate. */
extern int   CD;     /* 100th second delays between commands on dialing */
extern char *CM;     /* Map of special characters (as in pppconfig) */
extern char *CU;     /* Call unit if making a phone call. */
extern int   DI;     /* Dial-in allowed. */
extern int   DO;     /* Automatic dial-out allowed. */
extern int   DU;     /* This is a dial-up line */
extern long  DT;     /* Dial timeout. */
extern char *DV;     /* Device(s) to open to establish a connection. */
extern char *E[10];  /* Strings to wait for on nth step of logging in */
		     /* (after sending s0-s9) */
extern char *F[10];  /* Strings to send if no expected str appeared */
extern long  ID;     /* Disconnect on idle (n seconds) */
extern char *IF;     /* Space-separated list of ifconfig parameters. */
extern int   IM;     /* Immediate connection */
extern long  IN;     /* Interface number. */
extern int   KU;     /* Keep interface up. */
extern char *LD;     /* Link down script. */
extern char *LF;     /* Login failed script. */
extern char *LI;     /* Login script. */
extern char *LU;     /* Link up script. */
extern long  MC;     /* Max PPP config retries. */
extern long  MR;     /* PPP MRU. */
extern char *MS;     /* Stty-style setup args for this port. */
extern long  MT;     /* Max PPP terminate retries. */
extern char *PF;     /* Comma-separated list of PPP flags (as in pppconfig) */
extern char *PN;     /* Telephone number(s) for this host. */
extern int   SL;     /* Use SLIP instead of PPP */
extern char *SO;     /* Script options */
extern char *S[10];  /* String to send on nth step of logging in. */
extern long  T[10];  /* Timeout in seconds for e0-e9 */
extern long  TO;     /* PPP retrty timeout (1/10 sec). */
extern long  WT;     /* How long to wait for certain events, such as BOS */

/* Functions */
extern char *hunt();
extern void unlock();
extern char *printable();
extern char *Connect();

extern char *index(), *rindex();
extern char *tgetstr();

/*
 * Definition of ACU line description
 */
typedef
	struct {
		char	*acu_name;
		int	(*acu_dialer)();
		int	(*acu_disconnect)();
		int	(*acu_abort)();
	}
	acu_t;

#define	equal(a, b)	(strcmp(a,b)==0)/* A nice function to string compare */

#define NOACU	((acu_t *)NULL)
#define NOSTR	((char *)NULL)

int	AC;			/* open file descriptor to dialer (v831 only) */

#define value(x) x
#define number(x) x
#define boolean(x) x

#define VERBOSE debug
#define DIALTIMEOUT 60
#define BAUDRATE BR
#define	WAITTIMEOUT 60
