/*-
 * Copyright (c) 1992,1993 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 */
/*	Krystal int17.c,v 2.1 1995/02/03 09:41:38 polk Exp */
#include "doscmd.h"
#include <signal.h>

static int	lpt_fd[4] = { -1, -1, -1, -1, };
static FILE	*lpt_file[4] = { 0, 0, 0, 0};
static int	direct[4] = { 0, 0, 0, 0};
static char	*queue[4] = { 0, 0, 0, 0};
static int	timeout[4] = { 30, 30, 30, 30 };
static int	last_poll[4] = { 0, 0, 0, 0};
static int	last_count[4] = { 0, 0, 0, 0};
static int	current_count[4] = { 0, 0, 0, 0};
static int	alarm_active[4] = { 0, 0, 0, 0};
static int	alarm_set = 0;

void open_printer(int);

void
int17(tf)
struct trapframe *tf;
{
    struct byteregs *b = (struct byteregs *)&tf->tf_bx;
    char	printer_name[20];
    int	fd;

    switch (b->tf_ah) {

    case 0x00:
	reset_poll();

	fd = lpt_fd[tf->tf_dx];
	if (fd == -1) {
	    open_printer(tf->tf_dx);
	    fd = lpt_fd[tf->tf_dx];
	}
	if (fd >= 0)
	    write(fd, &b->tf_al, 1);
	b->tf_ah = 0x90;	/* printed selected */
	current_count[tf->tf_dx]++;
	break;
    case 0x01:
	b->tf_ah = 0x90;
	break;

    case 0x02:
	b->tf_ah = 0x90;
	break;

    default:
	unknown_int2(0x17, b->tf_ah, tf);
	break;
    }
}

void lpt_poll(int sig, int code, struct sigcontext *scp)
{
    int	i;
    int	current;

    current = time(0);

    for(i=0; i < 4; i++) {
	if (lpt_fd[i] < 0)
	    continue;

	if (current - last_poll[i] < timeout[i])
	    continue;

	last_poll[i] = current;

	if (last_count[i] == current_count[i]) {
	    if (direct[i]) {
		debug(D_PRINTER, "Closing printer %d\n", i);
		close(lpt_fd[i]);
	    } else {
		debug(D_PRINTER, "Closing spool printer %d\n", i);
		pclose(lpt_file[i]);
	    }
	    lpt_fd[i] = -1;
	    lpt_file[i] = 0;
	}

	last_count[i] = current_count[i];
    }
}


void
open_printer(int printer)
{
    char	printer_name[80];
    char	command[120];
    int	fd;
    FILE	*file;

    /*
     * if printer is direct then open output device.
     */
    if (direct[printer]) {
	char *p;
	if (p = queue[printer]) {
	    if ((fd = open(p, O_WRONLY|O_APPEND|O_CREAT, 0666)) < 0) {
		perror(p);
		return;
	    }
	} else {
	    sprintf(printer_name, "/dev/lp%d", printer);
	    debug(D_PRINTER, "Opening device %s\n", printer_name);
	    if ((fd = open(printer_name, O_WRONLY)) < 0) {
		perror(printer_name);
		return;
	    }
    	}
	lpt_fd[printer] = fd;
	return;
    }

    /*
     * If printer is a spooled device then open pipe to spooled device
     */
    if (queue[printer])
	strcpy(printer_name, queue[printer]);
    else
	strcpy(printer_name, "lp");

    sprintf(command, "lpr -P %s", printer_name);
    debug(D_PRINTER, "opening pipe to %s\n", printer_name);

    if ((file = popen(command, "w")) == 0) {
	perror(command);
	return;
    }
    lpt_file[printer] = file;
    lpt_fd[printer] = fileno(file);
}

void
printer_direct(int printer)
{
    direct[printer] = 1;
}

void
printer_spool(int printer, char *print_queue)
{
    queue[printer] = print_queue ? strdup(print_queue) : 0;
}

void
printer_timeout(int printer, char *time_out)
{
    if (atoi(time_out) <= 0) {
	fprintf(stderr, "Bad timeout value on lpt%d:\n", printer+1);
	quit(1);
    }
    timeout[printer] = atoi(time_out);
}
