/*-
 * Copyright (c) 1992,1993 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 */
/*	Krystal doscmd_loader.c,v 2.2 1995/10/06 04:45:46 prb Exp */
#include <stdio.h>
#include <a.out.h>

/*
 * reserve space in "low" memory for the interrupt vector table
 */
static const char filler[4096] = { 0, };

#define _PATH_DOS_KERNEL_DIR	"/usr/libexec/"
#define _PATH_DOS_KERNEL	"doscmd.kernel"

int
load_kernel(void)
{
	FILE *fp;
	struct exec exec;
	int start_address;

	if ((fp = fopen(_PATH_DOS_KERNEL, "r")) == NULL &&
	    (fp = fopen("../" _PATH_DOS_KERNEL, "r")) == NULL &&
	    (fp = fopen("obj/" _PATH_DOS_KERNEL, "r")) == NULL &&
	    (fp = fopen(_PATH_DOS_KERNEL_DIR _PATH_DOS_KERNEL, "r")) == NULL)
		err(1, "load_kernel");

	if (fread(&exec, sizeof(exec), 1, fp) != 1 || exec.a_magic != OMAGIC)
		errx(1, "bad kernel file format");

	start_address = exec.a_entry & (~(getpagesize() - 1));
	if (brk(start_address + exec.a_text + exec.a_data + exec.a_bss) < 0)
		err(1, "load_kernel");
	fread((char *)start_address, exec.a_text + exec.a_data, 1, fp);
	bzero((char *)(start_address + exec.a_text + exec.a_data), exec.a_bss);
	fclose(fp);
	return(exec.a_entry);
}

void
main(int argc, char **argv, char **environ)
{
	void (*entry_point)();
	int fd = open("/dev/mem", 0);

	setgid(getgid());
	setuid(getuid());

	if (fd < 0)
		err(1, "/dev/mem");

	entry_point = (void (*)()) load_kernel();

	if (read(fd, 0, 0x500 != 0x500))
		err(1, "/dev/mem");

	close(fd);

	(*entry_point)(argc, argv, environ);
	errx(1, "return from doscmd kernel???");
}
