.ig \"-*- nroff -*-
Copyright (C) 1991-1995 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.\" groff_mm.man,v 2.2 1995/12/05 20:32:55 polk Exp
.\"
.de T2
.ne 2v
.ti -.5i
\\$1
.sp -1
..
.de T3
.ne 2v
.ti -.5i
\fB\\$1\fP
.br
..
.TH GROFF_MM @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_mm \- groff mm macros
.SH SYNOPSIS
.B groff
.B \-m@TMAC_M_PREFIX@m
[
.IR options .\|.\|.
]
[
.IR files .\|.\|.
]
.SH DESCRIPTION
The groff mm macros are intended to be compatible with the DWB mm macros
with the following limitations:
.TP
.B \(bu
no Bell Labs localisms implemented.
.TP
.B \(bu
the macros OK and PM is not implemented.
.TP
.B \(bu
groff mm does not support cut marks
.LP
\fBm@TMAC_M_PREFIX@m\fP is intended to be international. Therefore it is 
possible to write short national macrofiles which change all
english text to the preferred language. Use \fBm@TMAC_M_PREFIX@mse\fP as an example.
.LP
New macros: \fBAPP\fP, \fBAPPSK\fP, \fBB1\fP, \fBB2\fP, \fBBVL\fP,
\fBCOVER\fP, \fBCOVEND\fP, \fBGETHN\fP, \fBGETPN\fP, \fBGETR\fP,
\fBGETST\fP, \fBINITR\fP, \fBMC\fP, \fBMOVE\fP, \fBMULB\fP,
\fBMULN\fP, \fBMULE\fP, \fBPGFORM\fP, \fBPGNH\fP, \fBSETR\fP,
\fBTAB\fP, \fBVERBON\fP, \fBVERBOFF\fP.
.LP
.\"########################################################################
.LP
A file called \fBlocale\fP or \fIlang\fP\fB_locale\fP is read
after the initiation of the global variables. It is therefore
possible to localize the macros with companyname and so on.
.sp
In this manual square brackets is used to show optional arguments.
.sp 3
\fBNumber registers and strings\fP
.br
Many macros can be controlled by number registers and strings.
A number register is assigned with the \fBnr\fP command:
.br
\fB\&.nr\fP \fIXXX\fP \fI[+-]n [i]\fP
.br
\fBXXX\fP is the name of the register, \fBn\fP is the value to
be assigned, and \fBi\fP is increment value for auto-increment.
\fBn\fP can have a plus or minus sign as prefix if an increment
or decrement of the current value is wanted. (Auto-increment or decrement
occurs if the number register is used with a plus or minus sign,
\fB\en+[XXX]\fP or \fB\en-[XXX]\fP.)
.sp
Strings is defined with \fBds\fP.
.br
\fB\&.ds\fP \fIYYY string\fP
.br
The string is assigned everything to the end of the line, even blanks.
Initial blanks in \fIstring\fP should be prefixed with
a double-quote. (Strings are used in the text as \fB\e*[YYY]\fP.)
.sp
\fBSpecial formatting of number registers\fP
A number register is printed with normal digits if no format has been
given.
Set the format with \fBaf\fP:
.br
\fB\&.af\fP \fIR c\fP
.br
\fIR\fP is the name of the register, \fIc\fP is the format.
.in +.5i
.T2 \fBForm\fP
\fBSequence\fP
.T2 1
0, 1, 2, 3, ...
.T2 001
000, 001, 002, 003, ...
.T2 i
0, i, ii, iii, iv, ...
.T2 I
0, I, II, III, IV, ...
.T2 a
0, a, b, c, ..., z, aa, ab, ...
.T2 A
0, A, B, C, ..., Z, AA, AB, ...
.in

.LP
\fBMacros:\fP
.TP
.B "1C [1]"
Begin one column processing. An \fB1\fP as argument disables the page-break.
Use wide footnotes, small footnotes may be overprinted.
.TP
.B 2C
Begin two column processing. Splits the page in two columns. It is
a special case of \fBMC\fP. See also \fB1C\fP.
.TP
.B AE
Abstract end, see \fBAS\fP.
.TP
.B "AF [name of firm]"
Authors firm, should be called before \fBAU\fP, see also \fBCOVER\fP.
.TP
.B "AL [type [text-indent [1]]]]"
Start autoincrement list. Items are numbered beginning on one.
The \fItype\fP argument controls the type of numbers.
.in +.5i
.T2 Arg
Description
.T2 1
Arabic (the default)
.T2 A
Upper-case letters (A-Z)
.T2 a
Lower-case letters (a-z)
.T2 I
Upper-case roman
.T2 i
Lower-case roman
.in
\fIText-indent\fP sets the indent and overrides \fBLi\fP.
A third argument will prohibit printing of a blank line before each
item.
.TP
.B "APP name text"
Begin an appendix with name \fIname\fP. Automatic naming occurs if
\fIname\fP is "". The appendixes starts with \fBA\fP if auto is used.
An new page is ejected, and a header is also produced if the number
variable \fBAph\fP is non-zero. This is the default.
The appendix always appear in the 'List of contents' with correct
pagenumber. The name \fIAPPENDIX\fP can be changed by setting
the string \fBApp\fP to the desired text.
.TP
.B "APPSK name pages text"
Same as \fB.APP\fP, but the pagenr is incremented with \fIpages\fP.
This is used when diagrams or other non-formatted documents are
included as appendixes.
.TP
.B "AS [arg [indent]]"
Abstract start. Indent is specified in 'ens', but scaling is allowed.
Argument \fIarg\fP controls where the abstract is printed.
.in +.5i
.T2 Arg
Placement
.T2 0
Abstract will be printed on page 1 and con the cover sheet if
used in the released-paper style (\fBMT 4\fP), otherwise
it will be printed on page 1 without a cover sheet.
.T2 1
Abstract will only be printed on page 1 (\fBMT 4\fP only).
.T2 2
Abstract will be printed only on the cover sheet. The cover sheet
is printed without need for \fBCS\fP.
.in
Abstract is not printed at all in external letters (\fBMT 5\fP).
The \fIindent\fP controls the indentation of both margins, otherwise
will normal text indent be used.
.TP
.B "AST [title]"
Abstract title. Default is \fBABSTRACT\fP.
Sets the text above the abstract text.
.TP
.B "AT title1 [title2 ...]"
Authors title. \fBAT\fP must appear just after each \fBAU\fP.
The title will show up after the name in the signature block.
.TP
.B "AU name [initials [loc [dept [ext [room [arg [arg [arg]]]]]]]]"
Author information, specifies the author of the memo or paper, and
will be printed on the cover sheet and on other similar places.
\fBAU\fP must appear before \fBTL\fP. The author information
can contain intials, location, department, telephone extension,
room number or name and up to three extra arguments.
.TP
.B "AV [name [1]]"
Approval signature, generates an approval line with place for
signature and date. The string \fBAPPROVED:\fP can be changed
with variable \fBLetapp\fP, and the string \fBDate\fP in \fBLetdate\fP.
.TP
.B "B [bold-text [prev-font-tex [bold...]]]"
Begin boldface
No limit on the number of arguments.
All arguments will be concatenated to one word, the first, third and so
on will be printed in boldface.
.TP
.B B1
Begin box (as the ms macro)
Draws a box around the text. The text will be indented one character,
and the right margin will be one character shorter.
.TP
.B B2
End box. Finish the box started by \fBB1\fP.
.TP
.B BE
End bottom block, see \fBBS\fP.
.TP
.B "BI [bold-text [italic-text [bold-text [...]]]"
Bold-italic.
No limit on the number of arguments, see \fBB\fP.
.TP
.B "BL [text-indent [1]]"
Start bullet list, initialize a list with a bullet and a space
in the beginning of each list item (see \fBLI\fP).
\fIText-indent\fP
overrides the default indentation of the list items set by
number register \fBPi\fP.
A third argument will prohibit printing of a blank line before each
item.
.TP
.B "BR [bold-text [roman-text [bold-text [...]]]"
Bold-roman.
No limit on the number of arguments.
.TP
.B BS
Bottom block start. Begins the definition of a text block wich is
printed at the bottom of each page. Block ends with \fBBE\fP.
.TP
.B BVL
Start of 
broken variable-item list.
Broken variable-item list has no fixed mark, it assumes that
every \fBLI\fP has a mark instead.
The text will always begin at the next line after the mark.
\fIText-indent\fP sets the indent to the text, and \fImark-indent\fP
the distance from the current indent to the mark.
A third argument will prohibit printing of a blank line before each
item.
.TP
.B "COVER [arg]"
\&\fBCOVER\fP begins a coversheet definition. It is important
that \fB.COVER\fP appears before any normal text.
\&\fB.COVER\fP uses \fIarg\fP to build the filename 
@TMAC_MDIR@/\fIarg\fP.cov. Therefore it is possible to create unlimited
types of coversheets.
\fIms.cov\fP is supposed to look like the \fBms\fP coversheet.
\&\fB.COVER\fP requires a \fB.COVEND\fP at the end of the coverdefinition.
Always use this order of the covermacros:
.nf
\&.COVER
\&.TL
\&.AF
\&.AU
\&.AT
\&.AS
\&.AE
\&.COVEND
.fi
However, only \fB.TL\fP and \fB.AU\fP are required.
.TP
.B COVEND
This finish the cover description and prints the cover-page.
It is defined in the cover file.
.TP
.B DE
Display end. Ends a block of text, display, that begins
with \fBDS\fP or \fBDF\fP.
.TP
.B "DF [format [fill [rindent]]]"
Begin floating display (no nesting allowed). 
A floating display is saved in a queue and is printed in the
order entered. \fIFormat\fP, \fIfill\fP and \fIrindent\fP is the same
as in \fBDS\fP.
Floating displays are controlled by the two number registers \fBDe\fP
and \fBDf\fP.
.sp
\fBDe register\fP
.in +.5i
.T2 0
Nothing special, this is the default.
.T2 1
A page eject will occur after each printed display, giving only
one display per page and no text following it.
.in
.sp
\fBDf register\fP
.in +.5i
.T2 0
Displays are printed at the end of each section (when section-page
numbering is active) or at the end of the document.
.T2 1
A new display will be printed on the current page is there is enough
space, otherwise it will be printed at the end of the document.
.T2 2
One display will be printed at the top of each page or column
(in multi-column mode).
.T2 3
Print one display if there is enough space for it, otherwise it will
be printed at the top of the next page or column.
.T2 4
Print as many displays that will fit in a new page or column.
A page break will occur between each display if \fBDe\fP is not zero.
.T2 5
Fill the current page with displays and the rest beginning at a new page
or column. (This is the default.)
A page break will occur between each display
if \fBDe\fP is not zero.
.in
.TP
.B "DL [text-indent [1]]"
Dash list start. Begins a list where each item is printed
after a dash. \fIText-indent\fP changes the default indentation
of the list items set by
number register \fBPi\fP.
A third argument will prohibit printing of a blank line before each
item.
A second argument prevents the empty line between each list item
to be printed. See \fBLI\fP.
.TP
.B "DS [format [fill [rindent]]]"
Static display start.
Begins collection of text until \fBDE\fP.
The text is printed together on the same page, unless it is longer
than the height of the page.
\fBDS\fP can be nested to a unlimited depth (reasonably :-).
.sp
\fBformat\fP
.in +.5i
.ds x "
.T2 """"""
No indentation.
.T2 none
No indentation.
.T2 L
No indentation.
.T2 I
Indent text with the value of number register \fBSi\fP.
.T2 C
Center each line
.T2 CB
Center the whole display as a block.
.T2 R
Right adjust the lines.
.T2 RB
Right adjust the whole display as a block
.in
.sp
L, I, C and CB can also be specified as 0, 1, 2 or 3 for compatibility
reasons. (Don't use it. :-)
.sp
\fBfill\fP
.in +.5i
.T2 """"""
Line-filling turned off.
.T2 none
Line-filling turned off.
.T2 N
Line-filling turned off.
.T2 F
Line-filling turned on.
.in
.sp
N and F can also be specified as 0 or 1.
An empty line will normally be printed before and after the
display. Setting number register \fBDs\fP to 0 will prevent this.
\fIRindent\fP shortens the line length by that amount.
.TP
.B "EC [title [override [flag [refname]]]]"
Equation title.
Sets a title for an equation. The \fIoverride\fP argument
change the numbering.
.sp
\fBflag\fP
.in +.5i
.T2 none
\fIoverride\fP is a prefix to the number.
.T2 0
\fIoverride\fP is a prefix to the number.
.T2 1
\fIoverride\fP is a suffix to the number.
.T2 2
\fIoverride\fP replaces the number.
.in
\fBEC\fP uses the number register \fBEc\fP as counter.
It is possible to use \fB.af\fP to change the format of the number.
If number register \fBOf\fP is 1, then the format of title
will use a dash instead of a dot after the number.
The string \fBLe\fP controls the title of the
List of Equations, default is \fILIST OF EQUATIONS\fP.
The string \fBLiec\fP contains the word \fIEquation\fP, wich
is printed before the number.
If \fIrefname\fP is used, then the equationnumber is saved with
\&\fB.SETR\fP, and can be retrieved with \fB.GETST\fP \fIrefname\fP.
.TP
.B "EF [arg]"
Even-page footer, printed just above the normal page footer
on even pages, see \fBPF\fP.
.TP
.B "EH [arg]"
Even-page header, printed just below the normal page header
on even pages, see \fBPH\fP.
.TP
.B EN
Equation end, see \fBEQ\fP.
.TP
.B EOP
End of page user-defined macro. This macro will be called
instead of the normal printing of the footer. The macro
will be executed in a separate environment, without any
trap active. See \fBTP\fP.
.sp
\fBStrings available to EOP\fP
.in +.5i
.T2 EOPf
Argument from \fBPF\fP.
.T2 EOPef
Argument from \fBEF\fP.
.T2 EOPof
Argument from \fBOF\fP.
.in
.TP
.B "EQ [label]"
Equation start.
\fBEQ\fP/\fBEN\fP are the delimiters for equations written for \fBeqn\fP.
\fBEQ\fP/\fBEN\fP must be inside a \fBDS\fP/\fBDE\fP-pair, except
when \fBEQ\fP is only used to set options in \fBeqn\fP.
The \fIlabel\fP will appear at the right margin of the equation, unless
number register \fBEq\fP is 1. Then the label will appear at the
left margin.
.TP
.B "EX [title [override [flag [refname]]]]"
Exhibit title, arguments are the same as for \fBEC\fP
\fBEX\fP uses the number register \fBEx\fP as counter.
The string \fBLx\fP controls the title of the
List of Exhibits, default is \fILIST OF EXHIBITS\fP.
The string \fBLiex\fP contains the word \fIExhibit\fP, wich
is printed before the number.
If \fIrefname\fP is used, then the exhibitnumber is saved with
\&\fB.SETR\fP, and can be retrieved with \fB.GETST\fP \fIrefname\fP.
.TP
.B "FC [closing]"
Prints \fIYours\ very\ truly,\fP as a formal closing of a letter or
memorandum. The argument replaces the defualt string.
The default is stored in string variable \fBLetfc\fP.
.TP
.B "FD [arg [1]]"
Footnote default format.
Controls the hyphenation (hyphen), right margin justification (adjust),
indentation of footnote text (indent). It can also change the label
justification (ljust).
.sp
.ne 14v
.nf
.ta .5i +.8i +.8i +.8i +.8i
\fBarg	hyphen	adjust	indent	ljust\fP
0	no	yes	yes	left
1	yes	yes	yes	left
2	no	no	yes	left
3	yes	no	yes	left
4	no	yes	no	left
5	yes	yes	no	left
6	no	no	no	left
7	yes	no	no	left
8	no	yes	yes	right
9	yes	yes	yes	right
10	no	no	yes	right
11	yes	no	yes	right
.sp
.fi
.DT
Argument greater than or equal to 11 is considered as arg 0.
Default for m@TMAC_M_PREFIX@mm is 10.
.TP
.B FE
Footnote end.
.TP
.B "FG [title [override [flag [refname]]]]"
Figure title.
If \fIrefname\fP is used, then the figurenumber is saved with
\&\fB.SETR\fP, and can be retrieved with \fB.GETST\fP \fIrefname\fP.
.TP
.B "FS [label]"
Footnote start.
The footnote is ended by \fBFE\fP. Footnotes is normally automatically
numbered, the number is available in string \fBF\fP.
Just add \fB\e*F\fP in the text. By adding \fIlabel\fP, it is possible
to have other number or names on the footnotes.
Footnotes in displays is now possible.
An empty line separates footnotes, the height of the line
is controlled by number register \fBFs\fP, default value is 1.
.TP
.B "GETHN refname [varname]"
Includes the headernumber where the corresponding \fBSETR\fP \fIrefname\fP
was placed. Will be X.X.X. in pass 1. See \fBINITR\fP.
If varname is used, \fBGETHN\fP sets the stringvariable \fIvarname\fP to the 
headernumber.
.TP
.B "GETPN refname [varname]"
Includes the pagenumber where the corresponding \fBSETR\fP \fIrefname\fP
was placed. Will be 9999 in pass 1. See \fBINITR\fP.
If varname is used, \fBGETPN\fP sets the stringvariable \fIvarname\fP
to the pagenumber.
.TP
.B "GETR refname"
Combines \fBGETHN\fP and \fBGETPN\fP with the text 'chapter' and ', page'.
The string \fIQrf\fP contains the text for reference:
.ti +.5i
\&.ds Qrf See chapter \e\e*[Qrfh], page \e\e*[Qrfp].
.br
\fIQrf\fP may be changed to support other languages.
Strings \fIQrfh\fP and \fIQrfp\fP are set by \fBGETR\fP
and contains the page and headernumber.
.TP
.B "GETST refname [varname]"
Includes the string saved with the second argument to \fB.SETR\fP.
Will be dummystring in pass 1.
If varname is used, \fBGETST\fP sets the stringvariable \fIvarname\fP to the 
saved string. See \fBINITR\fP.
.TP
.B "H level [heading-text [heading-suffix]]"
Numbered section heading.
Section headers can have a level between 1 and 7, level 1 is the
top level. The text is given in \fIheading-text\fP, and must be
surrounded by double quotes if it contains spaces.
\fBHeading-suffix\fP is added to the header in the text but not in
the table of contents. This is normally used for footnote marks
and similar things. Don't use \fB\e*F\fP in \fIheading-suffix\fP, it won't
work. A manual label must be used, see \fBFS\fP.
.sp
An eventual paragraph, \fBP\fP, directly after \fBH\fP will be
ignored, \fBH\fP is taking care of spacing and indentation.
.sp
\fBPage ejection before heading\fP
.br
Number register \fBEj\fP controls page ejection before the heading.
Normally, a level one heading gets two blank lines before it, higher levels
gets only one. A new page is ejected before each
first-level heading if number register \fBEj\fP is 1.
All levels below or equal the value of \fBEj\fP gets a new page.
Default value for \fBEj\fP is 0.
.sp
\fBHeading break level\fP
.br
A line break occurs after the heading if the heading level is less
or equal to number register \fBHb\fP.
Default value 2.
.sp
\fBHeading space level\fP
.br
A blank line is inserted after the heading if the heading level is less
or equal to number register \fBHs\fP.
Default value 2.
.sp
Text will follow the heading on the same line if the level is greater
than both \fBHb\fP and \fBHs\fP.
.sp
\fBPost-heading indent\fP
.br
Indentation of the text after the heading is controlled by number
register \fBHi\fP, default value 0.
\fBHi\fP
.in +.5i
.T2 0
The text will be left-justified.
.T2 1
Indentation of the text will follow the value of number register \fBPt\fP,
see \fBP\fP.
.T2 2
The text will be lined up with the first word of the heading.
.in
.sp
\fBCentered section headings\fP
.br
All headings whose level is equal or below number register \fBHc\fP
and also less than or equal to \fBHb\fP or \fBHs\fP
is centerered.
.sp
\fBFont control of the heading\fP
.br
The font of each heading level is controlled by string \fBHF\fP.
It contains a fontnumber or fontnam for each level. Default
is \fB2\ 2\ 2\ 2\ 2\ 2\ 2\fP (all headings in italic).
Could also be written as \fBI\ I\ I\ I\ I\ I\ I\fP.
All omitted values are presumed to be a 1.
.sp
\fBPoint size control\fP.
.br
String \fBHP\fP controls the pointsize of each heading, in the
same way as \fBHF\fP controls the font.
A value of 0 selects the default point size.
Default value is \fB0\ 0\ 0\ 0\ 0\ 0\ 0\fP. Beware that only the
point size changes, not the vertical size.
That can be controlled by the user specified macro \fBHX\fP and/or
\fBHZ\fP.
.sp
\fBHeading counters\fP
.br
Seven number registers, named \fBH1\fP thru \fBH7\fP contains
the counter for each heading level.
The values are printed using arabic numerals, this can be changed
with the macro \fBHM\fP (see below).
All marks ar concatenated before printing. To avoid this, set
number register \fBHt\fP to 1. That will only print the current
heading counter at each heading.
.sp
\fBAutomatic table of contents\fP
.br
All headings whose level is equal or below number register \fBCl\fP
is saved to be printed in the table of contents. Default value is 2.
.sp
\fBSpecial control of the heading, user-defined macros\fP.
.br
These macros can be defined by the user to get a finer control
of vertical spacing, fonts or other features.
Argument \fIlevel\fP is the level-argument to \fBH\fP, but
0 for unnumbered headings (see \fBHU\fP).
Argument \fIrlevel\fP is the real level, it is
set to number register \fBHu\fP for unnumbered headings.
Argument \fIheading-text\fP is the text argument to \fBH\fP and \fBHU\fP.
.sp
\fBHX\ \fP\fIlevel\ rlevel\ heading-text\fP
.br
\fBHX\fP is called just before the printing of the heading.
The following register is available for \fBHX\fP.
\fBHX\fP may alter \fB}0\fP, \fB}2\fP and \fB;3\fP.
.in +.5i
.T3 "string }0"
Contains the heading mark plus two spaces if \fIrlevel\fP is non-zero,
otherwise empty.
.T3 "register ;0"
Contains the position of the text after the heading.
0 means that the text should follow the heading on the same line, 1
means that a line break should occur before the text and
2 means that a blank line should separate the heading and the text.
.T3 "string }2"
Contains two spaces if register \fB;0\fP is 0. It is used to
separate the heading from the text. The string
is empty if \fB;0\fP is non-zero.
.T3 "register ;3"
Contains the needed space in units after the heading.
Default is 2v.

Can be used to change things like numbering (\fB}0\fP),
vertical spacing (\fB}2\fP)
and the needed space after the heading.
.in
.sp
\fBHY\ \fP\fIdlevel\ rlevel\ heading-text\fP
.br
\fBHY\fP is called after size and font calculations and
might be used to change indentation.
.sp
\fBHZ\ \fP\fIdlevel\ rlevel\ heading-text\fP
\fBHZ\fP is called after the printing of the heading, just before
\fBH\fP or \fBHU\fP exits.
Could be used to change the page header according to the section heading.
.TP
.B "HC [hyphenation-character]"
Set hyphenation character.
Default value is \e%.
Resets to the default if called without argument.
Hyphenation can be turned by setting number
register \fBHy\fP to 0 in the beginning of the file.
.TP
.B "HM [arg1 [arg2 [... [arg7]]]]"
Heading mark style. 
Controls the type of marking for printing of the heading counters.
Default is 1 for all levels.
.sp
\fBArgument\fP
.in +.5i
.T2 1
Arabic numerals.
.T2 0001
Arabic numerals with leading zeroes, one or more.
.T2 A
Upper-case alphabetic
.T2 a
Lower-case alphabetic
.T2 I
Upper-case roman numerals
.T2 i
lower-case roman numerals
.T2 \fIempty\fP
Arabic numerals.
.in
.TP
.B "HU heading-text"
Unnumbered section header.
\fBHU\fP behavies like \fBH\fP at the level in number register \fBHu\fP.
See \fBH\fP.
.TP
.B "HX dlevel rlevel heading-text"
Userdefined heading exit.
Called just before printing the header.
See \fBH\fP.
.TP
.B "HY dlevel rlevel heading-text"
Userdefined heading exit.
Called just before printing the header.
See \fBH\fP.
.TP
.B "HZ dlevel rlevel heading-text"
Userdefined heading exit.
Called just after printing the header.
See \fBH\fP.
.TP
.B "I [italic-text [prev-font-text [italic-text [...]]]"
Italic.
Changes the font to italic if called without arguments.
With one argument it will set the word in italic.
With two argument it will concatenate them and set the first
word in italic and the second in the previous font.
There is no limit on the number of argument, all will be concatenated.
.TP
.B "IA [addressee-name [title]]
Begins specification of the addressee and addressee's address in
letter style.
Several names can be specified with empty \fBIA\fP/\fBIE\fP-pairs, but
only one address.
See \fBLT\fP.
.TP
.B "IB [italic-text [bold-text [italic-text [...]]]"
Italic-bold
Even arguments is printed in italic, odd in boldface.
See \fBI\fP.
.TP
.B IE
Ends the address-specification after \fPIA\fP.
.TP
.B "INITR filename"
Initialize the refencemacros. References will be written to
\fIfilename.tmp\fP and \fIfilename.qrf\fP. Requires two passes with groff.
The first looks for references and the second includes them.
\fBINITR\fP can be used several times, but it is only the first
occurrence of \fBINITR\fP that is active.
See also \fBSETR\fP, \fBGETPN\fP and \fBGETHN\fP.
.TP
.B "IR [italic-text [roman-text [italic-text [...]]]"
Italic-roman
Even arguments is printed in italic, odd in roman.
See \fBI\fP.
.TP
.B "LB text-indent mark-indent pad type [mark [LI-space [LB-space]]]"
List begin macro.
This is the common macro used for all lists.
\fIText-indent\fP is the number of spaces to indent the text from the
current indent.
.sp
\fIPad\fP and \fImark-indent\fP controls where to put the mark.
The mark is placed within the mark area, and \fImark-indent\fP
sets the number of spaces before this area. It is normally 0.
The mark area ends where the text begins. The start of the text
is still controlled by \fItext-indent\fP.
.sp
The mark is left justified whitin the mark area if \fIpad\fP is 0.
If \fIpad\fP is greater than 0, then \fImark-indent\fP is ignored, and
the mark is placed \fIpad\fP spaces before the text.
This will right justify the mark.
.sp
If \fItype\fP is 0 the list will have either a hanging indent or, if
argument \fImark\fP is given, the string \fImark\fP as mark.
.sp
If \fItype\fP is greater than 0 automatic numbering will occur, arabic
if \fImark\fP is empty. \fIMark\fP can then be any of \fB1\fP, \fBA\fP,
\fBa\fP, \fBI\fP or \fBi\fP.
.sp
\fIType\fP selects one of six possible ways to display the mark.
.br
\fBtype\fP
.in +.6i
.T2 1
x.
.T2 2
x)
.T2 3
(x)
.T2 4
[x]
.T2 5
<x>
.T2 6
{x}
.in
.sp
Every item in the list will get \fILI-space\fP number of blank lines
before them. Default is 1. 
.sp
\fBLB\fP itself will print \fILB-space\fP blank lines. Default is 0.
.TP
.B "LC [list-level]"
List-status clear
Terminates all current active lists down to \fIlist-level\fP, or 0
if no argmuent is given. This is used by \fBH\fP to clear any
active list.
.TP
.B "LE [1]"
List end.
Terminate the current list. \fBLE\fP outputs a blank line
if an argument is given.
.TP
.B "LI [mark [1]]"
List item precedes every item in a list. Without argument \fBLS\fP
will print the mark determined by the current list type. By giving
\fBLI\fP one argument, it will use that as the mark instead.
Two arguments to \fBLI\fP will make \fImark\fP a prefix to
the current mark. A zero length \fImark\fP will make a hanging
indent instead.
.sp
A blank line is normally printed before the list item. This behaviour
can be controlled by number register \fBLs\fP. Pre-spacing
will occur for each list-level less than or equal to \fBLs\fP.
Default value is 99. (Nesting of lists is unlimited. :-)
.sp
The indentation can be changed thru number register \fBLi\fP.
Default is 6.
.sp
All lists begins with a list initialization macro, \fBLB\fP.
There are, however, seven predefined listtypes to
make lists easier to use. They all call \fBLB\fP with different
default values.
.in +.5i
.T2 \fBAL\fP
Automatically Incremented List
.T2 \fBML\fP
Marked List
.T2 \fBVL\fP
Variable-Item List
.T2 \fBBL\fP
Bullet List
.T2 \fBDL\fP
Dash List
.T2 \fBRL\fP
Reference List
.T2 \fBBVL\fP
Broken Varable List.
.in
These lists are described at other places in this manual. See also \fBLB\fP.
.TP
.B "LT [arg]"
Formats a letter in one of four different styles depending
on the argument.
See also \fBINTERNALS\fP.
.in +.5i
.T2 \fBArg
Style\fP
.T2 BL
Blocked. Date line, return address, writer's address and closing
begins at the center of the line. All other lines begins at the left margin.
.T2 SB
Semi-blocked. Same as blocked, except that the first line in every
paragraph is indented five spaces.
.T2 FB
Full-blocked. All lines begin at the left margin.
.T2 SP
Simplified. Almost the same as the full-blocked style. Subject and
the writer'sidentification is printed in all-capital.
.in
.TP
.B "LO type [arg]"
Specify options in letter (see \fB.LT\fP).
This is a list of the standard options:
.in +.5i
.T2 CN
Confidential notation. Prints \fBRESTRICTED\fP on the second line
below the date line. Any argument replaces \fBRESTRICTED\fP.
See also string variable \fBLetCN\fP.
.T2 RN
Reference notation. Prints \fBIn reference to:\fP and the argument
two lines below the date line.
See also string variable \fBLetRN\fP.
.T2 AT
Attention. Prints \fBATTENTION:\fP and the argument below the inside address.
See also string variable \fBLetAT\fP.
.T2 SA
Salutation. Prints \fBTo Whom It May Concern:\fP or the argument if
it was present. The salutation is printed two lines below the inside address.
See also string variable \fBLetSA\fP.
.T2 SJ
Subject line. Prints the argument as subject prefixed with \fBSUBJECT:\fP
two lines below the inside address, except in letter type \fBSP\fP.
Then the subject is printed in all-captial without any prefix.
See also string variable \fBLetSJ\fP.
.in
.TP
.B "MC column-size [column-separation] "
Begin multiple columns. Return to normal with \fB1C\fP.
\fBMC\fP will create as many columns as the current line length permits.
\fIColumn-size\fP is the width of each column, and \fIcolumn-separation\fP
is the space between two columns. Default separation is the 
column-size/15.
See also \fB1C\fP.
.TP
.B "ML mark [text-indent [1]]"
Marked list start. The \fImark\fP argument will be printed before
each list item.
\fIText-indent\fP sets the indent and overrides \fBLi\fP.
A third argument will prohibit printing of a blank line before each
item.
.TP
.B "MT [arg [addressee]]"
Memorandum type.
The \fIarg\fP is part of a filename in \fI@TMAC_MDIR@/*.MT\fP.
Memorandum type 0 thru 5 are supported, including \fI"string"\fP.
\fIAddresse\fP just sets a variable, used in the AT&T macros.
.br
\fBarg\fP
.in +.5i
.T2 0
Normal memorandum, no type printed
.T2 1
Memorandum with \fIMEMORANDUM FOR FILE\fP printed
.T2 2
Memorandum with \fIPROGRAMMER'S NOTES\fP printed
.T2 3
Memorandum with \fIENGINEER'S NOTES\fP printed
.T2 4
Released paper style
.T2 5
External letter style
.in
See also \fBCOVER\fP/\fBCOVEND\fP, a more flexible type of front page.
.TP
.B "MOVE y-pos [x-pos [line-length]]"
Move to a position, pageoffset set to \fIx-pos\fP.
If \fIline-length\fP is not given, the difference between
current and new pageoffset is used.
Use \fBPGFORM\fP without arguments to return to normal.
.TP
.B "MULB cw1 space1 [cw2 space2 [cw3 ...]]"
Begin a special multi-column mode. Every columns width must be specified.
Also the space between the columns must be specified. The last column
does not need any space-definition. MULB starts a diversion and MULE
ends the diversion and prints the columns.
The unit for width and space is 'n', but MULB accepts all 
normal unitspecifications like 'c' and 'i'.
MULB operates in a separate environment.
.TP
.B "MULN"
Begin the next column. This is the only way to switch column.
.TP
.B "MULE"
End the multi-column mode and print the columns.
.TP
.B "nP [type]"
Print numbered paragraph with header level two. Se \fB.P\fP.
.TP
.B "NS [arg [1]]"
Prints different types of notations. The argument selects between
the predefined type of notations. If the second argument is available, 
then the argument becomes the entire notation.
If the argument doesn't exist in the predefined, it will be
printed as \fBCopy (\fP\fIarg\fP\fB) to\fP.
It is possible to add more standard notations, see the string variable
\fBLetns\fP and \fBLetnsdef\fP.
.nf
.in +.5i
.T2 \fBArg
Notation\fP
.T2 \fInone\fP
Copy To
.T2 """""
Copy To
.T2 1
Copy To (with att.) to
.T2 2
Copy To (without att.) to
.T2 3
Att.
.T2 4
Atts.
.T2 5
Enc.
.T2 6
Encs.
.T2 7
Under separate cover
.T2 8
Letter to
.T2 9
Memorandum to
.T2 10
Copy (with atts.) to
.T2 11
Copy (without atts.) to
.T2 12
Abstract Only to
.T2 13
Complete Memorandum to
.T2 14
CC
.in
.fi
.TP
.B "ND new-date"
New date. Override the current date. Date is not
printed if \fInew-date\fP is an empty string.
.TP
.B "OF [arg]"
Odd-page footer, a line printed just above the normal footer.
See \fBEF\fP and \fBPF\fP.
.TP
.B "OH [arg]"
Odd-page header, a line printed just below the normal header.
See \fBEH\fP and \fBPH\fP.
.TP
.B OP
Make sure that the following text is printed at the top
of an odd-numbered page. Will not output an empty page
if currently at the top of an odd page.
.TP
.B "P [type]"
Begin new paragraph.
\fBP\fP without argument will produce left justified text, even
the first line of the paragraph. This is the same as setting
\fItype\fP to 0. If the argument is 1, then the first line
of text following \fBP\fP will be indented by the number of
spaces in number register \fBPi\fP, normally 5.
.sp
Instead of giving 1 as argument to \fBP\fP it is possible to set the
paragraph type in number register \fBPt\fP. Using 0 and 1
will be the same as adding that value to \fBP\fP.
A value of 2 will indent all paragraphs, except after
headings, lists and displays.
.sp
The space between two paragraphs is controlled by number register \fBPs\fP,
and is 1 by default (one blank line).
.TP
.B "PGFORM [linelength [pagelength [pageoffset [1]]]]"
Sets linelength, pagelength and/or pageoffset.
This macro can be used for special formatting, like letterheads
and other.
It is normally the first command in a file, though it's not necessary.
\fBPGFORM\fP can be used without arguments 
to reset everything after a \fBMOVE\fP.
A line-break is done unless the fourth argument is given. 
This can be used to avoid the pagenumber on the first page while setting
new width and length.
.TP
.B PGNH
No header is printed on the next page. Used to get rid off
the header in letters or other special texts
This macro must be used before any text to inhibit the pageheader
on the first page.
.TP
.B PE
Picture end.
Ends a picture for \fB@g@pic\fP, see the manual for \fB@g@pic\fP.
.TP
.B "PF [arg]"
Page footer.
\fBPF\fP sets the line to be printed at the bottom of each page.
Normally empty. See \fBPH\fP for the argument specification.
.TP
.B "PH [arg]"
Page header, a line printed at the top of each page.
The argument should be specified as "'left-part'center-part'right-part'",
where left-, center- and right-part is printed left-justified, centered
and right justified. The character \fB%\fP is changed to the current
page number. The default page-header is "''- % -''", the page
number between two dashes.
.TP
.B PS
Picture start (from pic). Begins a picture for \fB@TMAC@pic\fP, see
the manual.
.TP
.B PX
Page-header user-defined exit.
\fBPX\fP is called just after the printing of the page header
in \fIno-space\fP mode.
.TP
.B R
Roman.
Return to roman font, see also \fBI\fP.
.TP
.B "RB [roman-text [bold-text [roman-text [...]]]"
Roman-bold.
Even arguments is printed in roman, odd in boldface.
See \fBI\fP.
.TP
.B "RD [prompt [diversion [string]]]"
Read from standard input to diversion and/or string.
The text will be saved in a diversion named \fIdiversion\fP.
Recall the text by writing the name of the diversion after a dot
on an empty line. A string will also be defined if
\fIstring\fP is given. \fIDiversion\fP and/or \fIprompt\fP can 
be empty ("").
.TP
.B RF
Reference end. Ends a reference definition and returns to normal
processing. See \fBRS\fP.
.TP
.B "RI [roman-text [italic-text [roman-text [...]]]"
Even arguments is printed in roman, odd in italic.
See \fBI\fP.
.TP
.B "RL [text-indent [1]]"
Reference list start
Begins a list where each item is preceded with a automatically
incremented number between
square brackets.
\fIText-indent\fP changes the default indentation
.TP
.B "RP [arg1 [arg2]]"
Produce reference page.
\fBRP\fP can be used if a reference page is wanted somewhere in the
document. It is not needed if \fBTC\fP is used to produce
a table of content. The reference page will then be printed automatically.
.sp
The reference counter will not be resetted if \fIarg1\fP is 1.
.sp
\fIArg2\fP tells \fBRP\fP whether to eject a page or not.
.br
\fBArg2\fP
.in +.5i
.T2 0
The reference page will be printed on a separate page.
This is
the default.
.T2 1
Do not eject page after the list.
.T2 2
Do not eject page before the list.
.T2 3
Do not eject page before and after the list.
.in
The reference items will be separated by a blank line.
Setting number register \fBLs\fP to 0 will suppress the line.
.sp
The string \fBRp\fP contains the reference page title and
is normally set to \fIREFERENCES\fP.
.TP
.B "RS [string-name]"
\fBRS\fP begins an automatically numbered reference definition.
Put the string \fB\e*(Rf\fP where the reference mark
should be and write the reference between \fBRS\fP/\fBRF\fP
at next new line after the reference mark. The reference number
is stored in number register \fB:R\fP.
If \fIstring-name\fP is given, a string with that name
will be defined and contain the current reference mark.
The string can be referenced as \fB\e*[\fIstring-name\fP]\fP later in
the text.
.TP
.B "S [size [spacing]]"
Set point size and vertical spacing. If any argument is equal 'P', then
the previous value is used. A 'C' means current value, and 'D' default value.
If '+' or '-' is used before the value, then increment or decrement of
the current value will be done.
.TP
.B "SA [arg]"
Set right-margin justification.
Justification is normally turned on.
No argumenent or \fB0\fP turns off justification, a \fB1\fP turns on
justification.
.TP
.B "SETR refname [string]"
Remember the current header and page-number as refname.
Saves \fIstring\fP if \fIstring\fP is defined. \fIstring\fP is retrieved
with \fB.GETST\fP.
See \fBINITR\fP.
.TP
.B "SG [arg [1]]"
Signature line. Prints the authors name(s) after the formal closing.
The argument will be appended to the reference data, printed
at either the first or last author. The reference data is the location,
department and initials specified with \fB.AU\fP.
It will be printed at the first author, otherwise at the last.
No reference data will be printed if the author(s) is specifed
thru \fB.WA\fP/\fB.WE\fP.
See \fBLetter internals\fP.
.TP
.B "SK [pages]"
Skip pages.
If \fIpages\fP is \fB0\fP or omitted, a skip to the next page
will occur unless it is already at the top of a page.
Otherwise it will skip \fIpages\fP pages.
.TP
.B "SM string1 [string2 [string3]]"
Make a string smaller.
If \fIstring2\fP is given, \fIstring1\fP will be smaller and \fIstring2\fP
normal, concatenated with \fIstring1\fP. With three argument, all is
concatenated, but only \fIstring2\fP is made smaller.
.TP
.B "SP [lines]"
Space vertically. \fIlines\fP can have any scalingfactor, like \fI3i\fP or
\fI8v\fP. Several \fBSP\fP in a line will only produce the
maximum number of lines, not the sum. \fBSP\fP will also be ignored
until the first textline in a page. Add a \fB\e&\fP before \fBSP\fP
to avoid this.
.TP
.B TAB
reset tabs to every 5n. Normally used to reset any previous tabpositions.
.TP
.B "TB [title [override [flag [refname]]]]"
Table title.
If \fIrefname\fP is used, then the tablenumber is saved with
\&\fB.SETR\fP, and can be retrieved with \fB.GETST\fP \fIrefname\fP.
.TP
.B "TC [slevel [spacing [tlevel [tab [h1 [h2 [h3 [h4 [h5]]]]]]]]]"
Table of contents.
This macro is normally used at the last line of the document.
It generates a table of contents with headings up to the level
controlled by number register \fBCl\fP. Note that \fBCl\fP controls
the saving of headings, it has nothing to do with \fBTC\fP.
Headings with level less than or equal to \fIslevel\fP will get
\fIspacing\fP number of lines before them.
Headings with level less than or equal to \fItlevel\fP will have
their page numbers right justified with dots or spaces separating
the text and the page number. Spaces is used if \fItab\fP
is greater than zero, otherwise dots.
Other headings will have the
page number directly at the end of the heading text (\fIragged right\fP).
.sp
The rest of the arguments will be printed, centered, before the
table of contents.
.sp
The user-defined macros \fBTX\fP and \fBTY\fP are used if \fBTC\fP is called
with at most four arguments. \fBRX\fP is called before the printing
of \fICONTENTS\fP, and \fBTY\fP is called instead of printing \fICONTENTS\fP.
.sp
String \fBCi\fP can be set to control the indentations for each heading-level.
It must be scaled, like \fB.ds\ Ci\ .25i\ .5i\ .75i\ 1i\ 1i\fP.
The indentation is normally controlled by the maxlength of headings
in each level.
.sp
All texts can be redefined, new stringvariables 
\fILifg\fP, \fILitb\fP, \fILiex\fP, \fILiec\fP and \fILicon\fP contains
"Figure", "TABLE", "Exhibit", "Equation" and "CONTENTS".
These can be redefined to other languages.
.TP
.B TE
Table end. See \fBTS\fP.
.TP
.B "TH [N]"
Table header. See \fBTS\fP.
\fBTH\fP ends the header of the table. This header will
be printed again if a page-break occurs.
Argument \fIN\fP isn't implemented yet.
.TP
.B TL [charging-case number(s) [filing-case number(s)]
Begin title of memorandum.
All text up to the next \fBAU\fP is included in the title.
\fICharging-case number\fP and \fIfiling-case\fP is saved
for use in the front page processing.
.TP
.B TM [num1 [num2 [...]]]
Technical memorandumnumbers used in \fB.MT\fP. Unlimited number
of arguments may be given.
.TP
.B TP
Top of page user-defined macro.
This macro is called instead of the normal page header. It is
possible to get complete control over the header.
Note that header and footer is printed in a separate environment.
Linelength is preserved though.
.TP
.B "TS [H]"
Table start. This is the start of a table specification
to \fB@TMAC@tbl\fP. See separate manual for \fB@TMAC@tbl\fP.
\fBTS\fP ends with \fBTE\fP.
Argument \fIH\fP tells \fBm@TMAC@m\fP that the table
has a header. See \fBTH\fP.
.TP
.B TX
Userdefined table of contents exit.
This macro is called just before \fBTC\fP prints the word \fICONTENTS\fP.
See \fBTC\fP.
.TP
.B TY
Userdefined table of contents exit (no "CONTENTS").
This macro is called instead of printing \fICONTENTS\fP.
See \fBTC\fP.
.TP
.B VERBON [flag [pointsize [font]]]
Begin verbatim output using courier font.
Usually for printing programs.
All character has equal width.
The pointsize can be changed with
the second argument. By specifying the font-argument
it is possible to use another font instead of courier.
\fIflag\fP control several special features.
It contains the sum of all wanted features.
.in +.5i
.T2 Value
Description
.T2 1
Disable the escape-character (\e). This is normally turned on during
verbose output.
.T2 2
Add en empty line before the verbose text.
.T2 4
Add en empty line after the verbose text.
.T2 8
Print the verbose text with numbered lines. This adds four digitsized
spaces in the beginning of each line. Finer control is available with
the string-variable \fBVerbnm\fP. It contains all arguments to the
\fBtroff\fP-command \fB.nm\fP, normally '1'.
.T2 16
Indent the verbose text with five 'n':s. This is controlled by the
number-variable \fBVerbin\fP (in units).
.in
.TP
.B VERBOFF
End verbatim output.
.TP
.B "VL text-indent [mark-indent [1]]"
Variable-item list has no fixed mark, it assumes that
every \fBLI\fP have a mark instead.
\fIText-indent\fP sets the indent to the text, and \fImark-indent\fP
the distance from the current indent to the mark.
A third argument will prohibit printing of a blank line before each
item.
.TP
.B "VM [top [bottom]]"
Vertical margin.
.TP
.B "WA [writer-name [title]]
Begins specification of the writer and writer's address.
Several names can be specified with empty \fBWA\fP/\fBWE\fP-pairs, but
only one address.
.TP
.B WE
Ends the address-specification after \fP.WA\fP.
.TP
.B "WC [format]"
Footnote and display width control.
.in +.5i
.T2 N
Set default mode, \fB-WF\fP, \fB-FF\fP, \fB-WD\fP and \fBFB\fP.
.T2 WF
Wide footnotes, wide also in two-column mode.
.T2 -WF
Normal footnote width, follow column mode.
.T2 FF
All footnotes gets the same width as the first footnote encountered.
.T2 -FF
Normal footnotes, width follows \fBWF\fP and \fB-WF\fP.
.T2 WD
Wide displays, wide also in two-column mode.
.T2 -WD
Normal display width, follow column mode.
.T2 FB
Floating displays generates a line break when printed on the current page.
.T2 -FB
Floating displays does not generate line break.
.in
.sp 3
.LP
.\"########################################################################
.LP
.B "Strings used in m@TMAC_M_PREFIX@m:"
.TP
.B App
A string containing the word "APPENDIX".
.TP
.B "EM"
Em dash string
.TP
.B HF
Fontlist for headings, normally "2 2 2 2 2 2 2".
Nonnumeric fontnames may also be used.
.TP
.B HP
Pointsize list for headings. Normally "0 0 0 0 0 0 0" which is the same as
"10 10 10 10 10 10 10".
.TP
.B Lifg
String containing \fIFigure\fP.
.TP
.B Litb
String containing \fITABLE\fP.
.TP
.B Liex
String containing \fIExhibit\fP.
.TP
.B Liec
String containing \fIEquation\fP.
.TP
.B Licon
String containing \fICONTENTS\fP.
.TP
.B Lf
Contains "LIST OF FIGURES".
.TP
.B Lt
Contains "LIST OF TABLES".
.TP
.B Lx
Contains "LIST OF EXHIBITS".
.TP
.B Le
Contains "LIST OF EQUATIONS".
.TP
.B Letfc
Contains "Yours very truly,", used in \fB.FC\fP.
.TP
.B Letapp
Contains "APPROVED:", used in \fB.AV.\fP.
.TP
.B Letdate
Contains "Date", used in \fB.AV.\fP.
.TP
.B LetCN
Contains "CONFIDENTIAL", used in \fB.LO CN\fP.
.TP
.B LetSA
Contains "To Whom It May Concern:", used in \fB.LO SA\fP.
.TP
.B LetAT
Contains "ATTENTION:", used in \fB.LO AT\fP.
.TP
.B LetSJ
Contains "SUBJECT:", used in \fB.LO SJ\fP.
.TP
.B LetRN
Contains "In reference to:", used in \fB.LO RN\fP.
.TP
.B Letns
is an array containing the different strings used in \fB.NS\fP.
It is really a number of stringvariables prefixed with \fBLetns!\fP.
If the argument doesn't exist, it will be included
between \fB()\fP with \fBLetns!copy\fP as prefix and \fBLetns!to\fP as suffix.
Observe the space after \fBcopy\fP and before \fBto\fP.
.nf
.ta 1.5i
\fBName	Value\fP
Letns!0	Copy to
Letns!1	Copy (with att.) to
Letns!2	Copy (without att.) to
Letns!3	Att.
Letns!4	Atts.
Letns!5	Enc.
Letns!6	Encs.
Letns!7	Under separate cover
Letns!8	Letter to
Letns!9	Memorandum to
Letns!10	Copy (with atts.) to
Letns!11	Copy (without atts.) to
Letns!12	Abstract Only to
Letns!13	Complete Memorandum to
Letns!14	CC
Letns!copy	Copy "
Letns!to	" to
.fi
.TP
.B Letnsdef
Defines the standard-notation used when no argument is given
to \fB.NS\fP. Default is \fB0\fP.
.TP
.B "MO1 - MO12"
Strings containing \fIJanuary\fP thru \fIDecember\fP.
.TP
.B Qrf
String containing "See chapter \e\e*[Qrfh], page \e\en[Qrfp].".
.TP
.B Rp
Contains "REFERENCES".
.TP
.B Tm
Contains \e(tm, trade mark.
.TP
.B Verbnm
Argument to \fB.nm\fP in \fB.VERBON\fP, default: \fB1\fP.
.\"-----------------------------------
.LP
.B "Number variables used in m@TMAC_M_PREFIX@m:"
.TP
.B Aph
Print an appendix-page for every new appendix 
if this numbervariable is non-zero.
No output will occur if \fBAph\fP is zero, but there will always
be an appendix-entry in the 'List of contents'.
.TP
.B Cl
Contents level [0:7], contents saved if heading level <= Cl, default 2.
.TP
.B Cp
Eject page between LIST OF XXXX if Cp == 0, default 0.
.TP
.B D
Debugflag, values >0 produces varying degree of debug. A value of 1
gives information about the progress of formatting, default 0.
.TP
.B De
Eject after floating display is output [0:1], default 0.
.TP
.B Df
Floating keep output [0:5], default 5.
.TP
.B Ds
space before and after display if == 1 [0:1], default 1.
.TP
.B Ej
Eject page, default 0.
.TP
.B Eq
Equation lable adjust 0=left, 1=right. Default 0.
.TP
.B Fs
Footnote spacing, default 1.
.TP
.B "H1-H7"
Heading counters
.TP
.B Hb
Heading break level [0:7], default 2.
.TP
.B Hc
Heading centering level, [0:7]. Default 0.
.TP
.B Hi
Heading temporary indent [0:2], default 1.
.br
0\ ->\ 0 indent, left margin
.br
1\ ->\ indent to right , like .P 1
.br
2\ ->\ indent to line up with text part of preceding heading
.TP
.B Hps
Numbervariable with the heading pre-space level. If the heading-level
is less than or equal to \fBHps\fP, then two lines will precede the
section heading instead of one. Default is first level only.
The real amount of lines is controlled by the variables \fBHps1\fP and
\fBHps2\fP.
.TP
.B Hps1
This is the number of lines preceding \fB.H\fP when the heading-level
is greater than \fBHps\fP. Value is in units, normally 0.5v.
.TP
.B Hps2
This is the number of lines preceding \fB.H\fP when the heading-level
is less than or equal to \fBHps\fP. Value is in units, normally 1v.
.TP
.B Hs
Heading space level [0:7], default 2.
.TP
.B Ht
Heading numbering type, default 0.
0 -> multiple (1.1.1 ...)
.br
1 -> single
.TP
.B Hu
Unnumbered heading level, default 2.
.TP
.B Hy
Hyphenation in body, default 1.
.br
0\ ->\ no hyphenation
.br
1\ ->\ hyphenation 14 on
.TP
.B Letwam
Max lines in return-address, used in \fB.WA\fP/\fB.WE\fP. Default 14.
.TP
.B "Lf, Lt, Lx, Le"
Enables (1) or disables (0) the printing of List of figures,
List of tables, List of exhibits and List of equations.
Default: Lf=1, Lt=1, Lx=1, Le=0.
.TP
.B Li
List indent, used by .AL, default 6.
.TP
.B Ls
List space, if current listlevel > Ls then no spacing will occur around lists.
Default 99.
.TP
.B Lsp
.TP
The size of an empty line. Normally 0.5v, but it is 1v 
if \fBn\fP is set (\fB.nroff\fP).
.TP
.B N
Numbering style [0:5], default 0.
.br
0\ ==\ (default) normal header for all pages.
.br
1\ ==\ header replaces footer on first page, header is empty.
.br
2\ ==\ page header is removed on the first page.
.br
3\ ==\ "section-page" numbering enabled.
.br
4\ ==\ page header is removed on the first page.
.br
5\ ==\ "section-page" and "section-figure" numbering enabled.
Se also the number-register Sectf and Sectp.
.TP
.B Np
Numbered paragraphs, default 0.
.br
0\ ==\ not numbered
.br
1\ ==\ numbered in first level headings.
.TP
.B Of
Format of figure,table,exhibit,equation titles, default 0.
.br
0\ =\ ". "
.br
1\ =\ " - "
.TP
.B P
Current page-number, normally the same as % unless "section-page" numbering
is enabled.
.TP
.B Pi
paragraph indent, default 5.
.TP
.B Pgps
Controls whether header and footer pointsize should follow the current
setting or just change when the header and footer is defined.
.in +.5i
.ti -.5i
.T2 Value
Description
.T2 0
Pointsize will only change to the current setting when \fB.PH\fP, \fB.PF\fP,
\&\fB.OH\fP, \fP.EH\fP, \fB.OF\fP or \fB.OE\fP is executed.
.T2 1
Pointsize will change after every \fB.S\fP. This is the default.
.in
.TP
.B Ps
paragraph spacing, default 1.
.TP
.B Pt
Paragraph type, default 0.
.br
0\ ==\ left-justified
.br
1\ ==\ indented .P
.br
2\ ==\ indented .P except after .H, .DE or .LE.
.TP
.B Sectf
Flag controlling "section-figures". A non-zero value enables this.
Se also register N.
.TP
.B Sectp
Flag controlling "section-page-numbers". A non-zero value enables this.
Se also register N.
.TP
.B Si
Display indent, default 5.
.TP
.B Verbin
Indent for \fB.VERBON\fP, default 5n.
.TP
.B .mgm
Always 1.
.LP
.SH INTERNALS
The letter macros is using different submacros depending on
the letter type. The name of the submacro has the letter type
as suffix. It is therefore possible to define other letter types, either
in the national macro-file, or as local additions.
\&\fB.LT\fP will set the number variables \fBPt\fP and \fBPi\fP to 5 and 0.
The following strings and macros must be defined for a new letter type:
.TP
\fBlet@init_\fP\fItype\fP
This macro is called directly by \fB.LT\fP. It is supposed to initialize
variables and other stuff.
.TP
\fBlet@head_\fP\fItype\fP
This macro prints the letter head, and is called instead of the
normal page header. It is supposed to remove the alias \fBlet@header\fP,
otherwise it will be called for all pages.
.TP
\fBlet@sg_\fP\fItype\ name\ title\ n\ flag\ [arg1\ [arg2\ [...]]]\fP
\&\fB.SG\fP is calling this macro only for letters, memorandums has
its own processing. \fIname\fP and \fItitle\fP is specified
thru \fB.WA\fP/\fB.WB\fP. \fIn\fP is the counter, 1-max, and
\fIflag\fP is true for the last name. Any other argument to \fB.SG\fP
is appended.
.TP
\fBlet@fc_\fP\fItype\ closing\fP
This macro is called by \fB.FC\fP, and has the
formal closing as argument.
.LP
\&\fB.LO\fP is implemented as a general option-macro. \fB.LO\fP demands
that a string named \fBLet\fP\fItype\fP is defined, where \fItype\fP
is the letter type.
\&\fB.LO\fP will then assign the argument to the string
variable \fBlet*lo-\fP\fItype\fP.
.LP
.\".SH BUGS
.SH AUTHOR
Jrgen Hgg, Lund, Sweden <jh@axis.se>.
.SH FILES
.TP
.B @MACRODIR@/tmac.@TMAC_M_PREFIX@m
.TP
.B @TMAC_MDIR@/*.cov
.TP
.B @TMAC_MDIR@/*.MT
.TP
.B @TMAC_MDIR@/locale
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@tbl (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@)
.br
.BR mm (@MAN7EXT@)
.BR m@TMAC_M_PREFIX@mse (@MAN7EXT@)
