#	BSDI bsd.lib.mk,v 2.3 1995/11/20 23:28:56 bostic Exp
#
#	@(#)bsd.lib.mk	8.3 (Berkeley) 4/22/94

.if exists(${.CURDIR}/../Makefile.inc)
.include "${.CURDIR}/../Makefile.inc"
.endif

LIBDIR?=	/usr/lib
LINTLIBDIR?=	/usr/libdata/lint
LIBGRP?=	bin
LIBOWN?=	bin
LIBMODE?=	444

COPY?=	-c
STRIP?=	-s

BINGRP?=	bin
BINOWN?=	bin
BINMODE?=	555

MKDEP?=	mkdep

.MAIN: all

# prefer .s to a .c, add .po, remove stuff not used in the BSD libraries
.SUFFIXES:
.SUFFIXES: .out .o .po .s .c .cc .c++ .cxx .C .f .y .l .8 .7 .6 .5 .4 .3 .2 .1 .0 .m4 .ps

.8.0 .7.0 .6.0 .5.0 .4.0 .3.0 .2.0 .1.0:
	groff -mtty-char -Tascii -man ${.IMPSRC} > ${.TARGET}

.8.ps .7.ps .6.ps .5.ps .4.ps .3.ps .2.ps .1.ps:
	groff -Tps -man ${.IMPSRC} > ${.TARGET}
.c.o:
	${CC} ${CFLAGS} -c ${.IMPSRC}
	@${LD} -x -r ${.TARGET}
	@mv a.out ${.TARGET}

.c.po:
	${CC} -p ${CFLAGS} -c ${.IMPSRC} -o ${.TARGET}
	@${LD} -X -r ${.TARGET}
	@mv a.out ${.TARGET}

.cc.o .c++.o .cxx.o .C.o:
	${C++C} ${C++FLAGS} -c ${.IMPSRC}
	@${LD} -x -r ${.TARGET}
	@mv a.out ${.TARGET}

.cc.po .c++.po .cxx.po .C.po:
	${C++C} -p ${C++FLAGS} -c ${.IMPSRC} -o ${.TARGET}
	@${LD} -X -r ${.TARGET}
	@mv a.out ${.TARGET}

.s.o:
	${CPP} -E ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} | \
	    ${AS} -o ${.TARGET}
	@${LD} -x -r ${.TARGET}
	@mv a.out ${.TARGET}

.s.po:
	${CPP} -E -DPROF ${CFLAGS:M-[ID]*} ${AINC} ${.IMPSRC} | \
	    ${AS} -o ${.TARGET}
	@${LD} -X -r ${.TARGET}
	@mv a.out ${.TARGET}

MANALL=	${MAN1} ${MAN2} ${MAN3} ${MAN4} ${MAN5} ${MAN6} ${MAN7} ${MAN8}
manpages: ${MANALL}
	@: make full rule

.if !defined(NOPROFILE)
_LIBS=lib${LIB}.a lib${LIB}_p.a
.else
_LIBS=lib${LIB}.a
.endif

all: ${_LIBS} # llib-l${LIB}.ln
	@: make full rule
.if !defined(NOMAN)
all: ${MANALL}
.endif

.if (defined(SRCS) && ${SRCS} != "")
OBJS+=	${SRCS:R:S/$/.o/g}
.endif

lib${LIB}.a:: ${OBJS}
	@echo building standard ${LIB} library
	@rm -f lib${LIB}.a
	@${AR} cTq lib${LIB}.a `lorder ${OBJS} | tsort` ${LDADD}
	ranlib lib${LIB}.a

POBJS+=	${OBJS:.o=.po}
lib${LIB}_p.a:: ${POBJS}
	@echo building profiled ${LIB} library
	@rm -f lib${LIB}_p.a
	@${AR} cTq lib${LIB}_p.a `lorder ${POBJS} | tsort` ${LDADD}
	ranlib lib${LIB}_p.a

llib-l${LIB}.ln: ${SRCS}
	${LINT} -C${LIB} ${CFLAGS} ${.ALLSRC:M*.c}

.if !target(clean)
clean:
	rm -f ${OBJS}
	rm -f ${POBJS}
	rm -f a.out [Ee]rrs mklog ${CLEANFILES} \
	    profiled/*.o lib${LIB}.a lib${LIB}_p.a llib-l${LIB}.ln
.endif

.if !target(cleandir)
cleandir:
	rm -f ${OBJS}
	rm -f ${POBJS}
	rm -f a.out [Ee]rrs mklog ${CLEANFILES} \
	    profiled/*.o lib${LIB}.a lib${LIB}_p.a llib-l${LIB}.ln
	rm -f ${MANALL} .depend
.endif

.if !target(depend)
depend: .depend
	@: make full rule
.depend: ${SRCS}
	${MKDEP} ${CFLAGS:M-[ID]*} ${AINC} ${.ALLSRC}
	@(TMP=/tmp/_depend$$$$; \
	    sed -e 's/^\([^\.]*\).o *:/\1.o \1.po:/' < .depend > $$TMP; \
	    mv $$TMP .depend)
.endif

.if !target(install)
.if !target(beforeinstall)
beforeinstall:
	@: make full rule
.endif

realinstall: beforeinstall
	ranlib lib${LIB}.a
	install ${COPY} -o ${LIBOWN} -g ${LIBGRP} -m ${LIBMODE} lib${LIB}.a \
	    ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/lib${LIB}.a
.if !defined(NOPROFILE)
	ranlib lib${LIB}_p.a
	install ${COPY} -o ${LIBOWN} -g ${LIBGRP} -m ${LIBMODE} \
	    lib${LIB}_p.a ${DESTDIR}${LIBDIR}
	${RANLIB} -t ${DESTDIR}${LIBDIR}/lib${LIB}_p.a
.endif
#	install -c -o ${LIBOWN} -g ${LIBGRP} -m ${LIBMODE} \
#	    llib-l${LIB}.ln ${DESTDIR}${LINTLIBDIR}
.if defined(LINKS) && !empty(LINKS)
	@set ${LINKS}; \
	while test $$# -ge 2; do \
		l=${DESTDIR}$$1; \
		shift; \
		t=${DESTDIR}$$1; \
		shift; \
		echo $$t -\> $$l; \
		rm -f $$t; \
		ln $$l $$t; \
	done; true
.endif

install: afterinstall
	@: make full rule
afterinstall: realinstall
	@: make full rule
.if !defined(NOMAN)
afterinstall: maninstall
.endif
.endif

.if !target(lint)
lint:
	@: make full rule
.endif

.if !target(tags)
tags: ${SRCS}
	-ctags -f /dev/stdout ${.ALLSRC:M*.c} | \
	    sed "s;\${.CURDIR}/;;" > ${.CURDIR}/tags
.endif

.include <bsd.man.mk>

OBJDIR?=/usr/obj
STRIPDIR?=/usr/src

.if !target(obj)
.if defined(NOOBJ)
obj:
	@: make full rule
.else
obj:
	@cd ${.CURDIR}; rm -rf obj; \
	here=`pwd`; dest=${OBJDIR}`echo $$here | sed 's,${STRIPDIR},,'`; \
	echo "$$here -> $$dest"; ln -s $$dest obj; \
	if test -d ${OBJDIR} -a ! -d $$dest; then \
		mkdir -p $$dest; \
	else \
		true; \
	fi
.endif
.endif

.if !target(objdir)
.if defined(NOOBJ)
objdir:
	@: make full rule
.else
objdir:
	@cd ${.CURDIR}; \
	if test -h obj; then \
		here=`pwd`; objlnk=`ls -l obj | sed 's/.* //'`; \
		echo "$$here -> $$objlnk"; \
		if test ! -d $$objlnk; then \
			mkdir -p $$objlnk; \
		else \
			true; \
		fi; \
	else \
		true; \
	fi
.endif
.endif
