/*	BSDI shm.h,v 2.1 1995/02/03 15:16:35 polk Exp	*/

#ifndef _SHM_H_
#define	_SHM_H_

/*
 * iBCS2 shared memory definitions
 */

/* iBCS2 p 6-48 */

struct shmid_ds {
	struct ipc_perm	shm_perm;
	int		shm_segsz;
	void		*shm_reg;
	char		pad[4];
	unsigned short	shm_lpid;
	unsigned short	shm_cpid;
	unsigned short	shm_nattch;
	unsigned short	shm_cnattch;
	long		shm_atime;
	long		shm_dtime;
	long		shm_ctime;
};

#define	SHM_RDONLY	0x1000
#define	SHM_RND		0x2000

#define	SHMLBA		0x00400000

#include <sys/cdefs.h>

void *shmat __P((int, void *, int));
int shmctl __P((int, int, ...));
int shmdt __P((void *));
int shmget __P((key_t, int, int));

#endif /* _SHM_H_ */
