/*	BSDI sem.h,v 2.2 1995/12/19 22:47:08 donn Exp	*/

#ifndef _SEM_H_
#define	_SEM_H_

/*
 * iBCS2 semaphore definitions
 */

/* from iBCS2 p 6-47 */

struct sem {
	unsigned short	semval;
	short		sempid;
	unsigned short	semncnt;
	unsigned short	semzcnt;
	unsigned short	_semseq;	/* BSD/386 hack */
};

struct sembuf {
	unsigned short	sem_num;
	short		sem_op;
	short		sem_flg;
};

struct semid_ds {
	struct ipc_perm	sem_perm;
	struct sem	*sem_base;
	unsigned short	sem_nsems;
	long		sem_otime;
	long		sem_ctime;
};

union semun {
	int		val;
	struct semid_ds	*buf;
	unsigned short	*array;
};

/* Compatibility... */
#ifndef EIDRM
#define	EIDRM		EINVAL
#endif

#define	SEM_UNDO	0x1000

#define	GETNCNT		3
#define	GETPID		4
#define	GETVAL		5
#define	GETALL		6
#define	GETZCNT		7
#define	SETVAL		8
#define	SETALL		9

#include <sys/cdefs.h>

int semctl __P((int, int, int, ...));
int semget __P((key_t, int, int));
int semop __P((int, struct sembuf *, size_t));

#endif /* _SEM_H_ */
