/*	BSDI msg.h,v 2.4 1996/01/08 03:22:33 donn Exp	*/

#ifndef _MSG_H_
#define	_MSG_H_

/* from iBCS2, p 6-43 */
/* XXX the SVr4 ABI gives different structure, with longs instead of shorts */
struct msqid_ds {
	struct ipc_perm	msg_perm;
	struct msg	*msg_first;
	struct msg	*msg_last;
	unsigned short	msg_cbytes;
	unsigned short	msg_qnum;
	unsigned short	msg_qbytes;
	unsigned short	msg_lspid;
	unsigned short	msg_lrpid;
	long		msg_stime;
	long		msg_rtime;
	long		msg_ctime;
};

#define	MSG_NOERROR 	0x1000

/* I have no idea what the TS and SPOT fields are for... */
struct msg {
	struct msg	*msg_next;
	long		msg_type;
	short		msg_ts;
	short		msg_spot;
};

/*
 * Apparently System V msg.h also defines this structure,
 * although it does not appear in the ABI.
 */
struct msgbuf {
	long		mtype;
	char		mtext[1];
};

/* XXX compatibility */
#define	ENOMSG		EAGAIN
#ifndef EIDRM
#define	EIDRM		EINVAL
#endif

#include <sys/cdefs.h>

int msgctl __P((int, int, ...));
int msgget __P((key_t, int));
int msgrcv __P((int, void *, size_t, long, int));
int msgsnd __P((int, const void *, size_t, int));

#endif /* _MSG_H_ */
