/*	BSDI ipc.h,v 2.1 1995/02/03 15:16:24 polk Exp	*/

#ifndef _IPC_H_
#define	_IPC_H_

/*
 * iBCS2 IPC definitions for message queue, semaphore and shared memory ops
 */

/* from iBCS2 p6-39 */

struct ipc_perm {
	unsigned short	uid;
	unsigned short	gid;
	unsigned short	cuid;
	unsigned short	cgid;
	unsigned short	mode;
	unsigned short	seq;
	long		key;
};

/* IPC flags */
#define	IPC_CREAT	0x0200
#define	IPC_EXCL	0x0400
#define	IPC_NOWAIT	0x0800

/* ctl() cookies */
#define	IPC_RMID	0
#define	IPC_SET		1
#define	IPC_STAT	2

/* distinguished key */
#define	IPC_PRIVATE	0L

/* from iBCS2 p6-81 */
typedef long 		key_t;

#endif /* _IPC_H_ */
