/*
 * Copyright (c) 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sco_ipc_conf.c,v 2.2 1995/12/19 22:49:28 donn Exp
 */

/*
 * Various tables used by common IPC support code
 * to handle features of specific IPC modalities.
 */

#include <sys/param.h>

#include "sco_ipc.h"

#define	NIPC		3

struct ipc_chain *__ipc_chains[NIPC];
const char *__ipc_name[NIPC] = { "shm", "sem", "msg" };
const int __ipc_sizes[NIPC] = {
	sizeof (struct shmid_ds),
	sizeof (struct semid_ds),
	sizeof (struct msqid_ds),
};

int (*__ipc_check[NIPC]) __P((struct ipc_chain *, int, int, void *)) = {
	0,
	__ipc_sem_check,
	0,
};

int (*__ipc_init[NIPC]) __P((struct ipc_chain *, int, int, int)) = {
	__ipc_shm_init,
	__ipc_sem_init,
	__ipc_msg_init,
};

void (*__ipc_remove_wakeup[NIPC]) __P((struct ipc_chain *)) = {
	0,
	__ipc_sem_remove,
	__ipc_msg_remove,
};

int (*__ipc_work[NIPC]) __P((struct ipc_chain *, int, int, void *)) = {
	__ipc_shm_work,
	__ipc_sem_work,
	__ipc_msg_work,
};
