/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char copyright[] = "Copyright (c) 1990 Regents of the University of California.\nAll rights reserved.\n";
static char SccsId[] = "@(#)@(#)pop_updt.c	2.3  2.3 3/20/91";
#endif 

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef SYSV
# include <string.h>
# include <unistd.h>
# include "flock.h"
#else
# include <strings.h>
#endif
#include <sys/stat.h>
#include <sys/file.h>
#include "popper.h"

#ifdef MAILOCK
# include <maillock.h>
#endif

#if defined(SYSV) && !defined(L_XTND)
#define L_XTND SEEK_END
#endif
#if defined(SYSV) && !defined(L_SET)
#define L_SET SEEK_SET
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

extern int      errno;

static char standard_error[] =
    "Error error updating primary drop. Mailbox unchanged";

/* 
 *  updt:   Apply changes to a user's POP maildrop
 */

int pop_updt (p)
POP     *   p;
{
    FILE                *   md;                     /*  Stream pointer for 
                                                        the user's maildrop */
    int                     mfd;                    /*  File descriptor for
                                                        above */
    char                    buffer[MAXLINELEN];     /*  Read buffer */

    char		    uidl_buf[128];	    /*  UIDL header */
    MsgInfoList         *   mp;                     /*  Pointer to message 
                                                        info list */
    register int            msg_num;                /*  Current message 
                                                        counter */
    register int            status_written;         /*  Status header field 
                                                        written */
    int			    uidl_hdr_len;
    int			    uidl_put;
    int                     nchar;                  /* Bytes read/written */

    OFF_T                   offset;                 /* New mail offset */

    char		*   result;		    /* fget and fputs status */

#ifdef DEBUG
    if (p->debug) {
        pop_log(p,POP_DEBUG,"Performing maildrop update...");
        pop_log(p,POP_DEBUG,"Checking to see if all messages were deleted");
    }
#endif

    if (p->stats) {
        pop_log(p,POP_PRIORITY,"Stats: %s %d %d %d %d",
           p->user, p->msgs_deleted, p->bytes_deleted,
           p->msg_count - p->msgs_deleted,
           p->drop_size - p->bytes_deleted);
    }

    if (p->msgs_deleted == p->msg_count) {
	/* Truncate before close, to avoid race condition,  DO NOT UNLINK!
	   Another process may have opened,  and not yet tried to lock */
	(void)ftruncate (fileno(p->drop), (OFF_T)0);
#ifndef KEEP_TEMP_DROP
	/* Added code in pop_dropcopy.c makes unlink ok now. */
	/* s-dorner@uiuc.edu, 12/91 */
	(void)unlink(p->temp_drop);
#endif
	(void)fclose(p->drop);
        return (POP_SUCCESS);
    }

#ifdef DEBUG
    if (p->debug) 
        pop_log(p,POP_DEBUG,"Opening mail drop \"%s\"",p->drop_name);
#endif

#ifdef MAILOCK
    /* Use SVR4 mail locking */
    if (maillock(p->user, 1) != 0)
	return(pop_msg(p, POP_FAILURE, "maillock: '%s'", p->temp_drop));
#endif

    /*  Open the user's real maildrop */
    if ((mfd = open(p->drop_name,O_RDWR|O_CREAT,0660)) == -1 ||
        (md = fdopen(mfd,"r+")) == NULL) {
#ifdef MAILOCK
	mailunlock();
#endif
        return pop_msg(p,POP_FAILURE,standard_error);
    }

    /*  Lock the user's real mail drop */
    if ( flock(mfd,LOCK_EX) == -1 )
    {
        (void)fclose(md) ;
#ifdef MAILOCK
	mailunlock();
#endif
        return pop_msg(p,POP_FAILURE, "flock: '%s': %s", p->temp_drop,
            (errno < sys_nerr) ? sys_errlist[errno] : "");
    }

    /* Go to the right places */
    offset = lseek(fileno(p->drop), (OFF_T)0, L_XTND) ; 

    /*  Append any messages that may have arrived during the session 
        to the temporary maildrop */
    while ((nchar=read(mfd,buffer,MAXLINELEN)) > 0)
        if ( nchar != write(fileno(p->drop),buffer,nchar) ) {
            nchar = -1;
            break ;
        }
    if ( nchar != 0 ) {
        (void)fclose(md) ;
#ifdef MAILOCK
	mailunlock();
#endif
        (void)ftruncate(fileno(p->drop), (OFF_T)offset) ;
        (void)fclose(p->drop) ;
        return pop_msg(p,POP_FAILURE,standard_error);
    }

    rewind(md);
    (void)ftruncate(mfd, (OFF_T)0) ;

    /* Synch stdio and the kernel for the POP drop */
    rewind(p->drop);
    (void)lseek(fileno(p->drop), (OFF_T)0, L_SET);

    /*  Transfer messages not flagged for deletion from the temporary 
        maildrop to the new maildrop */
#ifdef DEBUG
    if (p->debug) 
        pop_log(p,POP_DEBUG,"Creating new maildrop \"%s\" from \"%s\"",
                p->drop_name,p->temp_drop);
#endif

    uidl_hdr_len = strlen(MSGUIDL);

    for (msg_num = 0; msg_num < p->msg_count; ++msg_num) {

        int inheader;
	int body_lines;

        /*  Get a pointer to the message information list */
        mp = &p->mlp[msg_num];

        if (mp->del_flag) {
#ifdef DEBUG
            if(p->debug)
                pop_log(p,POP_DEBUG,
                    "Message %d flagged for deletion.",mp->number);
#endif
            continue;
        }

        (void)fseek(p->drop, (OFF_T)mp->offset,0);

#ifdef DEBUG
        if(p->debug)
            pop_log(p,POP_DEBUG,"Copying message %d.",mp->number);
#endif
	uidl_put = 0;
        for(status_written=0,inheader=1; fgets(buffer,MAXMSGLINELEN,p->drop);) {

            if (inheader) { /* Header */

		/*  A blank line signals the end of the header. */
		if (*buffer == '\n') {
                    if (status_written == 0) {
                        if (mp->retr_flag)
			    sprintf(buffer, "Status: RO\n\n");
                        else
			    sprintf(buffer, "Status: U\n\n");
		    }

                    inheader = 0;
		    uidl_put = 0;
		    body_lines = 1;

                } else if (!uidl_put && !strncasecmp(buffer, "From:", 5)) {
		    sprintf(uidl_buf, "%s %s", MSGUIDL, mp->uidl_str);
		    if (fputs(uidl_buf, md) == EOF)
			break;
		    uidl_put++;

                } else if (!strncasecmp(buffer, MSGUIDL, uidl_hdr_len)) {
		    continue;	/* Skip all existing UIDL lines */

                } else if (!strncasecmp(buffer,"Status:",7)) {
		    /*  Update the message status */
                    if (mp->retr_flag)
			sprintf(buffer, "Status: RO\n");
                    status_written++;
		}
                /*  Save another header line */
                if (fputs(buffer, md) == EOF)
		    break;

            } else { /* Body */ 
		if (++body_lines > mp->body_lines)
		    break;
		if (fputs(buffer, md) == EOF)
		    break;
            }
        }

	if (p->mmdf_separator) {
	    fputs(p->mmdf_separator, md);
	}
    }

    /* flush and check for errors now!  The new mail will writen
       without stdio,  since we need not separate messages */

    if (ferror(md)) {
        (void)ftruncate(mfd, (OFF_T)0) ;
        (void)fclose(md) ;
#ifdef MAILOCK
	mailunlock();
#endif
        (void)fclose(p->drop) ;
        return pop_msg(p,POP_FAILURE,standard_error);
    }

    (void)fflush(md) ;
    if (ferror(md)) {
        (void)ftruncate(mfd, (OFF_T)0) ;
        (void)fclose(md) ;
#ifdef MAILOCK
	mailunlock();
#endif
        (void)fclose(p->drop) ;
        return pop_msg(p,POP_FAILURE,standard_error);
    }

    /* Go to start of new mail if any */
    (void)lseek(fileno(p->drop), (OFF_T)offset, L_SET);

    /* Copy over any new mail that arrived while processing the pop drop */
    while((nchar=read(fileno(p->drop),buffer,MAXLINELEN)) > 0)
        if ( nchar != write(mfd,buffer,nchar) ) {
            nchar = -1;
            break ;
        }
    if ( nchar != 0 ) {
        (void)ftruncate(mfd, (OFF_T)0) ;
        (void)fclose(md) ;
#ifdef MAILOCK
	mailunlock();
#endif
        (void)fclose(p->drop) ;
        return pop_msg(p,POP_FAILURE,standard_error);
    }

    /*  Close the maildrop and empty temporary maildrop */
    (void)fclose(md);
#ifdef MAILOCK
	mailunlock();
#endif
    (void)ftruncate(fileno(p->drop), (OFF_T)0);
#ifndef KEEP_TEMP_DROP
    /* Added code in pop_dropcopy.c makes unlink ok now. */
    /* s-dorner@uiuc.edu, 12/91 */
    (void)unlink(p->temp_drop);
#endif
    (void)fclose(p->drop);

    return(pop_quit(p));
}

