/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI login_reject.c,v 1.1 1995/09/29 19:17:01 prb Exp
 */
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <sys/wait.h>

#include <err.h>
#include <pwd.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <stdarg.h>

extern char *__progname;

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct passwd *pwd;
	char passbuf[_PASSWORD_LEN+1];
    	char *username = 0;
    	char *instance;
	char *ftp = 0;
	char *p;
    	int c;
	struct rlimit rl;

	rl.rlim_cur = 0;
	rl.rlim_max = 0;
	(void)setrlimit(RLIMIT_CORE, &rl);

	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)setpriority(PRIO_PROCESS, 0, 0);

	openlog("login", LOG_ODELAY, LOG_AUTH);

    	while ((c = getopt(argc, argv, "s:")) != EOF)
		switch(c) {
		case 's':	/* service */
			if (strcmp(optarg, "login") == 0)
				ftp = 0;
			else if (strcmp(optarg, "ftp") == 0)
				ftp = "ftp";
			else {
				syslog(LOG_ERR, "%s: invalid service for %s",
				    optarg, __progname);
				exit(1);
			}
			break;
		default:
			syslog(LOG_ERR, "usage error for %s", __progname);
			exit(1);
		}

	switch(argc - optind) {
	case 2:
	case 1:
		username = argv[optind];
		break;
	default:
		syslog(LOG_ERR, "usage error for %s", __progname);
		exit(1);
	}

	/*
	 * .root instances in passwd is just the root account.
	 * all other instances will fail.
	 */
	instance = strchr(username, '.');
	if (instance && strcmp(instance+1, "root") == 0)
		username = instance + 1;

	if (ftp) {
		printf("Password required for %s.\n", username);
		fflush(stdout);

		if (fgets(passbuf, sizeof(passbuf), stdin) == NULL)
			exit(1);
		p = passbuf;
	} else
		p = getpass("Password:");

	crypt(p, "xx");
	exit(1);
}
