/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI dlerror.c,v 1.1 1995/10/09 19:23:13 donn Exp
 */

#include <sys/types.h>
#include <a.out.h>
#include <dlfcn.h>
#include <errno.h>
#include <string.h>

#include "dl.h"

static char dl_errbuf[128];
static int dl_set;

void
dl_err(s)
	const char *s;
{
	int save_errno = errno;

	strcpy(dl_errbuf, s);
	if (save_errno) {
		strcat(dl_errbuf, ": ");
		strcat(dl_errbuf, strerror(save_errno));
	}
	dl_set = 1;
}

void
dl_errx(s)
	const char *s;
{

	errno = 0;
	dl_err(s);
}

char *
dlerror()
{

	if (dl_set == 0)
		return (0);
	dl_set = 0;

	return (dl_errbuf);
}
