/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sigtramp.c,v 1.1 1995/12/18 21:50:49 donn Exp
 */

#include <signal.h>

/*
 * Signal trampoline code for the Power PC.
 * The kernel allocates a minimal stack frame below the sigframe,
 * so that we have a place to store our (unused) LR.
 */

typedef void (*bsd_sig_t)(int, int, struct sigcontext *);

void
_sigtramp(int signal, int code, struct sigcontext *scp, bsd_sig_t handler)
{

	handler(signal, code, scp);
	sigreturn(scp);
	/* never returns */
}
