/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI brk.c,v 1.1 1995/12/18 21:50:33 donn Exp
 */

/*
 * Heap allocation.
 */

#include <sys/syscall.h>
#include <errno.h>
#include <unistd.h>

extern char *_minbrk;
extern char *_curbrk;

char *
brk(const char *new)
{

	if (new < _minbrk)
		new = _minbrk;
	if (syscall(SYS_break, new) == -1)
		return ((char *)-1);
	_curbrk = (char *)new;
	return (_curbrk);
}
