/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI sigsetjmp.c,v 1.2 1996/01/04 03:12:50 donn Exp
 */

#include <setjmp.h>
#include <signal.h>
#include <unistd.h>

extern int __save_context(int, sigjmp_buf);
extern void __restore_context(int, sigjmp_buf);

/*
 * This function must have a frame exactly 4 words long,
 * so it must be compiled with at least -O1 optimization.
 * It must be at least 4 words anyway because it isn't a leaf function.
 * __save_context() copies the stack frame into the sigjmp_buf.
 */
int
sigsetjmp(sigjmp_buf env, int savemask)
{

	if (env->sjb_restore_mask = savemask)
		sigprocmask(SIG_SETMASK, NULL,
		    (sigset_t *)&env->sjb_buf.jb_mask);

	return (__save_context(0, env));
}

void
siglongjmp(sigjmp_buf env, int r)
{

	if (env->sjb_restore_mask)
		sigprocmask(SIG_SETMASK,
		    (sigset_t *)&env->sjb_buf.jb_mask, NULL);

	if (r == 0)
		r = 1;

	__restore_context(r, env);
	/* never returns */
}
