/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI setjmp.c,v 1.2 1996/01/04 03:12:49 donn Exp
 */

#include <setjmp.h>
#include <signal.h>
#include <unistd.h>

extern int __save_context(int, jmp_buf);
extern void __restore_context(int, jmp_buf);

/*
 * This function must have a frame exactly 4 words long,
 * so it must be compiled with at least -O1 optimization.
 * It must be at least 4 words anyway because it isn't a leaf function.
 * __save_context() copies the stack frame into the jmp_buf.
 */
int
setjmp(jmp_buf env)
{

	sigprocmask(SIG_SETMASK, NULL, (sigset_t *)&env->jb_mask);

	return (__save_context(0, env));
}

void
longjmp(jmp_buf env, int r)
{

	sigprocmask(SIG_SETMASK, (sigset_t *)&env->jb_mask, NULL);

	if (r == 0)
		r = 1;

	__restore_context(r, env);
	/* never returns */
}
