/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI save_context.s,v 1.2 1996/01/04 03:12:09 donn Exp
 */

/*
 * Save and restore context for the *jmp() functions on the Power PC.
 */

/*
 * typedef struct {
 *	int	jb_save_stack[4];
 *	int	jb_sp;
 *	int	jb_lr;
 *	int	jb_cr;
 *	int	jb_mask;
 *	int	jb_gpr[18];
 *	double	jb_fpr[18];
 *	int	jb_restore_mask;
 * } sigjmp_buf[1];
 *
 * int __save_context(int, sigjmp_buf);
 * void __restore_context(int, sigjmp_buf);
 */

	.globl __save_context
	.long 0
	.type __save_context,@function
__save_context:
	lwz 5,0(1)		/* save stack frame */
	lwz 6,4(1)
	lwz 7,8(1)
	lwz 8,12(1)
	mflr 9
	stw 5,0(4)
	stw 6,4(4)
	stw 7,8(4)
	mfcr 10
	stw 8,12(4)

	stw 1,16(4)		/* jb_sp */
	stw 9,20(4)		/* jb_lr */
	stw 10,24(4)		/* jb_cr */

	stmw 14,32(4)		/* jb_gpr */

	stfd 14,104(4)		/* jb_fpr */
	stfd 15,112(4)
	stfd 16,120(4)
	stfd 17,128(4)
	stfd 18,136(4)
	stfd 19,144(4)
	stfd 20,152(4)
	stfd 21,160(4)
	stfd 22,168(4)
	stfd 23,176(4)
	stfd 24,184(4)
	stfd 25,192(4)
	stfd 26,200(4)
	stfd 27,208(4)
	stfd 28,216(4)
	stfd 29,224(4)
	stfd 30,232(4)
	stfd 31,240(4)

	blr
.L.end.__save_context:
	.size __save_context,.L.end.__save_context-__save_context

	.globl __restore_context
	.long 0
	.type __restore_context,@function
__restore_context:
	lfd 31,240(4)		/* restore jb_fpr */
	lfd 30,232(4)
	lfd 29,224(4)
	lfd 28,216(4)
	lfd 27,208(4)
	lfd 26,200(4)
	lfd 25,192(4)
	lfd 24,184(4)
	lfd 23,176(4)
	lfd 22,168(4)
	lfd 21,160(4)
	lfd 20,152(4)
	lfd 19,144(4)
	lfd 18,136(4)
	lfd 17,128(4)
	lfd 16,120(4)
	lfd 15,112(4)
	lfd 14,104(4)

	lmw 14,32(4)		/* jb_gpr */

	lwz 11,24(4)		/* jb_cr */
	lwz 10,20(4)		/* jb_lr */
	mtcrf 0x20,11
	mtcrf 0x10,11
	lwz 1,16(4)		/* jb_sp */
	mtcrf 0x08,11
	lwz 5,0(4)		/* restore setjmp() stack frame */
	lwz 6,4(4)
	mtlr 10
	lwz 7,8(4)
	lwz 8,12(4)
	stw 5,0(1)
	stw 6,4(1)
	stw 7,8(1)
	stw 8,12(1)

	blr
