/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI SYS.h,v 1.2 1996/01/04 03:10:15 donn Exp
 */

#include <sys/syscall.h>

#ifdef PROF

XXX Currently, the compiler just aborts if you specify profiling!

#else

#define	ENTRY(n) \
	.section ".text"; \
	.globl n; \
	.align 2; \
	.long 0; \
	.type n,@function; \
n:

#endif

/* Be friendly to debuggers.  */
#define	ENDENTRY(n) \
.L.end.n: \
	.size n,L.end.n-n

#define	SYSCALL(n) \
	.section ".text"; \
	.align 2; \
2: \
	b __cerror; \
	ENTRY(n); \
	li 0,SYS_/**/n; \
	sc; \
	bso 2b; \
	blr

#define	RSYSCALL(n) \
	SYSCALL(n); \
	ENDENTRY(n)

#define	PSEUDO(n,p) \
	ENTRY(n); \
	li 0,SYS_/**/p; \
	sc; \
	ENDENTRY(n)

#define	ASMSTR		.string
