/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI getifaddrs.c,v 2.1 1995/10/18 08:55:02 prb Exp
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#ifdef	NET_RT_IFLIST
#include <sys/param.h>
#include <net/route.h>
#include <sys/sysctl.h>
#include <net/if_dl.h>
#endif

#include <errno.h>
#include <ifaddrs.h>
#include <stdlib.h>

#if !defined(AF_LINK)
#define	SA_LEN(sa)	sizeof(struct sockaddr)
#endif

#if !defined(SA_LEN)
#define	SA_LEN(sa)	(sa)->sa_len
#endif

#define	SALIGN	(sizeof(void *) - 1)
#define	SA_RLEN(sa)	(((sa)->sa_len + SALIGN) & ~SALIGN)

int
getifaddrs(struct ifaddrs **pif, int *pni)
{
	int icnt = 1;
	int dcnt = 0;
	int ncnt = 0;
#ifdef	NET_RT_IFLIST
	int mib[6];
	size_t needed;
	char *buf;
	char *next;
	struct ifaddrs *cif = 0;
	char *p;
	struct rt_msghdr *rtm;
	struct if_msghdr *ifm;
	struct ifa_msghdr *ifam;
	struct sockaddr_dl *dl;
	struct sockaddr *sa;
	u_short index = 0;
#else
	char buf[1024];
#endif
	struct ifconf ifc;
	struct ifreq *ifr;
	struct ifreq *lifr;
	int i, m;
	struct ifaddrs *ifa, *ift;
	char *data;
	char *names;
	int sock;

#ifdef	NET_RT_IFLIST
	mib[0] = CTL_NET;
	mib[1] = PF_ROUTE;
	mib[2] = 0;             /* protocol */
	mib[3] = 0;             /* wildcard address family */
	mib[4] = NET_RT_IFLIST;
	mib[5] = 0;             /* no flags */
	if (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0)
		return (-1);
	if ((buf = malloc(needed)) == NULL)
		return (-1);
	if (sysctl(mib, 6, buf, &needed, NULL, 0) < 0)
		return (-1);

	for (next = buf; next < buf + needed; next += rtm->rtm_msglen) {
		rtm = (struct rt_msghdr *)next;
		if (rtm->rtm_version != RTM_VERSION)
			continue;
		switch (rtm->rtm_type) {
		case RTM_IFINFO:
			ifm = (struct if_msghdr *)rtm;
			if (ifm->ifm_addrs & RTA_IFP) {
				index = ifm->ifm_index;
				++icnt;
				dl = (struct sockaddr_dl *)(ifm + 1);
				dcnt += SA_RLEN((struct sockaddr *)dl);
				ncnt += dl->sdl_nlen + 1;
			} else
				index = 0;
			break;

		case RTM_NEWADDR:
			ifam = (struct ifa_msghdr *)rtm;
			if (index && ifam->ifam_index != index)
				abort();	/* this cannot happen */

#define	RTA_MASKS	RTA_NETMASK | RTA_IFA | RTA_BRD
			if (index == 0 || (ifam->ifam_addrs & RTA_MASKS) == 0)
				break;
			p = (char *)(ifam + 1);
			++icnt;
			for (i = 1; i < 0x100; i <<= 1) {
				if ((ifam->ifam_addrs & i) == 0)
					continue;
				if (i & RTA_MASKS)
					dcnt += SA_RLEN((struct sockaddr *)p);
				p += SA_RLEN((struct sockaddr *)p);
			}
			break;
		}
	}
#else
	ifc.ifc_buf = buf;
	ifc.ifc_len = sizeof(buf);

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		return (-1);
	i =  ioctl(sock, SIOCGIFCONF, (char *)&ifc);
	close(sock);
	if (i < 0)
		return (-1);

	ifr = ifc.ifc_req;
	lifr = (struct ifreq *)&ifc.ifc_buf[ifc.ifc_len];

	while (ifr < lifr) {
		struct sockaddr *sa;

		sa = &ifr->ifr_addr;
		++icnt;
		dcnt += SA_RLEN(sa);
		ncnt += sizeof(ifr->ifr_name) + 1;
		
		ifr = (struct ifreq *)(((char *)sa) + SA_LEN(sa));
	}
#endif

	if ((data = malloc(sizeof(struct ifaddrs) * icnt+dcnt+ncnt)) == NULL)
		return(-1);

	ifa = (struct ifaddrs *)data;
	data += sizeof(struct ifaddrs) * icnt;
	names = data + dcnt;

	memset(ifa, 0, sizeof(struct ifaddrs) * icnt);
	ift = ifa;

#ifdef	NET_RT_IFLIST
	index = 0;
	for (next = buf; next < buf + needed; next += rtm->rtm_msglen) {
		rtm = (struct rt_msghdr *)next;
		if (rtm->rtm_version != RTM_VERSION)
			continue;
		switch (rtm->rtm_type) {
		case RTM_IFINFO:
			ifm = (struct if_msghdr *)rtm;
			if (ifm->ifm_addrs & RTA_IFP) {
				index = ifm->ifm_index;
				dl = (struct sockaddr_dl *)(ifm + 1);

				cif = ift;
				ift->ifa_name = names;
				ift->ifa_flags = (int)ifm->ifm_flags;
				memcpy(names, dl->sdl_data, dl->sdl_nlen);
				names[dl->sdl_nlen] = 0;
				names += dl->sdl_nlen + 1;

				ift->ifa_addr = (struct sockaddr *)data;
				memcpy(data, dl, SA_LEN((struct sockaddr *)dl));
				data += SA_RLEN((struct sockaddr *)dl);

				++ift;
			} else
				index = 0;
			break;

		case RTM_NEWADDR:
			ifam = (struct ifa_msghdr *)rtm;
			if (index && ifam->ifam_index != index)
				abort();	/* this cannot happen */

			if (index == 0 || (ifam->ifam_addrs & RTA_MASKS) == 0)
				break;
			ift->ifa_name = cif->ifa_name;
			ift->ifa_flags = cif->ifa_flags;
			p = (char *)(ifam + 1);
			for (i = 1; i < 0x100; i <<= 1) {
				if ((ifam->ifam_addrs & i) == 0)
					continue;
				sa = (struct sockaddr *)p;
				switch (i) {
				case RTA_IFP:
					ift->ifa_addr = (struct sockaddr *)data;
					memcpy(data, p, SA_LEN(sa));
					data += SA_RLEN(sa);
					break;

				case RTA_NETMASK:
					ift->ifa_netmask =
					    (struct sockaddr *)data;
					memcpy(data, p, SA_LEN(sa));
					data += SA_RLEN(sa);
					break;

				case RTA_BRD:
					ift->ifa_broadaddr =
					    (struct sockaddr *)data;
					memcpy(data, p, SA_LEN(sa));
					data += SA_RLEN(sa);
					break;
				}
				p += SA_RLEN(sa);
			}
			++ift;
			break;
		}
	}
#else
	ifr = ifc.ifc_req;
	lifr = (struct ifreq *)&ifc.ifc_buf[ifc.ifc_len];

	while (ifr < lifr) {
		struct sockaddr *sa;

		ift->ifa_name = names;
		names[sizeof(ifr->ifr_name)] = 0;
		strncpy(names, ifr->ifr_name, sizeof(ifr->ifr_name));
		while (*names++)
			;

		ift->ifa_addr = (struct sockaddr *)data;
		sa = &ifr->ifr_addr;
		memcpy(data, sa, SA_LEN(sa));
		data += SA_RLEN(sa);
		
		ifr = (struct ifreq *)(((char *)sa) + SA_LEN(sa));
		++ift;
	}
#endif
	*pif = ifa;
	if (pni)
		*pni = icnt - 1;
	return (0);
}
