/*	BSDI setjmp.h,v 2.4 1995/12/21 05:15:31 donn Exp	*/

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)setjmp.h	8.2 (Berkeley) 1/21/94
 */

#ifndef _SETJMP_H_
#define _SETJMP_H_

#if defined(hp300) || defined(__hp300__) || defined(luna68k) || defined(__luna68k__)
#define _JBLEN	17
#endif

#if defined(i386) || defined(__i386__)
#define _JBLEN	10
#endif

#if defined(mips) || defined(__mips__)
#define _JBLEN	83
#endif

#if defined(sparc) || defined(__sparc__)
#define	_JBLEN	9	/* same size as SunOS */
#endif

#if defined(tahoe) || defined(__tahoe__)
#define _JBLEN	10
#endif

#if defined(vax) || defined(__vax__)
#define _JBLEN	10
#endif

#if defined(__powerpc__)
#define	_JBLEN	62
#endif

#if !defined(_ANSI_SOURCE) || defined(_POSIX_SOURCE)
typedef int sigjmp_buf[_JBLEN + 1];
#endif /* not ANSI */

typedef int jmp_buf[_JBLEN];

#include <sys/cdefs.h>

__BEGIN_DECLS
int	setjmp __P((jmp_buf));
__dead void
	longjmp __P((jmp_buf, int)) __attribute__((__volatile));

#if !defined(_ANSI_SOURCE) || defined(_POSIX_SOURCE)
int	sigsetjmp __P((sigjmp_buf, int));
__dead void
	siglongjmp __P((sigjmp_buf, int)) __attribute__((__volatile));
#endif /* not ANSI */

#if !defined(_ANSI_SOURCE) && !defined(_POSIX_SOURCE)
int	_setjmp __P((jmp_buf));
__dead void
	_longjmp __P((jmp_buf, int)) __attribute__((__volatile));
#endif /* neither ANSI nor POSIX */
__END_DECLS

#endif /* !_SETJMP_H_ */
